variable "account_id" {
  type        = string
  description = "AWS account the PrivateLink should be setup."
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS region the PrivateLink should be setup."
}

variable "app_name" {
  type        = string
  description = "Application name to create the PrivateLink setup."
}

variable "environment" {
  type        = string
  default     = "development"
  description = "Environment PrivateLink setup is for."
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "businessviewcount/aperture"
  description = "GitHub repository name"
}

variable "team" {
  type        = string
  default     = "Creator Experience"
  description = "Twitch team name"
}

variable "internal_alb_dns_name" {
  type        = string
  description = "DNS name for the load balancer."
}

variable "vpc_id" {
  type        = string
  description = "VPC the PrivateLink should be setup."
}

variable "private_subnets" {
  type        = list(string)
  description = "Twitch businessviewcount private subnets"
}

variable "vpc_endpoint_service_allowed_principals" {
  type        = list(string)
  description = "the arns that are whitelisted to access the VPC endpoint service"
}
