data "aws_route53_zone" "multiplex" {
  vpc_id       = var.vpc_id
  name         = "multiplex.twitch.a2z.com"
  private_zone = true
}

resource "aws_vpc_endpoint" "multiplex" {
  vpc_id             = var.vpc_id
  vpc_endpoint_type  = "Interface"
  service_name       = var.multiplex_service_name
  subnet_ids         = var.private_subnets
  security_group_ids = [var.security_group]
}

resource "aws_route53_record" "multiplex" {
  zone_id = data.aws_route53_zone.multiplex.zone_id
  name    = "${var.multiplex_environment}.multiplex.twitch.a2z.com"
  type    = "CNAME"
  ttl     = 300

  records = [aws_vpc_endpoint.multiplex.dns_entry.0.dns_name]
}
