locals {
  environment    = "production"
  aws_account_id = "989470033077"
  aws_key_name   = "cb-aperture-production"
  aws_profile    = "twitch-cb-aws"
  aws_region     = "us-west-2"

  private_subnets = ["subnet-45e7ad0c", "subnet-6f4a7808", "subnet-86fe23dd"]
  security_group  = "sg-57251d2c"
  vpc_id          = "vpc-7851b71e"
}

terraform {
  required_version = ">= 0.11.10"

  backend "s3" {
    bucket  = "cb-aperture-terraform-prod"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "parameters" {
  source      = "../modules/parameters"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region
}

module "aperture" {
  source         = "../modules/aperture"
  environment    = local.environment
  aws_account_id = local.aws_account_id
  aws_key_name   = local.aws_key_name
  aws_profile    = local.aws_profile
  aws_region     = local.aws_region

  asg_max_size  = 10
  asg_min_size  = 5
  instance_size = "c5.4xlarge"

  private_subnets = local.private_subnets
  security_group  = local.security_group
  vpc_id          = local.vpc_id

  sandstorm_iam_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/aperture-production"
}

module "kinesis" {
  source      = "../modules/kinesis"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group

  shard_count = 250
  stream_name = "spade-downstream-prod-cb-aperture-prod-mw"

  pagerduty_sns_topic = module.cloudwatch.pagerduty_sns_topic
}

module "spade_logger" {
  source      = "../modules/lambda/spade_logger"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group
}

module "pubsub_sender" {
  source      = "../modules/lambda/pubsub_sender"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group
}

module "elasticache" {
  source      = "../modules/elasticache"
  environment = "prod"
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group

  # Capacity properties
  elasticache_node_type       = "cache.r3.2xlarge"
  elasticache_node_count      = "10"
  elasticache_redis_node_type = "cache.r4.xlarge"
  elasticache_redis_num_nodes = "3"
}

module "cloudwatch" {
  source      = "../modules/cloudwatch"
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  elastic_beanstalk_environment_name  = module.aperture.elastic_beanstalk_environment_name
  elastic_beanstalk_loadbalancer_name = module.aperture.elastic_beanstalk_environment_load_balancer
  elastic_beanstalk_asg_name          = module.aperture.elastic_beanstalk_environment_asg
  elasticache_cluster_id              = module.elasticache.elasticache_cluster_id
  kinesis_analytics_app_name          = module.kinesis.kinesis_analytics_app_name
  mw_ratio_lambda_name                = module.kinesis.mw_ratio_lambda_name
  error_stream_logger_lambda_name     = module.kinesis.error_stream_logger_lambda_name
  pagerduty_endpoint                  = "https://events.pagerduty.com/integration/f3c2ff9b8dd74494b06c3640127014ee/enqueue"
  spade_logger_lambda_name            = module.spade_logger.lambda_function_name
  pubsub_sender_lambda_name           = module.pubsub_sender.lambda_function_name

  # Frozone Alarm - Pages VAX
  vax_pagerduty_url          = "https://events.pagerduty.com/integration/19775b9184b34635acdfd9a8c16a92e9/enqueue"
  curr_connections_threshold = 2000
  aperture_redis_cluster_id  = module.elasticache.aperture_redis_cluster_id
}

module "vpc_endpoint_service" {
  source = "../modules/vpc_endpoint_service"

  environment = local.environment
  account_id  = local.aws_account_id
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  app_name              = "cb-aperture"
  internal_alb_dns_name = "cb-aperture-production-api.us-west-2.elasticbeanstalk.com"

  vpc_id          = local.vpc_id
  private_subnets = local.private_subnets

  vpc_endpoint_service_allowed_principals = [
    "arn:aws:iam::151628703045:root", # twitch-liveline-prod
    "arn:aws:iam::737882373154:root", # boba-prod
    "arn:aws:iam::072752548172:root", # twitch-blender-prod
  ]
}

module "vpc_endpoints" {
  source = "../modules/vpc_endpoints"

  private_subnets = local.private_subnets
  security_group  = local.security_group
  vpc_id          = local.vpc_id

  multiplex_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-067bd16a03d8c9f60"
  multiplex_environment  = "production-internal"
  blender_service_name   = "com.amazonaws.vpce.us-west-2.vpce-svc-02fc58779ed323c6e"
  blender_environment    = "production"
}
