locals {
  environment    = "staging"
  aws_account_id = "989470033077"
  aws_key_name   = "cb-aperture-staging"
  aws_profile    = "twitch-cb-aws"
  aws_region     = "us-west-2"

  private_subnets = ["subnet-45e7ad0c", "subnet-6f4a7808", "subnet-86fe23dd"]
  security_group  = "sg-57251d2c"
  vpc_id          = "vpc-7851b71e"
}

terraform {
  required_version = ">= 0.11.10"

  backend "s3" {
    bucket  = "cb-aperture-terraform-staging"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "parameters" {
  source      = "../modules/parameters"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region
}

module "aperture" {
  source         = "../modules/aperture"
  environment    = local.environment
  aws_account_id = local.aws_account_id
  aws_key_name   = local.aws_key_name
  aws_profile    = local.aws_profile
  aws_region     = local.aws_region

  asg_max_size  = 10
  asg_min_size  = 5
  instance_size = "c5.4xlarge"

  private_subnets = local.private_subnets
  security_group  = local.security_group
  vpc_id          = local.vpc_id

  sandstorm_iam_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/aperture-staging"
  allow_assume_role_arn  = "arn:aws:iam::989470033077:user/devtools-jenkins"
}

module "kinesis" {
  source      = "../modules/kinesis"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group

  shard_count = 250
  stream_name = "spade-downstream-prod-cb-aperture-staging-mw"
}

module "spade_logger" {
  source      = "../modules/lambda/spade_logger"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group
}

module "pubsub_sender" {
  source      = "../modules/lambda/pubsub_sender"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group
}

module "elasticache" {
  source      = "../modules/elasticache"
  environment = local.environment
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  private_subnets = local.private_subnets
  security_group  = local.security_group

  # Capacity properties
  elasticache_node_type       = "cache.r3.2xlarge"
  elasticache_node_count      = "10"
  elasticache_redis_node_type = "cache.r4.xlarge"
  elasticache_redis_num_nodes = "3"
}

module "vpc_endpoint_service" {
  source = "../modules/vpc_endpoint_service"

  environment = local.environment
  account_id  = local.aws_account_id
  aws_profile = local.aws_profile
  aws_region  = local.aws_region

  app_name              = "cb-aperture"
  internal_alb_dns_name = "cb-aperture-staging-api.us-west-2.elasticbeanstalk.com"

  vpc_id          = local.vpc_id
  private_subnets = local.private_subnets

  vpc_endpoint_service_allowed_principals = [
    "arn:aws:iam::411083028944:root", # twitch-liveline-dev
    "arn:aws:iam::726281605084:root", # boba-dev
    "arn:aws:iam::072752548172:root", # twitch-blender-prod
  ]
}

module "vpc_endpoints" {
  source = "../modules/vpc_endpoints"

  private_subnets = local.private_subnets
  security_group  = local.security_group
  vpc_id          = local.vpc_id

  multiplex_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0dc2e6960f0517893"
  multiplex_environment  = "staging"
  blender_service_name   = "com.amazonaws.vpce.us-west-2.vpce-svc-0f38ce51685ff2180"
  blender_environment    = "staging"
}
