package httpproto

// A MethodSpec describes a logical protobuf RPC method, which may be mapped
// to and from HTTP calls.
type MethodSpec struct {
	// Fully-qualified name of the method, e.g.
	// "/path.to.package.Service/Method"
	FullName string
	// Fully-qualified name of the protobuf message used as an argument
	InputType string
	// Fully-qualified name of the protobuf message used for responses
	OutputType string
	// List of rules for mapping this method to and from HTTP requests
	Routes []*RouteSpec
}

// A RouteSpec describes a single HTTP request pattern. It corresponds to a
// single (non-nested) google.api.HttpRule, though it may be provided from a
// different source.
type RouteSpec struct {
	// The HTTP method for the request
	HTTPMethod string
	// The URI pattern, as described in google/api/http.proto
	PathPattern string
	// A protobuf field selector (dot-delimited list of field names) to use
	// for the request body
	BodyField string
}
