// Code generated by protoc-gen-go.
// source: pkg/dgn/dgn.proto
// DO NOT EDIT!

/*
Package dgn is a generated protocol buffer package.

It is generated from these files:
	pkg/dgn/dgn.proto

It has these top-level messages:
	Channel
	RedundancyProperties
	TranscodeStack
	Stream
	StreamAuthRequest
	ChannelRequest
	StreamRequest
	HealthRequest
	Health
	AllStreamsRequest
	StreamList
	SetStreamHealthRequest
	SetStreamHealthResponse
	UpdateMetadataRequest
	UpdateMetadataResponse
	UpdateRedundancySourceRequest
	UpdateRedundancySourceResponse
	CheckIngestHealthResponse
	PutIngestMetadataRequest
	PutIngestMetadataResponse
*/
package dgn

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/duration"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

type RedundancyProperties_SlateBrand int32

const (
	RedundancyProperties_WHITE_LABEL RedundancyProperties_SlateBrand = 0
	RedundancyProperties_PURPLE      RedundancyProperties_SlateBrand = 1
)

var RedundancyProperties_SlateBrand_name = map[int32]string{
	0: "WHITE_LABEL",
	1: "PURPLE",
}
var RedundancyProperties_SlateBrand_value = map[string]int32{
	"WHITE_LABEL": 0,
	"PURPLE":      1,
}

func (x RedundancyProperties_SlateBrand) String() string {
	return proto.EnumName(RedundancyProperties_SlateBrand_name, int32(x))
}
func (RedundancyProperties_SlateBrand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 0}
}

// A channel contains all streams associated with that channel.
// i.e. channel = "lirik", streams = {live, backup, delay}
type Channel struct {
	Streams []*Stream `protobuf:"bytes,1,rep,name=streams" json:"streams,omitempty"`
}

func (m *Channel) Reset()                    { *m = Channel{} }
func (m *Channel) String() string            { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()               {}
func (*Channel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Channel) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

// Information surrounding which redundancy features are allowed
type RedundancyProperties struct {
	// Try to connect to backup streams on disconnect
	AllowFailoverToBackup bool `protobuf:"varint,1,opt,name=allow_failover_to_backup,json=allowFailoverToBackup" json:"allow_failover_to_backup,omitempty"`
	// Show a slate on disconnect
	DisconnectSlateDuration *google_protobuf.Duration       `protobuf:"bytes,2,opt,name=disconnect_slate_duration,json=disconnectSlateDuration" json:"disconnect_slate_duration,omitempty"`
	SlateBrand              RedundancyProperties_SlateBrand `protobuf:"varint,3,opt,name=slate_brand,json=slateBrand,enum=dgn.RedundancyProperties_SlateBrand" json:"slate_brand,omitempty"`
}

func (m *RedundancyProperties) Reset()                    { *m = RedundancyProperties{} }
func (m *RedundancyProperties) String() string            { return proto.CompactTextString(m) }
func (*RedundancyProperties) ProtoMessage()               {}
func (*RedundancyProperties) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RedundancyProperties) GetDisconnectSlateDuration() *google_protobuf.Duration {
	if m != nil {
		return m.DisconnectSlateDuration
	}
	return nil
}

type TranscodeStack struct {
	TranscodeType string `protobuf:"bytes,1,opt,name=transcode_type,json=transcodeType" json:"transcode_type,omitempty"`
	EncoderType   string `protobuf:"bytes,2,opt,name=encoder_type,json=encoderType" json:"encoder_type,omitempty"`
}

func (m *TranscodeStack) Reset()                    { *m = TranscodeStack{} }
func (m *TranscodeStack) String() string            { return proto.CompactTextString(m) }
func (*TranscodeStack) ProtoMessage()               {}
func (*TranscodeStack) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// A stream represents a single RTMP ingest
type Stream struct {
	// "lirik"
	Channel string `protobuf:"bytes,1,opt,name=channel" json:"channel,omitempty"`
	// live, backup, delay, spanish? camera angles? mostly just live for now.
	Format string `protobuf:"bytes,2,opt,name=format" json:"format,omitempty"`
	// connect here with RTMP to pull the channel
	RTMPEndpoint string `protobuf:"bytes,3,opt,name=RTMP_endpoint,json=RTMPEndpoint" json:"RTMP_endpoint,omitempty"`
	// make twirp requests to [NGST](https://git-aws.internal.justin.tv/video/goingest/tree/master/pkg/ngst/ngst.md) here to do things like make sure the stream still exists
	TwirpEndpoint string `protobuf:"bytes,11,opt,name=twirp_endpoint,json=twirpEndpoint" json:"twirp_endpoint,omitempty"`
	// unique sessionID tied to the broadcast. not really used for anything now.
	SessionID string `protobuf:"bytes,6,opt,name=sessionID" json:"sessionID,omitempty"`
	// url-style params that came in with the stream key
	Params map[string]string `protobuf:"bytes,7,rep,name=params" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// whether the daemon has successfully retreived this stream recently
	Healthy bool `protobuf:"varint,8,opt,name=healthy" json:"healthy,omitempty"`
	// unix epoch of when the stream was last successfully retreived
	LastSeen int64 `protobuf:"varint,9,opt,name=last_seen,json=lastSeen" json:"last_seen,omitempty"`
	// mimicking the old usher behavior of delay_length
	DelayLength uint32 `protobuf:"varint,10,opt,name=delay_length,json=delayLength" json:"delay_length,omitempty"`
	// RTMP Metadata associated with a stream
	RtmpMetadata map[string]string `protobuf:"bytes,12,rep,name=rtmp_metadata,json=rtmpMetadata" json:"rtmp_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ChannelId    string            `protobuf:"bytes,14,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// Client IP assosciated with the specific stream
	ClientIp string `protobuf:"bytes,15,opt,name=client_ip,json=clientIp" json:"client_ip,omitempty"`
	// S3 bucket to be used for this broadcast
	S3Bucket string `protobuf:"bytes,16,opt,name=s3_bucket,json=s3Bucket" json:"s3_bucket,omitempty"`
	// The SNS ARN to be used to send notifcations for this bucket
	SnsEndpoint string `protobuf:"bytes,17,opt,name=sns_endpoint,json=snsEndpoint" json:"sns_endpoint,omitempty"`
	// The S3 prefix to be used for this broadcast
	S3Prefix string `protobuf:"bytes,18,opt,name=s3_prefix,json=s3Prefix" json:"s3_prefix,omitempty"`
	// This represents the time at which the stream started
	StartTime int64 `protobuf:"varint,19,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The full rtmp Url which can be used for playback and gotranscoder to connect to
	RtmpUrl string `protobuf:"bytes,20,opt,name=rtmp_url,json=rtmpUrl" json:"rtmp_url,omitempty"`
	// The CDN url which is to be used to record static vod manifests , used for LVS streams
	CdnUrl string `protobuf:"bytes,21,opt,name=cdn_url,json=cdnUrl" json:"cdn_url,omitempty"`
	// flag which specifies if we are using low latency mode here
	LowLatency bool `protobuf:"varint,22,opt,name=low_latency,json=lowLatency" json:"low_latency,omitempty"`
	// number of consecutive failed health checks
	FailedHealthChecks int64 `protobuf:"varint,23,opt,name=failed_health_checks,json=failedHealthChecks" json:"failed_health_checks,omitempty"`
	// Capabilities surrounding which redundancy features are allowed
	RedundancyProperties *RedundancyProperties `protobuf:"bytes,24,opt,name=redundancy_properties,json=redundancyProperties" json:"redundancy_properties,omitempty"`
	// Latency mode for the broadcast, this seeting in Digestion is mainly used for LVS
	// latency mode for twitch streams are stored in channel properties
	LatencyMode            string            `protobuf:"bytes,25,opt,name=latency_mode,json=latencyMode" json:"latency_mode,omitempty"`
	RedundancySourceStream *StreamRequest    `protobuf:"bytes,26,opt,name=redundancy_source_stream,json=redundancySourceStream" json:"redundancy_source_stream,omitempty"`
	TranscodeStacks        []*TranscodeStack `protobuf:"bytes,27,rep,name=transcode_stacks,json=transcodeStacks" json:"transcode_stacks,omitempty"`
}

func (m *Stream) Reset()                    { *m = Stream{} }
func (m *Stream) String() string            { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()               {}
func (*Stream) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Stream) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Stream) GetRtmpMetadata() map[string]string {
	if m != nil {
		return m.RtmpMetadata
	}
	return nil
}

func (m *Stream) GetRedundancyProperties() *RedundancyProperties {
	if m != nil {
		return m.RedundancyProperties
	}
	return nil
}

func (m *Stream) GetRedundancySourceStream() *StreamRequest {
	if m != nil {
		return m.RedundancySourceStream
	}
	return nil
}

func (m *Stream) GetTranscodeStacks() []*TranscodeStack {
	if m != nil {
		return m.TranscodeStacks
	}
	return nil
}

type StreamAuthRequest struct {
	// widely referred to elsewhere as just 'stream key', i call this fullStreamKey to distinguish it from
	// just the SHA1 as web considers a streamkey
	// looks like `live_123355_aksldjfhlksdjfh` or however an authorized key looks
	// basically whatever you could put into obs as a stream key will work here
	// params will be broken into the `params`
	FullStreamKey string `protobuf:"bytes,1,opt,name=fullStreamKey" json:"fullStreamKey,omitempty"`
	// the internal NGST/usher name for the stream, like `live_user_lirik`
	RTMPName string `protobuf:"bytes,2,opt,name=RTMP_name,json=RTMPName" json:"RTMP_name,omitempty"`
	// when authing, NGST must fill out these endpoints so that clients can pull/query the live streams
	RTMPEndpoint string `protobuf:"bytes,3,opt,name=RTMP_endpoint,json=RTMPEndpoint" json:"RTMP_endpoint,omitempty"`
	// when authing, NGST must fill out these endpoints so that clients can pull/query the live streams
	JSONEndpoint string `protobuf:"bytes,4,opt,name=JSON_endpoint,json=JSONEndpoint" json:"JSON_endpoint,omitempty"`
	// when authing, NGST must fill out these endpoints so that clients can pull/query the live streams
	GRPCEndpoint string `protobuf:"bytes,5,opt,name=GRPC_endpoint,json=GRPCEndpoint" json:"GRPC_endpoint,omitempty"`
	// when authing, NGST must fill out these endpoints so that clients can pull/query the live streams
	TwirpEndpoint string `protobuf:"bytes,6,opt,name=twirp_endpoint,json=twirpEndpoint" json:"twirp_endpoint,omitempty"`
	Uuid          string `protobuf:"bytes,7,opt,name=uuid" json:"uuid,omitempty"`
	ClientIp      string `protobuf:"bytes,8,opt,name=client_ip,json=clientIp" json:"client_ip,omitempty"`
}

func (m *StreamAuthRequest) Reset()                    { *m = StreamAuthRequest{} }
func (m *StreamAuthRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamAuthRequest) ProtoMessage()               {}
func (*StreamAuthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// uniquely identifies a channel
type ChannelRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel" json:"channel,omitempty"`
}

func (m *ChannelRequest) Reset()                    { *m = ChannelRequest{} }
func (m *ChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*ChannelRequest) ProtoMessage()               {}
func (*ChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// uniquely identifies a stream
type StreamRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel" json:"channel,omitempty"`
	Format  string `protobuf:"bytes,2,opt,name=format" json:"format,omitempty"`
	// optional session_id, to ensure the correct session is specified (useful on delete)
	SessionID string `protobuf:"bytes,3,opt,name=sessionID" json:"sessionID,omitempty"`
}

func (m *StreamRequest) Reset()                    { *m = StreamRequest{} }
func (m *StreamRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamRequest) ProtoMessage()               {}
func (*StreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type HealthRequest struct {
}

func (m *HealthRequest) Reset()                    { *m = HealthRequest{} }
func (m *HealthRequest) String() string            { return proto.CompactTextString(m) }
func (*HealthRequest) ProtoMessage()               {}
func (*HealthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type Health struct {
	Info string `protobuf:"bytes,1,opt,name=info" json:"info,omitempty"`
}

func (m *Health) Reset()                    { *m = Health{} }
func (m *Health) String() string            { return proto.CompactTextString(m) }
func (*Health) ProtoMessage()               {}
func (*Health) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// used for scanning digestion db, you must indicate what shard you are part of.
// if you just want to scan the entire db, set segment to 0 and total_segments to 1
type AllStreamsRequest struct {
	// which scan shard member you are
	Segment int64 `protobuf:"varint,1,opt,name=segment" json:"segment,omitempty"`
	// how many scan shard members tehre are in total
	TotalSegments int64 `protobuf:"varint,2,opt,name=total_segments,json=totalSegments" json:"total_segments,omitempty"`
}

func (m *AllStreamsRequest) Reset()                    { *m = AllStreamsRequest{} }
func (m *AllStreamsRequest) String() string            { return proto.CompactTextString(m) }
func (*AllStreamsRequest) ProtoMessage()               {}
func (*AllStreamsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type StreamList struct {
	Streams []*Stream `protobuf:"bytes,1,rep,name=streams" json:"streams,omitempty"`
}

func (m *StreamList) Reset()                    { *m = StreamList{} }
func (m *StreamList) String() string            { return proto.CompactTextString(m) }
func (*StreamList) ProtoMessage()               {}
func (*StreamList) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *StreamList) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type SetStreamHealthRequest struct {
	// uniquely identify a stream
	StreamRequest *StreamRequest `protobuf:"bytes,1,opt,name=stream_request,json=streamRequest" json:"stream_request,omitempty"`
	// if healthy, set healthy to true and set last_seen to now
	// otherwise, set healthy to false and dont touch last_seen
	Healthy bool `protobuf:"varint,2,opt,name=healthy" json:"healthy,omitempty"`
	// number of consecutive failed health checks
	FailedHealthChecks int64 `protobuf:"varint,3,opt,name=failed_health_checks,json=failedHealthChecks" json:"failed_health_checks,omitempty"`
}

func (m *SetStreamHealthRequest) Reset()                    { *m = SetStreamHealthRequest{} }
func (m *SetStreamHealthRequest) String() string            { return proto.CompactTextString(m) }
func (*SetStreamHealthRequest) ProtoMessage()               {}
func (*SetStreamHealthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *SetStreamHealthRequest) GetStreamRequest() *StreamRequest {
	if m != nil {
		return m.StreamRequest
	}
	return nil
}

type SetStreamHealthResponse struct {
}

func (m *SetStreamHealthResponse) Reset()                    { *m = SetStreamHealthResponse{} }
func (m *SetStreamHealthResponse) String() string            { return proto.CompactTextString(m) }
func (*SetStreamHealthResponse) ProtoMessage()               {}
func (*SetStreamHealthResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type UpdateMetadataRequest struct {
	// uniquely identify a stream
	StreamRequest *StreamRequest `protobuf:"bytes,1,opt,name=stream_request,json=streamRequest" json:"stream_request,omitempty"`
	// RTMP Metadata associated with a stream
	RtmpMetadata map[string]string `protobuf:"bytes,2,rep,name=rtmp_metadata,json=rtmpMetadata" json:"rtmp_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *UpdateMetadataRequest) Reset()                    { *m = UpdateMetadataRequest{} }
func (m *UpdateMetadataRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateMetadataRequest) ProtoMessage()               {}
func (*UpdateMetadataRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *UpdateMetadataRequest) GetStreamRequest() *StreamRequest {
	if m != nil {
		return m.StreamRequest
	}
	return nil
}

func (m *UpdateMetadataRequest) GetRtmpMetadata() map[string]string {
	if m != nil {
		return m.RtmpMetadata
	}
	return nil
}

type UpdateMetadataResponse struct {
}

func (m *UpdateMetadataResponse) Reset()                    { *m = UpdateMetadataResponse{} }
func (m *UpdateMetadataResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateMetadataResponse) ProtoMessage()               {}
func (*UpdateMetadataResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type UpdateRedundancySourceRequest struct {
	Stitcher *StreamRequest `protobuf:"bytes,1,opt,name=stitcher" json:"stitcher,omitempty"`
	Source   *StreamRequest `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
}

func (m *UpdateRedundancySourceRequest) Reset()                    { *m = UpdateRedundancySourceRequest{} }
func (m *UpdateRedundancySourceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRedundancySourceRequest) ProtoMessage()               {}
func (*UpdateRedundancySourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *UpdateRedundancySourceRequest) GetStitcher() *StreamRequest {
	if m != nil {
		return m.Stitcher
	}
	return nil
}

func (m *UpdateRedundancySourceRequest) GetSource() *StreamRequest {
	if m != nil {
		return m.Source
	}
	return nil
}

type UpdateRedundancySourceResponse struct {
}

func (m *UpdateRedundancySourceResponse) Reset()                    { *m = UpdateRedundancySourceResponse{} }
func (m *UpdateRedundancySourceResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRedundancySourceResponse) ProtoMessage()               {}
func (*UpdateRedundancySourceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

type CheckIngestHealthResponse struct {
	// The stream as found in DigestionDB
	Stream *Stream `protobuf:"bytes,1,opt,name=stream" json:"stream,omitempty"`
	// Whether the health check succeeded
	IngestOK bool `protobuf:"varint,2,opt,name=ingestOK" json:"ingestOK,omitempty"`
}

func (m *CheckIngestHealthResponse) Reset()                    { *m = CheckIngestHealthResponse{} }
func (m *CheckIngestHealthResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckIngestHealthResponse) ProtoMessage()               {}
func (*CheckIngestHealthResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CheckIngestHealthResponse) GetStream() *Stream {
	if m != nil {
		return m.Stream
	}
	return nil
}

type PutIngestMetadataRequest struct {
	// Channel name
	Channel string `protobuf:"bytes,1,opt,name=channel" json:"channel,omitempty"`
	// Metadata to insert encoded as a base64 string
	Metadata string `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// ISO-8601 UTC time that the client requested the metadata to be inserted.
	RequestedAt string `protobuf:"bytes,3,opt,name=requested_at,json=requestedAt" json:"requested_at,omitempty"`
	// SNS topic id to notify after insertion
	SnsTopicId string `protobuf:"bytes,4,opt,name=sns_topic_id,json=snsTopicId" json:"sns_topic_id,omitempty"`
}

func (m *PutIngestMetadataRequest) Reset()                    { *m = PutIngestMetadataRequest{} }
func (m *PutIngestMetadataRequest) String() string            { return proto.CompactTextString(m) }
func (*PutIngestMetadataRequest) ProtoMessage()               {}
func (*PutIngestMetadataRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

type PutIngestMetadataResponse struct {
}

func (m *PutIngestMetadataResponse) Reset()                    { *m = PutIngestMetadataResponse{} }
func (m *PutIngestMetadataResponse) String() string            { return proto.CompactTextString(m) }
func (*PutIngestMetadataResponse) ProtoMessage()               {}
func (*PutIngestMetadataResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func init() {
	proto.RegisterType((*Channel)(nil), "dgn.Channel")
	proto.RegisterType((*RedundancyProperties)(nil), "dgn.RedundancyProperties")
	proto.RegisterType((*TranscodeStack)(nil), "dgn.TranscodeStack")
	proto.RegisterType((*Stream)(nil), "dgn.Stream")
	proto.RegisterType((*StreamAuthRequest)(nil), "dgn.StreamAuthRequest")
	proto.RegisterType((*ChannelRequest)(nil), "dgn.ChannelRequest")
	proto.RegisterType((*StreamRequest)(nil), "dgn.StreamRequest")
	proto.RegisterType((*HealthRequest)(nil), "dgn.HealthRequest")
	proto.RegisterType((*Health)(nil), "dgn.Health")
	proto.RegisterType((*AllStreamsRequest)(nil), "dgn.AllStreamsRequest")
	proto.RegisterType((*StreamList)(nil), "dgn.StreamList")
	proto.RegisterType((*SetStreamHealthRequest)(nil), "dgn.SetStreamHealthRequest")
	proto.RegisterType((*SetStreamHealthResponse)(nil), "dgn.SetStreamHealthResponse")
	proto.RegisterType((*UpdateMetadataRequest)(nil), "dgn.UpdateMetadataRequest")
	proto.RegisterType((*UpdateMetadataResponse)(nil), "dgn.UpdateMetadataResponse")
	proto.RegisterType((*UpdateRedundancySourceRequest)(nil), "dgn.UpdateRedundancySourceRequest")
	proto.RegisterType((*UpdateRedundancySourceResponse)(nil), "dgn.UpdateRedundancySourceResponse")
	proto.RegisterType((*CheckIngestHealthResponse)(nil), "dgn.CheckIngestHealthResponse")
	proto.RegisterType((*PutIngestMetadataRequest)(nil), "dgn.PutIngestMetadataRequest")
	proto.RegisterType((*PutIngestMetadataResponse)(nil), "dgn.PutIngestMetadataResponse")
	proto.RegisterEnum("dgn.RedundancyProperties_SlateBrand", RedundancyProperties_SlateBrand_name, RedundancyProperties_SlateBrand_value)
}

var fileDescriptor0 = []byte{
	// 1428 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xeb, 0x6e, 0x1b, 0x45,
	0x14, 0xc6, 0x71, 0xeb, 0x38, 0xc7, 0x76, 0x12, 0x4f, 0x73, 0x99, 0x38, 0x6d, 0x71, 0x37, 0xad,
	0x14, 0xaa, 0xca, 0x29, 0x89, 0xb8, 0x94, 0x1f, 0xa0, 0xdc, 0x48, 0x43, 0xd3, 0xd6, 0xac, 0x1d,
	0x90, 0x10, 0xd2, 0x6a, 0xb2, 0x3b, 0xb1, 0x57, 0x59, 0xcf, 0x2e, 0x3b, 0xb3, 0x2d, 0x16, 0xcf,
	0x81, 0xc4, 0x1f, 0xc4, 0x23, 0xf0, 0x56, 0x3c, 0x01, 0x0f, 0x80, 0xe6, 0xb2, 0xf6, 0xae, 0x63,
	0xf7, 0x02, 0xfc, 0xb0, 0xb4, 0xe7, 0x3b, 0x67, 0xe6, 0x5c, 0xe6, 0x9c, 0x6f, 0xc6, 0x50, 0x8f,
	0xae, 0x7a, 0x3b, 0x5e, 0x8f, 0xc9, 0x5f, 0x2b, 0x8a, 0x43, 0x11, 0xa2, 0xa2, 0xd7, 0x63, 0x8d,
	0xbb, 0xbd, 0x30, 0xec, 0x05, 0x74, 0x47, 0x41, 0x17, 0xc9, 0xe5, 0x8e, 0x97, 0xc4, 0x44, 0xf8,
	0xa1, 0x31, 0xb2, 0x1e, 0xc3, 0xfc, 0x61, 0x9f, 0x30, 0x46, 0x03, 0xf4, 0x00, 0xe6, 0xb9, 0x88,
	0x29, 0x19, 0x70, 0x5c, 0x68, 0x16, 0xb7, 0x2b, 0xbb, 0x95, 0x96, 0xdc, 0xac, 0xa3, 0x30, 0x3b,
	0xd5, 0x59, 0xbf, 0xcd, 0xc1, 0x8a, 0x4d, 0xbd, 0x84, 0x79, 0x84, 0xb9, 0xc3, 0x76, 0x1c, 0x46,
	0x34, 0x16, 0x3e, 0xe5, 0xe8, 0x33, 0xc0, 0x24, 0x08, 0xc2, 0xd7, 0xce, 0x25, 0xf1, 0x83, 0xf0,
	0x15, 0x8d, 0x1d, 0x11, 0x3a, 0x17, 0xc4, 0xbd, 0x4a, 0x22, 0x5c, 0x68, 0x16, 0xb6, 0xcb, 0xf6,
	0xaa, 0xd2, 0x7f, 0x6d, 0xd4, 0xdd, 0xf0, 0x40, 0x29, 0xd1, 0x39, 0x6c, 0x78, 0x3e, 0x77, 0x43,
	0xc6, 0xa8, 0x2b, 0x1c, 0x1e, 0x10, 0x41, 0x9d, 0x34, 0x4c, 0x3c, 0xd7, 0x2c, 0x6c, 0x57, 0x76,
	0x37, 0x5a, 0x3a, 0x8f, 0x56, 0x9a, 0x47, 0xeb, 0xc8, 0x18, 0xd8, 0xeb, 0xe3, 0xb5, 0x1d, 0xb9,
	0x34, 0x55, 0xa0, 0x63, 0xa8, 0xe8, 0xbd, 0x2e, 0x62, 0xc2, 0x3c, 0x5c, 0x6c, 0x16, 0xb6, 0x17,
	0x77, 0xef, 0xab, 0x9c, 0xa6, 0xc5, 0xdf, 0x52, 0xab, 0x0f, 0xa4, 0xad, 0x0d, 0x7c, 0xf4, 0x6d,
	0x7d, 0x04, 0x30, 0xd6, 0xa0, 0x25, 0xa8, 0x7c, 0xff, 0xf4, 0xb4, 0x7b, 0xec, 0x9c, 0xed, 0x1f,
	0x1c, 0x9f, 0x2d, 0x7f, 0x80, 0x00, 0x4a, 0xed, 0x73, 0xbb, 0x7d, 0x76, 0xbc, 0x5c, 0xb0, 0x7e,
	0x80, 0xc5, 0x6e, 0x4c, 0x18, 0x77, 0x43, 0x8f, 0x76, 0x04, 0x71, 0xaf, 0xd0, 0x03, 0x58, 0x14,
	0x29, 0xe2, 0x88, 0x61, 0x44, 0x55, 0x25, 0x16, 0xec, 0xda, 0x08, 0xed, 0x0e, 0x23, 0x8a, 0xee,
	0x41, 0x95, 0x32, 0x29, 0xc5, 0xda, 0x68, 0x4e, 0x19, 0x55, 0x0c, 0x26, 0x4d, 0xac, 0x3f, 0xcb,
	0x50, 0xd2, 0x47, 0x81, 0x30, 0xcc, 0xbb, 0xfa, 0xcc, 0xcc, 0x6e, 0xa9, 0x88, 0xd6, 0xa0, 0x74,
	0x19, 0xc6, 0x03, 0x22, 0xcc, 0x0e, 0x46, 0x42, 0x5b, 0x50, 0xb3, 0xbb, 0xcf, 0xdb, 0x0e, 0x65,
	0x5e, 0x14, 0xfa, 0x4c, 0xa8, 0x62, 0x2c, 0xd8, 0x55, 0x09, 0x1e, 0x1b, 0x4c, 0xc5, 0xfa, 0xda,
	0x8f, 0xa3, 0xb1, 0x55, 0xc5, 0xc4, 0x2a, 0xd1, 0x91, 0xd9, 0x6d, 0x58, 0xe0, 0x94, 0x73, 0x3f,
	0x64, 0xa7, 0x47, 0xb8, 0xa4, 0x2c, 0xc6, 0x00, 0xda, 0x81, 0x52, 0x44, 0x62, 0xd9, 0x43, 0xf3,
	0xaa, 0x87, 0xd6, 0x33, 0x3d, 0xd4, 0x6a, 0x2b, 0xcd, 0x31, 0x13, 0xf1, 0xd0, 0x36, 0x66, 0x32,
	0x99, 0x3e, 0x25, 0x81, 0xe8, 0x0f, 0x71, 0x59, 0x35, 0x49, 0x2a, 0xa2, 0x4d, 0x58, 0x08, 0x08,
	0x17, 0x0e, 0xa7, 0x94, 0xe1, 0x85, 0x66, 0x61, 0xbb, 0x68, 0x97, 0x25, 0xd0, 0xa1, 0x94, 0xc9,
	0x8a, 0x79, 0x34, 0x20, 0x43, 0x27, 0xa0, 0xac, 0x27, 0xfa, 0x18, 0x9a, 0x85, 0xed, 0x9a, 0x5d,
	0x51, 0xd8, 0x99, 0x82, 0xd0, 0x01, 0xd4, 0x62, 0x31, 0x88, 0x9c, 0x01, 0x15, 0xc4, 0x23, 0x82,
	0xe0, 0xaa, 0x8a, 0xe8, 0x4e, 0x36, 0x22, 0x5b, 0x0c, 0xa2, 0xe7, 0x46, 0xaf, 0xe3, 0xaa, 0xc6,
	0x19, 0x08, 0xdd, 0x01, 0x30, 0xb5, 0x75, 0x7c, 0x0f, 0x2f, 0xea, 0x6c, 0x0d, 0x72, 0xea, 0xc9,
	0x10, 0xdd, 0xc0, 0xa7, 0x4c, 0x38, 0x7e, 0x84, 0x97, 0x94, 0xb6, 0xac, 0x81, 0xd3, 0x48, 0x2a,
	0xf9, 0x9e, 0x73, 0x91, 0xb8, 0x57, 0x54, 0xe0, 0x65, 0xad, 0xe4, 0x7b, 0x07, 0x4a, 0x96, 0xf1,
	0x73, 0xc6, 0xc7, 0xa5, 0xae, 0xeb, 0x13, 0xe7, 0x8c, 0x8f, 0x0a, 0xad, 0xd7, 0x47, 0x31, 0xbd,
	0xf4, 0x7f, 0xc6, 0x28, 0x5d, 0xdf, 0x56, 0xb2, 0x0c, 0x8c, 0x0b, 0x12, 0x0b, 0x47, 0xf8, 0x03,
	0x8a, 0x6f, 0xa9, 0xea, 0x2c, 0x28, 0xa4, 0xeb, 0x0f, 0x28, 0xda, 0x80, 0xb2, 0xca, 0x3d, 0x89,
	0x03, 0xbc, 0xa2, 0x7b, 0x44, 0xca, 0xe7, 0x71, 0x80, 0xd6, 0x61, 0xde, 0xf5, 0x98, 0xd2, 0xac,
	0xea, 0x26, 0x71, 0x3d, 0x26, 0x15, 0x1f, 0x42, 0x45, 0x4e, 0xaf, 0xec, 0x75, 0xe6, 0x0e, 0xf1,
	0x9a, 0x3a, 0x0d, 0x08, 0xc2, 0xd7, 0x67, 0x1a, 0x41, 0x8f, 0x61, 0x45, 0x8e, 0x36, 0xf5, 0x1c,
	0x7d, 0x44, 0x8e, 0xdb, 0xa7, 0xee, 0x15, 0xc7, 0xeb, 0xca, 0x3b, 0xd2, 0xba, 0xa7, 0x4a, 0x75,
	0xa8, 0x34, 0xe8, 0x05, 0xac, 0xc6, 0xa3, 0x51, 0x73, 0xa2, 0xd1, 0xac, 0x61, 0x6c, 0xa6, 0x7a,
	0xd6, 0x30, 0xda, 0x2b, 0xf1, 0x34, 0x8a, 0xb9, 0x07, 0x55, 0x13, 0x9e, 0x33, 0x08, 0x3d, 0x8a,
	0x37, 0x74, 0xd5, 0x0c, 0xf6, 0x3c, 0xf4, 0x28, 0x3a, 0x03, 0x9c, 0x71, 0xc9, 0xc3, 0x24, 0x76,
	0xa9, 0xa3, 0xb9, 0x0b, 0x37, 0x94, 0x57, 0x94, 0xa5, 0x35, 0xfa, 0x53, 0x42, 0xb9, 0xb0, 0xd7,
	0xc6, 0x6b, 0x3a, 0x6a, 0x89, 0x19, 0xb5, 0x2f, 0x61, 0x79, 0x3c, 0xbf, 0x5c, 0x8e, 0x34, 0xc7,
	0x9b, 0xaa, 0x8d, 0x6e, 0xa9, 0x5d, 0xf2, 0xe3, 0x6e, 0x2f, 0x89, 0x9c, 0xcc, 0x1b, 0x4f, 0xa0,
	0x92, 0x69, 0x7a, 0xb4, 0x0c, 0xc5, 0x2b, 0x3a, 0x34, 0x53, 0x2b, 0x3f, 0xd1, 0x0a, 0xdc, 0x7c,
	0x45, 0x82, 0x24, 0x1d, 0x79, 0x2d, 0x7c, 0x31, 0xf7, 0x79, 0xa1, 0xf1, 0x15, 0xd4, 0xaf, 0x75,
	0xe7, 0xfb, 0x6c, 0x60, 0xfd, 0x3e, 0x07, 0x75, 0x9d, 0xc6, 0x7e, 0x22, 0xfa, 0x26, 0x53, 0x74,
	0x1f, 0x6a, 0x97, 0x49, 0x10, 0x68, 0xc5, 0xb3, 0xd1, 0x5e, 0x79, 0x50, 0xf6, 0x9e, 0x22, 0x0c,
	0x46, 0x06, 0xe9, 0xce, 0x65, 0x09, 0xbc, 0x20, 0x03, 0xfa, 0x6e, 0x6c, 0xb2, 0x05, 0xb5, 0x6f,
	0x3a, 0x2f, 0x5f, 0x8c, 0x8d, 0x6e, 0x68, 0x23, 0x09, 0x66, 0x8d, 0x4e, 0xec, 0xf6, 0xe1, 0xd8,
	0xe8, 0xa6, 0x36, 0x92, 0xe0, 0x1b, 0x78, 0xa9, 0x34, 0x8d, 0x97, 0x10, 0xdc, 0x48, 0x12, 0xdf,
	0xc3, 0xf3, 0x4a, 0xa9, 0xbe, 0xf3, 0xf3, 0x59, 0xce, 0xcf, 0xa7, 0xf5, 0x10, 0x16, 0xcd, 0xd5,
	0x97, 0xd6, 0x66, 0x26, 0xb1, 0x5a, 0x0e, 0xd4, 0x72, 0x0d, 0xf3, 0x2f, 0x38, 0x38, 0xc7, 0x9b,
	0xc5, 0x09, 0xde, 0xb4, 0x96, 0xa0, 0xa6, 0x27, 0xc7, 0x38, 0xb0, 0x6e, 0x43, 0x49, 0x03, 0x32,
	0x31, 0x9f, 0x5d, 0x86, 0xc6, 0x8f, 0xfa, 0xb6, 0xba, 0x50, 0xdf, 0x4f, 0xcf, 0x8b, 0x67, 0x62,
	0xe2, 0xb4, 0x37, 0xa0, 0x4c, 0x28, 0xdb, 0xa2, 0x9d, 0x8a, 0xaa, 0x84, 0xa1, 0x20, 0x81, 0x63,
	0x00, 0xae, 0x62, 0x2b, 0xda, 0x35, 0x85, 0x76, 0x0c, 0x68, 0xed, 0x01, 0xe8, 0x2d, 0xcf, 0x7c,
	0x2e, 0xde, 0xf5, 0x3d, 0xf0, 0x47, 0x01, 0xd6, 0x3a, 0x54, 0x68, 0x38, 0x97, 0x03, 0x7a, 0x02,
	0x8b, 0xda, 0xca, 0x89, 0x35, 0xa2, 0xe2, 0x9a, 0x3e, 0x81, 0x35, 0x3e, 0x59, 0xdf, 0xf4, 0x5a,
	0x98, 0xcb, 0x5f, 0x0b, 0xb3, 0x58, 0xa8, 0x38, 0x8b, 0x85, 0xac, 0x0d, 0x58, 0xbf, 0x16, 0x20,
	0x8f, 0x42, 0xc6, 0xa9, 0xf5, 0x57, 0x01, 0x56, 0xcf, 0x23, 0x8f, 0x08, 0x9a, 0xce, 0xd9, 0xff,
	0x10, 0xfb, 0xb7, 0x93, 0x17, 0xcf, 0x9c, 0x2a, 0xdf, 0x23, 0xb5, 0x72, 0xaa, 0xb7, 0xb7, 0xdd,
	0x43, 0xff, 0x9d, 0x0c, 0x30, 0xac, 0x4d, 0x7a, 0x36, 0x25, 0xf8, 0x05, 0xee, 0x68, 0x8d, 0x3d,
	0x41, 0x81, 0x69, 0x3a, 0x2d, 0x28, 0x73, 0xe1, 0x0b, 0xb7, 0x4f, 0xe3, 0x37, 0xd4, 0x60, 0x64,
	0x83, 0x1e, 0x42, 0x49, 0xd3, 0xae, 0x79, 0xbb, 0x4d, 0xb3, 0x36, 0x16, 0x56, 0x13, 0xee, 0xce,
	0x72, 0x6e, 0xc2, 0xfb, 0x11, 0x36, 0xd4, 0x31, 0x9e, 0xb2, 0x1e, 0xe5, 0x22, 0x7f, 0x7c, 0x68,
	0x0b, 0x4a, 0x86, 0xda, 0x75, 0x60, 0xb9, 0x0e, 0x35, 0x2a, 0xd4, 0x80, 0xb2, 0xaf, 0x16, 0xbf,
	0x7c, 0x66, 0x7a, 0x69, 0x24, 0x5b, 0xbf, 0x16, 0x00, 0xb7, 0x13, 0xa1, 0x37, 0x9f, 0x6c, 0x81,
	0xd9, 0x33, 0xde, 0x80, 0x72, 0xe6, 0x70, 0x15, 0xad, 0xa4, 0xb2, 0xbc, 0xa3, 0x4c, 0xc7, 0x50,
	0xcf, 0x21, 0x29, 0x39, 0x56, 0x46, 0xd8, 0xbe, 0x40, 0x4d, 0x7d, 0xf9, 0x8b, 0x30, 0xf2, 0x5d,
	0xf9, 0xae, 0xd0, 0xd4, 0x08, 0x9c, 0xf1, 0xae, 0x84, 0x4e, 0x3d, 0x6b, 0x13, 0x36, 0xa6, 0x84,
	0xa5, 0xb3, 0xde, 0xfd, 0xfb, 0x26, 0x54, 0x8e, 0x7c, 0xa9, 0xf2, 0x43, 0xf6, 0xdd, 0xc7, 0xe8,
	0x11, 0x2c, 0x9c, 0x50, 0x91, 0xb2, 0x85, 0x2a, 0x41, 0x6e, 0x0e, 0x1b, 0x95, 0x0c, 0x86, 0xf6,
	0xa0, 0x7a, 0x18, 0x53, 0x22, 0xd2, 0x2b, 0x6e, 0x2d, 0x53, 0xb3, 0xcc, 0x45, 0xd1, 0xc8, 0xd6,
	0xd2, 0xb8, 0x30, 0xc2, 0x94, 0x03, 0xcd, 0x5b, 0xef, 0x40, 0xf5, 0x88, 0x06, 0x74, 0xe4, 0xe2,
	0xad, 0x0b, 0x3e, 0x85, 0xfa, 0xd1, 0xe8, 0x15, 0x9f, 0xfe, 0x1f, 0xd1, 0x37, 0x6c, 0x9e, 0xa2,
	0x1b, 0xd5, 0x2c, 0x88, 0x76, 0x00, 0x4e, 0xe8, 0xfb, 0x2c, 0xd8, 0x85, 0x9a, 0x8e, 0xec, 0x3d,
	0xd6, 0x7c, 0x02, 0x30, 0xe6, 0x5a, 0x53, 0xae, 0x6b, 0xe4, 0xdb, 0x58, 0xca, 0xe4, 0xa3, 0xe8,
	0xf3, 0x25, 0xac, 0xe8, 0xd6, 0xd6, 0xd8, 0xe8, 0x49, 0xd9, 0x98, 0x4d, 0x03, 0x8d, 0xcd, 0xa9,
	0x3a, 0xd3, 0xec, 0x27, 0x50, 0xbf, 0x36, 0x09, 0x53, 0x4b, 0x7b, 0xd7, 0x84, 0x3f, 0x6b, 0x6a,
	0x48, 0xca, 0x05, 0x93, 0x43, 0x87, 0xac, 0x8c, 0xff, 0x19, 0x74, 0xd0, 0xd8, 0x7a, 0xa3, 0x8d,
	0x71, 0x61, 0x43, 0xfd, 0x5a, 0xff, 0x22, 0xfd, 0xf2, 0x9e, 0x35, 0x6e, 0x26, 0xec, 0x99, 0x6d,
	0x7f, 0x51, 0x52, 0xff, 0xfd, 0xf6, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0x51, 0xd6, 0xa6, 0x18,
	0xeb, 0x0e, 0x00, 0x00,
}
