// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: pkg/dgn/dgn.proto

/*
Package dgn is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	pkg/dgn/dgn.proto
*/
package dgn

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// =====================
// DigestionV1 Interface
// =====================

// Digestion is an internal service that is responsible
// for tracking the state of live ingests. Major use cases
// include: authorizing a RTMP stream and finding where to
// connect to a live stream to start a transcode
type DigestionV1 interface {
	// Returning without error = a healthy service
	GetHealth(context.Context, *HealthRequest) (*Health, error)

	// Perform stream authorization and store a stream under the channel
	CreateStream(context.Context, *StreamAuthRequest) (*Stream, error)

	// Get a stream by the channel and stream (i.e. "lirik", "live")
	// this has a bit of an odd-looking url pattern - Streams are uniquely identified
	// by a channel (hash key) and a stream (range key)
	GetStream(context.Context, *StreamRequest) (*Stream, error)

	// Delete a stream from the digestion DB.
	DeleteStream(context.Context, *StreamRequest) (*Stream, error)

	// Disconnect all streams for a channel at the ingest, and delete it from digestion DB
	DisconnectChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Get all streams associated with a channel
	GetChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Delete all streams associated with a channel from the digestion DB.
	DeleteChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Basically a scan on the streams table
	AllStreams(context.Context, *AllStreamsRequest) (*StreamList, error)

	// Update RTMP Metadata for a given stream
	UpdateStreamMetadata(context.Context, *UpdateMetadataRequest) (*UpdateMetadataResponse, error)

	// Contacts ingest over twirp to check health of a stream
	CheckIngestHealth(context.Context, *StreamRequest) (*CheckIngestHealthResponse, error)

	UpdateRedundancySource(context.Context, *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error)

	// Puts arbitrary metadata into a stream.
	PutIngestMetadata(context.Context, *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error)
}

// ===========================
// DigestionV1 Protobuf Client
// ===========================

type digestionV1ProtobufClient struct {
	client HTTPClient
	urls   [12]string
}

// NewDigestionV1ProtobufClient creates a Protobuf client that implements the DigestionV1 interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDigestionV1ProtobufClient(addr string, client HTTPClient) DigestionV1 {
	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [12]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &digestionV1ProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &digestionV1ProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *digestionV1ProtobufClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *digestionV1ProtobufClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

// =======================
// DigestionV1 JSON Client
// =======================

type digestionV1JSONClient struct {
	client HTTPClient
	urls   [12]string
}

// NewDigestionV1JSONClient creates a JSON client that implements the DigestionV1 interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDigestionV1JSONClient(addr string, client HTTPClient) DigestionV1 {
	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [12]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &digestionV1JSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &digestionV1JSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *digestionV1JSONClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *digestionV1JSONClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *digestionV1JSONClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *digestionV1JSONClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *digestionV1JSONClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *digestionV1JSONClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *digestionV1JSONClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *digestionV1JSONClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *digestionV1JSONClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *digestionV1JSONClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *digestionV1JSONClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *digestionV1JSONClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

// ==========================
// DigestionV1 Server Handler
// ==========================

type digestionV1Server struct {
	DigestionV1
	hooks *twirp.ServerHooks
}

func NewDigestionV1Server(svc DigestionV1, hooks *twirp.ServerHooks) TwirpServer {
	return &digestionV1Server{
		DigestionV1: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *digestionV1Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DigestionV1PathPrefix is used for all URL paths on a twirp DigestionV1 server.
// Requests are always: POST DigestionV1PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DigestionV1PathPrefix = "/twirp/dgn.DigestionV1/"

func (s *digestionV1Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/dgn.DigestionV1/GetHealth":
		s.serveGetHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CreateStream":
		s.serveCreateStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetStream":
		s.serveGetStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteStream":
		s.serveDeleteStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DisconnectChannel":
		s.serveDisconnectChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetChannel":
		s.serveGetChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteChannel":
		s.serveDeleteChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/AllStreams":
		s.serveAllStreams(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateStreamMetadata":
		s.serveUpdateStreamMetadata(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CheckIngestHealth":
		s.serveCheckIngestHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateRedundancySource":
		s.serveUpdateRedundancySource(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/PutIngestMetadata":
		s.servePutIngestMetadata(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *digestionV1Server) serveGetHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCreateStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamAuthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDisconnectChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDisconnectChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDisconnectChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveAllStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AllStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateStreamMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateStreamMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateStreamMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCheckIngestHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckIngestHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCheckIngestHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRedundancySourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRedundancySourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateRedundancySourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRedundancySourceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRedundancySourceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutIngestMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutIngestMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) servePutIngestMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutIngestMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PutIngestMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *digestionV1Server) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1428 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xeb, 0x6e, 0x1b, 0x45,
	0x14, 0xc6, 0x71, 0xeb, 0x38, 0xc7, 0x76, 0x12, 0x4f, 0x73, 0x99, 0x38, 0x6d, 0x71, 0x37, 0xad,
	0x14, 0xaa, 0xca, 0x29, 0x89, 0xb8, 0x94, 0x1f, 0xa0, 0xdc, 0x48, 0x43, 0xd3, 0xd6, 0xac, 0x1d,
	0x90, 0x10, 0xd2, 0x6a, 0xb2, 0x3b, 0xb1, 0x57, 0x59, 0xcf, 0x2e, 0x3b, 0xb3, 0x2d, 0x16, 0xcf,
	0x81, 0xc4, 0x1f, 0xc4, 0x23, 0xf0, 0x56, 0x3c, 0x01, 0x0f, 0x80, 0xe6, 0xb2, 0xf6, 0xae, 0x63,
	0xf7, 0x02, 0xfc, 0xb0, 0xb4, 0xe7, 0x3b, 0x67, 0xe6, 0x5c, 0xe6, 0x9c, 0x6f, 0xc6, 0x50, 0x8f,
	0xae, 0x7a, 0x3b, 0x5e, 0x8f, 0xc9, 0x5f, 0x2b, 0x8a, 0x43, 0x11, 0xa2, 0xa2, 0xd7, 0x63, 0x8d,
	0xbb, 0xbd, 0x30, 0xec, 0x05, 0x74, 0x47, 0x41, 0x17, 0xc9, 0xe5, 0x8e, 0x97, 0xc4, 0x44, 0xf8,
	0xa1, 0x31, 0xb2, 0x1e, 0xc3, 0xfc, 0x61, 0x9f, 0x30, 0x46, 0x03, 0xf4, 0x00, 0xe6, 0xb9, 0x88,
	0x29, 0x19, 0x70, 0x5c, 0x68, 0x16, 0xb7, 0x2b, 0xbb, 0x95, 0x96, 0xdc, 0xac, 0xa3, 0x30, 0x3b,
	0xd5, 0x59, 0xbf, 0xcd, 0xc1, 0x8a, 0x4d, 0xbd, 0x84, 0x79, 0x84, 0xb9, 0xc3, 0x76, 0x1c, 0x46,
	0x34, 0x16, 0x3e, 0xe5, 0xe8, 0x33, 0xc0, 0x24, 0x08, 0xc2, 0xd7, 0xce, 0x25, 0xf1, 0x83, 0xf0,
	0x15, 0x8d, 0x1d, 0x11, 0x3a, 0x17, 0xc4, 0xbd, 0x4a, 0x22, 0x5c, 0x68, 0x16, 0xb6, 0xcb, 0xf6,
	0xaa, 0xd2, 0x7f, 0x6d, 0xd4, 0xdd, 0xf0, 0x40, 0x29, 0xd1, 0x39, 0x6c, 0x78, 0x3e, 0x77, 0x43,
	0xc6, 0xa8, 0x2b, 0x1c, 0x1e, 0x10, 0x41, 0x9d, 0x34, 0x4c, 0x3c, 0xd7, 0x2c, 0x6c, 0x57, 0x76,
	0x37, 0x5a, 0x3a, 0x8f, 0x56, 0x9a, 0x47, 0xeb, 0xc8, 0x18, 0xd8, 0xeb, 0xe3, 0xb5, 0x1d, 0xb9,
	0x34, 0x55, 0xa0, 0x63, 0xa8, 0xe8, 0xbd, 0x2e, 0x62, 0xc2, 0x3c, 0x5c, 0x6c, 0x16, 0xb6, 0x17,
	0x77, 0xef, 0xab, 0x9c, 0xa6, 0xc5, 0xdf, 0x52, 0xab, 0x0f, 0xa4, 0xad, 0x0d, 0x7c, 0xf4, 0x6d,
	0x7d, 0x04, 0x30, 0xd6, 0xa0, 0x25, 0xa8, 0x7c, 0xff, 0xf4, 0xb4, 0x7b, 0xec, 0x9c, 0xed, 0x1f,
	0x1c, 0x9f, 0x2d, 0x7f, 0x80, 0x00, 0x4a, 0xed, 0x73, 0xbb, 0x7d, 0x76, 0xbc, 0x5c, 0xb0, 0x7e,
	0x80, 0xc5, 0x6e, 0x4c, 0x18, 0x77, 0x43, 0x8f, 0x76, 0x04, 0x71, 0xaf, 0xd0, 0x03, 0x58, 0x14,
	0x29, 0xe2, 0x88, 0x61, 0x44, 0x55, 0x25, 0x16, 0xec, 0xda, 0x08, 0xed, 0x0e, 0x23, 0x8a, 0xee,
	0x41, 0x95, 0x32, 0x29, 0xc5, 0xda, 0x68, 0x4e, 0x19, 0x55, 0x0c, 0x26, 0x4d, 0xac, 0x3f, 0xcb,
	0x50, 0xd2, 0x47, 0x81, 0x30, 0xcc, 0xbb, 0xfa, 0xcc, 0xcc, 0x6e, 0xa9, 0x88, 0xd6, 0xa0, 0x74,
	0x19, 0xc6, 0x03, 0x22, 0xcc, 0x0e, 0x46, 0x42, 0x5b, 0x50, 0xb3, 0xbb, 0xcf, 0xdb, 0x0e, 0x65,
	0x5e, 0x14, 0xfa, 0x4c, 0xa8, 0x62, 0x2c, 0xd8, 0x55, 0x09, 0x1e, 0x1b, 0x4c, 0xc5, 0xfa, 0xda,
	0x8f, 0xa3, 0xb1, 0x55, 0xc5, 0xc4, 0x2a, 0xd1, 0x91, 0xd9, 0x6d, 0x58, 0xe0, 0x94, 0x73, 0x3f,
	0x64, 0xa7, 0x47, 0xb8, 0xa4, 0x2c, 0xc6, 0x00, 0xda, 0x81, 0x52, 0x44, 0x62, 0xd9, 0x43, 0xf3,
	0xaa, 0x87, 0xd6, 0x33, 0x3d, 0xd4, 0x6a, 0x2b, 0xcd, 0x31, 0x13, 0xf1, 0xd0, 0x36, 0x66, 0x32,
	0x99, 0x3e, 0x25, 0x81, 0xe8, 0x0f, 0x71, 0x59, 0x35, 0x49, 0x2a, 0xa2, 0x4d, 0x58, 0x08, 0x08,
	0x17, 0x0e, 0xa7, 0x94, 0xe1, 0x85, 0x66, 0x61, 0xbb, 0x68, 0x97, 0x25, 0xd0, 0xa1, 0x94, 0xc9,
	0x8a, 0x79, 0x34, 0x20, 0x43, 0x27, 0xa0, 0xac, 0x27, 0xfa, 0x18, 0x9a, 0x85, 0xed, 0x9a, 0x5d,
	0x51, 0xd8, 0x99, 0x82, 0xd0, 0x01, 0xd4, 0x62, 0x31, 0x88, 0x9c, 0x01, 0x15, 0xc4, 0x23, 0x82,
	0xe0, 0xaa, 0x8a, 0xe8, 0x4e, 0x36, 0x22, 0x5b, 0x0c, 0xa2, 0xe7, 0x46, 0xaf, 0xe3, 0xaa, 0xc6,
	0x19, 0x08, 0xdd, 0x01, 0x30, 0xb5, 0x75, 0x7c, 0x0f, 0x2f, 0xea, 0x6c, 0x0d, 0x72, 0xea, 0xc9,
	0x10, 0xdd, 0xc0, 0xa7, 0x4c, 0x38, 0x7e, 0x84, 0x97, 0x94, 0xb6, 0xac, 0x81, 0xd3, 0x48, 0x2a,
	0xf9, 0x9e, 0x73, 0x91, 0xb8, 0x57, 0x54, 0xe0, 0x65, 0xad, 0xe4, 0x7b, 0x07, 0x4a, 0x96, 0xf1,
	0x73, 0xc6, 0xc7, 0xa5, 0xae, 0xeb, 0x13, 0xe7, 0x8c, 0x8f, 0x0a, 0xad, 0xd7, 0x47, 0x31, 0xbd,
	0xf4, 0x7f, 0xc6, 0x28, 0x5d, 0xdf, 0x56, 0xb2, 0x0c, 0x8c, 0x0b, 0x12, 0x0b, 0x47, 0xf8, 0x03,
	0x8a, 0x6f, 0xa9, 0xea, 0x2c, 0x28, 0xa4, 0xeb, 0x0f, 0x28, 0xda, 0x80, 0xb2, 0xca, 0x3d, 0x89,
	0x03, 0xbc, 0xa2, 0x7b, 0x44, 0xca, 0xe7, 0x71, 0x80, 0xd6, 0x61, 0xde, 0xf5, 0x98, 0xd2, 0xac,
	0xea, 0x26, 0x71, 0x3d, 0x26, 0x15, 0x1f, 0x42, 0x45, 0x4e, 0xaf, 0xec, 0x75, 0xe6, 0x0e, 0xf1,
	0x9a, 0x3a, 0x0d, 0x08, 0xc2, 0xd7, 0x67, 0x1a, 0x41, 0x8f, 0x61, 0x45, 0x8e, 0x36, 0xf5, 0x1c,
	0x7d, 0x44, 0x8e, 0xdb, 0xa7, 0xee, 0x15, 0xc7, 0xeb, 0xca, 0x3b, 0xd2, 0xba, 0xa7, 0x4a, 0x75,
	0xa8, 0x34, 0xe8, 0x05, 0xac, 0xc6, 0xa3, 0x51, 0x73, 0xa2, 0xd1, 0xac, 0x61, 0x6c, 0xa6, 0x7a,
	0xd6, 0x30, 0xda, 0x2b, 0xf1, 0x34, 0x8a, 0xb9, 0x07, 0x55, 0x13, 0x9e, 0x33, 0x08, 0x3d, 0x8a,
	0x37, 0x74, 0xd5, 0x0c, 0xf6, 0x3c, 0xf4, 0x28, 0x3a, 0x03, 0x9c, 0x71, 0xc9, 0xc3, 0x24, 0x76,
	0xa9, 0xa3, 0xb9, 0x0b, 0x37, 0x94, 0x57, 0x94, 0xa5, 0x35, 0xfa, 0x53, 0x42, 0xb9, 0xb0, 0xd7,
	0xc6, 0x6b, 0x3a, 0x6a, 0x89, 0x19, 0xb5, 0x2f, 0x61, 0x79, 0x3c, 0xbf, 0x5c, 0x8e, 0x34, 0xc7,
	0x9b, 0xaa, 0x8d, 0x6e, 0xa9, 0x5d, 0xf2, 0xe3, 0x6e, 0x2f, 0x89, 0x9c, 0xcc, 0x1b, 0x4f, 0xa0,
	0x92, 0x69, 0x7a, 0xb4, 0x0c, 0xc5, 0x2b, 0x3a, 0x34, 0x53, 0x2b, 0x3f, 0xd1, 0x0a, 0xdc, 0x7c,
	0x45, 0x82, 0x24, 0x1d, 0x79, 0x2d, 0x7c, 0x31, 0xf7, 0x79, 0xa1, 0xf1, 0x15, 0xd4, 0xaf, 0x75,
	0xe7, 0xfb, 0x6c, 0x60, 0xfd, 0x3e, 0x07, 0x75, 0x9d, 0xc6, 0x7e, 0x22, 0xfa, 0x26, 0x53, 0x74,
	0x1f, 0x6a, 0x97, 0x49, 0x10, 0x68, 0xc5, 0xb3, 0xd1, 0x5e, 0x79, 0x50, 0xf6, 0x9e, 0x22, 0x0c,
	0x46, 0x06, 0xe9, 0xce, 0x65, 0x09, 0xbc, 0x20, 0x03, 0xfa, 0x6e, 0x6c, 0xb2, 0x05, 0xb5, 0x6f,
	0x3a, 0x2f, 0x5f, 0x8c, 0x8d, 0x6e, 0x68, 0x23, 0x09, 0x66, 0x8d, 0x4e, 0xec, 0xf6, 0xe1, 0xd8,
	0xe8, 0xa6, 0x36, 0x92, 0xe0, 0x1b, 0x78, 0xa9, 0x34, 0x8d, 0x97, 0x10, 0xdc, 0x48, 0x12, 0xdf,
	0xc3, 0xf3, 0x4a, 0xa9, 0xbe, 0xf3, 0xf3, 0x59, 0xce, 0xcf, 0xa7, 0xf5, 0x10, 0x16, 0xcd, 0xd5,
	0x97, 0xd6, 0x66, 0x26, 0xb1, 0x5a, 0x0e, 0xd4, 0x72, 0x0d, 0xf3, 0x2f, 0x38, 0x38, 0xc7, 0x9b,
	0xc5, 0x09, 0xde, 0xb4, 0x96, 0xa0, 0xa6, 0x27, 0xc7, 0x38, 0xb0, 0x6e, 0x43, 0x49, 0x03, 0x32,
	0x31, 0x9f, 0x5d, 0x86, 0xc6, 0x8f, 0xfa, 0xb6, 0xba, 0x50, 0xdf, 0x4f, 0xcf, 0x8b, 0x67, 0x62,
	0xe2, 0xb4, 0x37, 0xa0, 0x4c, 0x28, 0xdb, 0xa2, 0x9d, 0x8a, 0xaa, 0x84, 0xa1, 0x20, 0x81, 0x63,
	0x00, 0xae, 0x62, 0x2b, 0xda, 0x35, 0x85, 0x76, 0x0c, 0x68, 0xed, 0x01, 0xe8, 0x2d, 0xcf, 0x7c,
	0x2e, 0xde, 0xf5, 0x3d, 0xf0, 0x47, 0x01, 0xd6, 0x3a, 0x54, 0x68, 0x38, 0x97, 0x03, 0x7a, 0x02,
	0x8b, 0xda, 0xca, 0x89, 0x35, 0xa2, 0xe2, 0x9a, 0x3e, 0x81, 0x35, 0x3e, 0x59, 0xdf, 0xf4, 0x5a,
	0x98, 0xcb, 0x5f, 0x0b, 0xb3, 0x58, 0xa8, 0x38, 0x8b, 0x85, 0xac, 0x0d, 0x58, 0xbf, 0x16, 0x20,
	0x8f, 0x42, 0xc6, 0xa9, 0xf5, 0x57, 0x01, 0x56, 0xcf, 0x23, 0x8f, 0x08, 0x9a, 0xce, 0xd9, 0xff,
	0x10, 0xfb, 0xb7, 0x93, 0x17, 0xcf, 0x9c, 0x2a, 0xdf, 0x23, 0xb5, 0x72, 0xaa, 0xb7, 0xb7, 0xdd,
	0x43, 0xff, 0x9d, 0x0c, 0x30, 0xac, 0x4d, 0x7a, 0x36, 0x25, 0xf8, 0x05, 0xee, 0x68, 0x8d, 0x3d,
	0x41, 0x81, 0x69, 0x3a, 0x2d, 0x28, 0x73, 0xe1, 0x0b, 0xb7, 0x4f, 0xe3, 0x37, 0xd4, 0x60, 0x64,
	0x83, 0x1e, 0x42, 0x49, 0xd3, 0xae, 0x79, 0xbb, 0x4d, 0xb3, 0x36, 0x16, 0x56, 0x13, 0xee, 0xce,
	0x72, 0x6e, 0xc2, 0xfb, 0x11, 0x36, 0xd4, 0x31, 0x9e, 0xb2, 0x1e, 0xe5, 0x22, 0x7f, 0x7c, 0x68,
	0x0b, 0x4a, 0x86, 0xda, 0x75, 0x60, 0xb9, 0x0e, 0x35, 0x2a, 0xd4, 0x80, 0xb2, 0xaf, 0x16, 0xbf,
	0x7c, 0x66, 0x7a, 0x69, 0x24, 0x5b, 0xbf, 0x16, 0x00, 0xb7, 0x13, 0xa1, 0x37, 0x9f, 0x6c, 0x81,
	0xd9, 0x33, 0xde, 0x80, 0x72, 0xe6, 0x70, 0x15, 0xad, 0xa4, 0xb2, 0xbc, 0xa3, 0x4c, 0xc7, 0x50,
	0xcf, 0x21, 0x29, 0x39, 0x56, 0x46, 0xd8, 0xbe, 0x40, 0x4d, 0x7d, 0xf9, 0x8b, 0x30, 0xf2, 0x5d,
	0xf9, 0xae, 0xd0, 0xd4, 0x08, 0x9c, 0xf1, 0xae, 0x84, 0x4e, 0x3d, 0x6b, 0x13, 0x36, 0xa6, 0x84,
	0xa5, 0xb3, 0xde, 0xfd, 0xfb, 0x26, 0x54, 0x8e, 0x7c, 0xa9, 0xf2, 0x43, 0xf6, 0xdd, 0xc7, 0xe8,
	0x11, 0x2c, 0x9c, 0x50, 0x91, 0xb2, 0x85, 0x2a, 0x41, 0x6e, 0x0e, 0x1b, 0x95, 0x0c, 0x86, 0xf6,
	0xa0, 0x7a, 0x18, 0x53, 0x22, 0xd2, 0x2b, 0x6e, 0x2d, 0x53, 0xb3, 0xcc, 0x45, 0xd1, 0xc8, 0xd6,
	0xd2, 0xb8, 0x30, 0xc2, 0x94, 0x03, 0xcd, 0x5b, 0xef, 0x40, 0xf5, 0x88, 0x06, 0x74, 0xe4, 0xe2,
	0xad, 0x0b, 0x3e, 0x85, 0xfa, 0xd1, 0xe8, 0x15, 0x9f, 0xfe, 0x1f, 0xd1, 0x37, 0x6c, 0x9e, 0xa2,
	0x1b, 0xd5, 0x2c, 0x88, 0x76, 0x00, 0x4e, 0xe8, 0xfb, 0x2c, 0xd8, 0x85, 0x9a, 0x8e, 0xec, 0x3d,
	0xd6, 0x7c, 0x02, 0x30, 0xe6, 0x5a, 0x53, 0xae, 0x6b, 0xe4, 0xdb, 0x58, 0xca, 0xe4, 0xa3, 0xe8,
	0xf3, 0x25, 0xac, 0xe8, 0xd6, 0xd6, 0xd8, 0xe8, 0x49, 0xd9, 0x98, 0x4d, 0x03, 0x8d, 0xcd, 0xa9,
	0x3a, 0xd3, 0xec, 0x27, 0x50, 0xbf, 0x36, 0x09, 0x53, 0x4b, 0x7b, 0xd7, 0x84, 0x3f, 0x6b, 0x6a,
	0x48, 0xca, 0x05, 0x93, 0x43, 0x87, 0xac, 0x8c, 0xff, 0x19, 0x74, 0xd0, 0xd8, 0x7a, 0xa3, 0x8d,
	0x71, 0x61, 0x43, 0xfd, 0x5a, 0xff, 0x22, 0xfd, 0xf2, 0x9e, 0x35, 0x6e, 0x26, 0xec, 0x99, 0x6d,
	0x7f, 0x51, 0x52, 0xff, 0xfd, 0xf6, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0x51, 0xd6, 0xa6, 0x18,
	0xeb, 0x0e, 0x00, 0x00,
}
