// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/video/usherapi/rpc/usher/channel_properties.proto

package usher // import "code.justin.tv/video/usherapi/rpc/usher"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ChannelProperties struct {
	// id appears to be rarely used, instead channel properties entries are
	// referenced by channel_id or channel_name almost exclusively
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// channel_id is the twitch channel id for this stream
	ChannelId int64 `protobuf:"varint,2,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	// channel is the twitch channel name for this stream
	Channel string `protobuf:"bytes,3,opt,name=channel,proto3" json:"channel,omitempty"`
	// customer_id is the LVS customer id for this stream, always set to "twitch"
	// for Twitch streams
	CustomerId string `protobuf:"bytes,4,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	// content_id is the LVS content id for this stream, always set to a stringified
	// channel_id for Twitch streams
	ContentId string `protobuf:"bytes,5,opt,name=content_id,json=customer_id,proto3" json:"content_id,omitempty"`
	// video_codec is the video codec of this channel
	//
	// Looks like:
	//   "avc1.64002A"
	VideoCodec string `protobuf:"bytes,6,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	// audio_codec is the audio codec of this channel
	//
	// Looks like:
	//   "mp4a.40.2"
	AudioCodec string `protobuf:"bytes,7,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	// avc_profile is the AVC profile of this stream
	//
	// Looks like:
	//   "High"
	AvcProfile string `protobuf:"bytes,8,opt,name=avc_profile,proto3" json:"avc_profile,omitempty"`
	// target_fps apears to frequently be unset, unclear if this has meaning
	TargetFps float64 `protobuf:"fixed64,9,opt,name=target_fps,proto3" json:"target_fps,omitempty"`
	// vfr appears to frequently be unset, the acronym likely stands for variable
	// frame rate
	// TODO: document the schema of this field's value if anyone can find it
	Vfr bool `protobuf:"varint,10,opt,name=vfr,proto3" json:"vfr,omitempty"`
	// avc_level is the AVC level string for this channel
	//
	// Looks like:
	//   "42"
	AvcLevel string `protobuf:"bytes,11,opt,name=avc_level,proto3" json:"avc_level,omitempty"`
	// channels is the number of audio channels this stream has
	Channels int32 `protobuf:"varint,12,opt,name=channels,proto3" json:"channels,omitempty"`
	// width_pixels is the source video width in pixels
	WidthPixels int32 `protobuf:"varint,13,opt,name=width_pixels,json=width,proto3" json:"width_pixels,omitempty"`
	// height_pixels is the source video height in pixels
	HeightPixels int32 `protobuf:"varint,14,opt,name=height_pixels,json=height,proto3" json:"height_pixels,omitempty"`
	// sample_rate is the audio sample rate
	SampleRateHz float64 `protobuf:"fixed64,15,opt,name=sample_rate_hz,json=sample_rate,proto3" json:"sample_rate_hz,omitempty"`
	// idr_aligned_ratio NEEDS DOCUMENTATION
	IdrAlignedRatio float64 `protobuf:"fixed64,16,opt,name=idr_aligned_ratio,json=idr_aligned_percent,proto3" json:"idr_aligned_ratio,omitempty"`
	// average_fps is the average framerate of this stream
	AverageFps float64 `protobuf:"fixed64,17,opt,name=average_fps,proto3" json:"average_fps,omitempty"`
	// average_kbps is the average bitrate of this stream
	AverageKbps float64 `protobuf:"fixed64,18,opt,name=average_kbps,proto3" json:"average_kbps,omitempty"`
	// max_kbps is the maximum observed bitrate of this stream
	MaxKbps float64 `protobuf:"fixed64,19,opt,name=max_kbps,proto3" json:"max_kbps,omitempty"`
	// max_idr_delta_millis is the largest time seen between keyframes in milliseconds
	MaxIdrDeltaMillis    float64  `protobuf:"fixed64,20,opt,name=max_idr_delta_millis,json=max_idr_delta,proto3" json:"max_idr_delta_millis,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelProperties) Reset()         { *m = ChannelProperties{} }
func (m *ChannelProperties) String() string { return proto.CompactTextString(m) }
func (*ChannelProperties) ProtoMessage()    {}
func (*ChannelProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{0}
}
func (m *ChannelProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelProperties.Unmarshal(m, b)
}
func (m *ChannelProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelProperties.Marshal(b, m, deterministic)
}
func (dst *ChannelProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelProperties.Merge(dst, src)
}
func (m *ChannelProperties) XXX_Size() int {
	return xxx_messageInfo_ChannelProperties.Size(m)
}
func (m *ChannelProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelProperties.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelProperties proto.InternalMessageInfo

func (m *ChannelProperties) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ChannelProperties) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *ChannelProperties) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *ChannelProperties) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ChannelProperties) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *ChannelProperties) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *ChannelProperties) GetAudioCodec() string {
	if m != nil {
		return m.AudioCodec
	}
	return ""
}

func (m *ChannelProperties) GetAvcProfile() string {
	if m != nil {
		return m.AvcProfile
	}
	return ""
}

func (m *ChannelProperties) GetTargetFps() float64 {
	if m != nil {
		return m.TargetFps
	}
	return 0
}

func (m *ChannelProperties) GetVfr() bool {
	if m != nil {
		return m.Vfr
	}
	return false
}

func (m *ChannelProperties) GetAvcLevel() string {
	if m != nil {
		return m.AvcLevel
	}
	return ""
}

func (m *ChannelProperties) GetChannels() int32 {
	if m != nil {
		return m.Channels
	}
	return 0
}

func (m *ChannelProperties) GetWidthPixels() int32 {
	if m != nil {
		return m.WidthPixels
	}
	return 0
}

func (m *ChannelProperties) GetHeightPixels() int32 {
	if m != nil {
		return m.HeightPixels
	}
	return 0
}

func (m *ChannelProperties) GetSampleRateHz() float64 {
	if m != nil {
		return m.SampleRateHz
	}
	return 0
}

func (m *ChannelProperties) GetIdrAlignedRatio() float64 {
	if m != nil {
		return m.IdrAlignedRatio
	}
	return 0
}

func (m *ChannelProperties) GetAverageFps() float64 {
	if m != nil {
		return m.AverageFps
	}
	return 0
}

func (m *ChannelProperties) GetAverageKbps() float64 {
	if m != nil {
		return m.AverageKbps
	}
	return 0
}

func (m *ChannelProperties) GetMaxKbps() float64 {
	if m != nil {
		return m.MaxKbps
	}
	return 0
}

func (m *ChannelProperties) GetMaxIdrDeltaMillis() float64 {
	if m != nil {
		return m.MaxIdrDeltaMillis
	}
	return 0
}

type ChannelPropertiesUpdateRequest struct {
	ChannelPropertiesId  int64                    `protobuf:"varint,1,opt,name=channel_properties_id,json=channelPropertiesId,proto3" json:"channel_properties_id,omitempty"`
	Update               *ChannelPropertiesUpdate `protobuf:"bytes,2,opt,name=update,proto3" json:"update,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ChannelPropertiesUpdateRequest) Reset()         { *m = ChannelPropertiesUpdateRequest{} }
func (m *ChannelPropertiesUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesUpdateRequest) ProtoMessage()    {}
func (*ChannelPropertiesUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{1}
}
func (m *ChannelPropertiesUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesUpdateRequest.Unmarshal(m, b)
}
func (m *ChannelPropertiesUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesUpdateRequest.Merge(dst, src)
}
func (m *ChannelPropertiesUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesUpdateRequest.Size(m)
}
func (m *ChannelPropertiesUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesUpdateRequest proto.InternalMessageInfo

func (m *ChannelPropertiesUpdateRequest) GetChannelPropertiesId() int64 {
	if m != nil {
		return m.ChannelPropertiesId
	}
	return 0
}

func (m *ChannelPropertiesUpdateRequest) GetUpdate() *ChannelPropertiesUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

type ChannelPropertiesShowRequest struct {
	Channel              string   `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelPropertiesShowRequest) Reset()         { *m = ChannelPropertiesShowRequest{} }
func (m *ChannelPropertiesShowRequest) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesShowRequest) ProtoMessage()    {}
func (*ChannelPropertiesShowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{2}
}
func (m *ChannelPropertiesShowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesShowRequest.Unmarshal(m, b)
}
func (m *ChannelPropertiesShowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesShowRequest.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesShowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesShowRequest.Merge(dst, src)
}
func (m *ChannelPropertiesShowRequest) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesShowRequest.Size(m)
}
func (m *ChannelPropertiesShowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesShowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesShowRequest proto.InternalMessageInfo

func (m *ChannelPropertiesShowRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type ChannelPropertiesUpdate struct {
	VideoCodec           *wrappers.StringValue `protobuf:"bytes,1,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	AudioCodec           *wrappers.StringValue `protobuf:"bytes,2,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	AvcProfile           *wrappers.StringValue `protobuf:"bytes,3,opt,name=avc_profile,proto3" json:"avc_profile,omitempty"`
	TargetFps            *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=target_fps,proto3" json:"target_fps,omitempty"`
	Vfr                  *wrappers.BoolValue   `protobuf:"bytes,5,opt,name=vfr,proto3" json:"vfr,omitempty"`
	AvcLevel             *wrappers.StringValue `protobuf:"bytes,6,opt,name=avc_level,proto3" json:"avc_level,omitempty"`
	Channels             *wrappers.Int32Value  `protobuf:"bytes,7,opt,name=channels,proto3" json:"channels,omitempty"`
	WidthPixels          *wrappers.Int32Value  `protobuf:"bytes,8,opt,name=width_pixels,json=width,proto3" json:"width_pixels,omitempty"`
	HeightPixels         *wrappers.Int32Value  `protobuf:"bytes,9,opt,name=height_pixels,json=height,proto3" json:"height_pixels,omitempty"`
	SampleRateHz         *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=sample_rate_hz,json=sample_rate,proto3" json:"sample_rate_hz,omitempty"`
	IdrAlignedRatio      *wrappers.DoubleValue `protobuf:"bytes,11,opt,name=idr_aligned_ratio,json=idr_aligned_percent,proto3" json:"idr_aligned_ratio,omitempty"`
	AverageFps           *wrappers.DoubleValue `protobuf:"bytes,12,opt,name=average_fps,proto3" json:"average_fps,omitempty"`
	AverageKbps          *wrappers.DoubleValue `protobuf:"bytes,13,opt,name=average_kbps,proto3" json:"average_kbps,omitempty"`
	MaxKbps              *wrappers.DoubleValue `protobuf:"bytes,14,opt,name=max_kbps,proto3" json:"max_kbps,omitempty"`
	MaxIdrDeltaMillis    *wrappers.DoubleValue `protobuf:"bytes,25,opt,name=max_idr_delta_millis,json=max_idr_delta,proto3" json:"max_idr_delta_millis,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ChannelPropertiesUpdate) Reset()         { *m = ChannelPropertiesUpdate{} }
func (m *ChannelPropertiesUpdate) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesUpdate) ProtoMessage()    {}
func (*ChannelPropertiesUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{3}
}
func (m *ChannelPropertiesUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesUpdate.Unmarshal(m, b)
}
func (m *ChannelPropertiesUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesUpdate.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesUpdate.Merge(dst, src)
}
func (m *ChannelPropertiesUpdate) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesUpdate.Size(m)
}
func (m *ChannelPropertiesUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesUpdate proto.InternalMessageInfo

func (m *ChannelPropertiesUpdate) GetVideoCodec() *wrappers.StringValue {
	if m != nil {
		return m.VideoCodec
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetAudioCodec() *wrappers.StringValue {
	if m != nil {
		return m.AudioCodec
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetAvcProfile() *wrappers.StringValue {
	if m != nil {
		return m.AvcProfile
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetTargetFps() *wrappers.DoubleValue {
	if m != nil {
		return m.TargetFps
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetVfr() *wrappers.BoolValue {
	if m != nil {
		return m.Vfr
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetAvcLevel() *wrappers.StringValue {
	if m != nil {
		return m.AvcLevel
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetChannels() *wrappers.Int32Value {
	if m != nil {
		return m.Channels
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetWidthPixels() *wrappers.Int32Value {
	if m != nil {
		return m.WidthPixels
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetHeightPixels() *wrappers.Int32Value {
	if m != nil {
		return m.HeightPixels
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetSampleRateHz() *wrappers.DoubleValue {
	if m != nil {
		return m.SampleRateHz
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetIdrAlignedRatio() *wrappers.DoubleValue {
	if m != nil {
		return m.IdrAlignedRatio
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetAverageFps() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageFps
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetAverageKbps() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageKbps
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetMaxKbps() *wrappers.DoubleValue {
	if m != nil {
		return m.MaxKbps
	}
	return nil
}

func (m *ChannelPropertiesUpdate) GetMaxIdrDeltaMillis() *wrappers.DoubleValue {
	if m != nil {
		return m.MaxIdrDeltaMillis
	}
	return nil
}

type ChannelPropertiesStreamViewcountsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelPropertiesStreamViewcountsRequest) Reset() {
	*m = ChannelPropertiesStreamViewcountsRequest{}
}
func (m *ChannelPropertiesStreamViewcountsRequest) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesStreamViewcountsRequest) ProtoMessage()    {}
func (*ChannelPropertiesStreamViewcountsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{4}
}
func (m *ChannelPropertiesStreamViewcountsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest.Unmarshal(m, b)
}
func (m *ChannelPropertiesStreamViewcountsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesStreamViewcountsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest.Merge(dst, src)
}
func (m *ChannelPropertiesStreamViewcountsRequest) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest.Size(m)
}
func (m *ChannelPropertiesStreamViewcountsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesStreamViewcountsRequest proto.InternalMessageInfo

type ChannelPropertiesLiveHLSChannelsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelPropertiesLiveHLSChannelsRequest) Reset() {
	*m = ChannelPropertiesLiveHLSChannelsRequest{}
}
func (m *ChannelPropertiesLiveHLSChannelsRequest) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesLiveHLSChannelsRequest) ProtoMessage()    {}
func (*ChannelPropertiesLiveHLSChannelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{5}
}
func (m *ChannelPropertiesLiveHLSChannelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest.Unmarshal(m, b)
}
func (m *ChannelPropertiesLiveHLSChannelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesLiveHLSChannelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest.Merge(dst, src)
}
func (m *ChannelPropertiesLiveHLSChannelsRequest) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest.Size(m)
}
func (m *ChannelPropertiesLiveHLSChannelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesLiveHLSChannelsRequest proto.InternalMessageInfo

type ChannelPropertiesLiveHLSChannelsResponse struct {
	Channels             []string `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelPropertiesLiveHLSChannelsResponse) Reset() {
	*m = ChannelPropertiesLiveHLSChannelsResponse{}
}
func (m *ChannelPropertiesLiveHLSChannelsResponse) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesLiveHLSChannelsResponse) ProtoMessage()    {}
func (*ChannelPropertiesLiveHLSChannelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{6}
}
func (m *ChannelPropertiesLiveHLSChannelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse.Unmarshal(m, b)
}
func (m *ChannelPropertiesLiveHLSChannelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesLiveHLSChannelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse.Merge(dst, src)
}
func (m *ChannelPropertiesLiveHLSChannelsResponse) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse.Size(m)
}
func (m *ChannelPropertiesLiveHLSChannelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesLiveHLSChannelsResponse proto.InternalMessageInfo

func (m *ChannelPropertiesLiveHLSChannelsResponse) GetChannels() []string {
	if m != nil {
		return m.Channels
	}
	return nil
}

type ChannelPropertiesListRequest struct {
	// 1 to 100, use for pagination
	Limit int32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// offset to start from, use for pagination
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// comma-separated list of channel names
	Channel string `protobuf:"bytes,3,opt,name=channel,proto3" json:"channel,omitempty"`
	// comma-separated list of channel ids
	ChannelId            string   `protobuf:"bytes,4,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelPropertiesListRequest) Reset()         { *m = ChannelPropertiesListRequest{} }
func (m *ChannelPropertiesListRequest) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesListRequest) ProtoMessage()    {}
func (*ChannelPropertiesListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{7}
}
func (m *ChannelPropertiesListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesListRequest.Unmarshal(m, b)
}
func (m *ChannelPropertiesListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesListRequest.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesListRequest.Merge(dst, src)
}
func (m *ChannelPropertiesListRequest) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesListRequest.Size(m)
}
func (m *ChannelPropertiesListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesListRequest proto.InternalMessageInfo

func (m *ChannelPropertiesListRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ChannelPropertiesListRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ChannelPropertiesListRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *ChannelPropertiesListRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type ListOf_ChannelPropertiesListResponse struct {
	// This is actually just an anonymous list in the response
	ChannelProperties    []*ChannelPropertiesListItem `protobuf:"bytes,1,rep,name=channel_properties,json=channelProperties,proto3" json:"channel_properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ListOf_ChannelPropertiesListResponse) Reset()         { *m = ListOf_ChannelPropertiesListResponse{} }
func (m *ListOf_ChannelPropertiesListResponse) String() string { return proto.CompactTextString(m) }
func (*ListOf_ChannelPropertiesListResponse) ProtoMessage()    {}
func (*ListOf_ChannelPropertiesListResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{8}
}
func (m *ListOf_ChannelPropertiesListResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_ChannelPropertiesListResponse.Unmarshal(m, b)
}
func (m *ListOf_ChannelPropertiesListResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_ChannelPropertiesListResponse.Marshal(b, m, deterministic)
}
func (dst *ListOf_ChannelPropertiesListResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_ChannelPropertiesListResponse.Merge(dst, src)
}
func (m *ListOf_ChannelPropertiesListResponse) XXX_Size() int {
	return xxx_messageInfo_ListOf_ChannelPropertiesListResponse.Size(m)
}
func (m *ListOf_ChannelPropertiesListResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_ChannelPropertiesListResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_ChannelPropertiesListResponse proto.InternalMessageInfo

func (m *ListOf_ChannelPropertiesListResponse) GetChannelProperties() []*ChannelPropertiesListItem {
	if m != nil {
		return m.ChannelProperties
	}
	return nil
}

type ChannelPropertiesListItem struct {
	AvcLevel       string  `protobuf:"bytes,1,opt,name=avc_level,proto3" json:"avc_level,omitempty"`
	AvcProfile     string  `protobuf:"bytes,2,opt,name=avc_profile,proto3" json:"avc_profile,omitempty"`
	AverageFps     float32 `protobuf:"fixed32,3,opt,name=average_fps,proto3" json:"average_fps,omitempty"`
	BroadcastPart  int64   `protobuf:"varint,4,opt,name=broadcast_part,proto3" json:"broadcast_part,omitempty"`
	Broadcaster    string  `protobuf:"bytes,5,opt,name=broadcaster,proto3" json:"broadcaster,omitempty"`
	Channel        string  `protobuf:"bytes,6,opt,name=channel,proto3" json:"channel,omitempty"`
	ChannelCount   int64   `protobuf:"varint,7,opt,name=channel_count,proto3" json:"channel_count,omitempty"`
	ChannelId      int64   `protobuf:"varint,8,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	ClientId       string  `protobuf:"bytes,9,opt,name=client_id,proto3" json:"client_id,omitempty"`
	Configuration  string  `protobuf:"bytes,10,opt,name=configuration,proto3" json:"configuration,omitempty"`
	DelayLength    int64   `protobuf:"varint,11,opt,name=delay_length,proto3" json:"delay_length,omitempty"`
	EmbedCount     int64   `protobuf:"varint,12,opt,name=embed_count,proto3" json:"embed_count,omitempty"`
	Encrypted      bool    `protobuf:"varint,13,opt,name=encrypted,proto3" json:"encrypted,omitempty"`
	Geo            string  `protobuf:"bytes,14,opt,name=geo,proto3" json:"geo,omitempty"`
	Hls            bool    `protobuf:"varint,15,opt,name=hls,proto3" json:"hls,omitempty"`
	Id             int64   `protobuf:"varint,16,opt,name=id,proto3" json:"id,omitempty"`
	MinimumHeight  int64   `protobuf:"varint,17,opt,name=minimum_height,proto3" json:"minimum_height,omitempty"`
	MinimumLevel   string  `protobuf:"bytes,18,opt,name=minimum_level,proto3" json:"minimum_level,omitempty"`
	MinimumProfile string  `protobuf:"bytes,19,opt,name=minimum_profile,proto3" json:"minimum_profile,omitempty"`
	Partner        bool    `protobuf:"varint,20,opt,name=partner,proto3" json:"partner,omitempty"`
	SiteCount      int64   `protobuf:"varint,21,opt,name=site_count,proto3" json:"site_count,omitempty"`
	// Timestamp in rfc3339
	UpTime string `protobuf:"bytes,22,opt,name=up_time,proto3" json:"up_time,omitempty"`
	// time object generated from original up_time string
	UpTimeTimestamp *timestamp.Timestamp `protobuf:"bytes,23,opt,name=up_time_timestamp,proto3" json:"up_time_timestamp,omitempty"`
	// Timestamp in rfc3339
	UpdatedOn string `protobuf:"bytes,24,opt,name=updated_on,proto3" json:"updated_on,omitempty"`
	// time object generated from original updated_on string
	UpdatedOnTimestamp   *timestamp.Timestamp `protobuf:"bytes,25,opt,name=updated_on_timestamp,proto3" json:"updated_on_timestamp,omitempty"`
	VideoBitrate         float32              `protobuf:"fixed32,26,opt,name=video_bitrate,proto3" json:"video_bitrate,omitempty"`
	VideoCodec           string               `protobuf:"bytes,27,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	VideoHeight          int64                `protobuf:"varint,28,opt,name=video_height,proto3" json:"video_height,omitempty"`
	VideoWidth           int64                `protobuf:"varint,29,opt,name=video_width,proto3" json:"video_width,omitempty"`
	VodId                int64                `protobuf:"varint,30,opt,name=vod_id,proto3" json:"vod_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ChannelPropertiesListItem) Reset()         { *m = ChannelPropertiesListItem{} }
func (m *ChannelPropertiesListItem) String() string { return proto.CompactTextString(m) }
func (*ChannelPropertiesListItem) ProtoMessage()    {}
func (*ChannelPropertiesListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_channel_properties_4d1e2380c7ca7949, []int{9}
}
func (m *ChannelPropertiesListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPropertiesListItem.Unmarshal(m, b)
}
func (m *ChannelPropertiesListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPropertiesListItem.Marshal(b, m, deterministic)
}
func (dst *ChannelPropertiesListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPropertiesListItem.Merge(dst, src)
}
func (m *ChannelPropertiesListItem) XXX_Size() int {
	return xxx_messageInfo_ChannelPropertiesListItem.Size(m)
}
func (m *ChannelPropertiesListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPropertiesListItem.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPropertiesListItem proto.InternalMessageInfo

func (m *ChannelPropertiesListItem) GetAvcLevel() string {
	if m != nil {
		return m.AvcLevel
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetAvcProfile() string {
	if m != nil {
		return m.AvcProfile
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetAverageFps() float32 {
	if m != nil {
		return m.AverageFps
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetBroadcastPart() int64 {
	if m != nil {
		return m.BroadcastPart
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetBroadcaster() string {
	if m != nil {
		return m.Broadcaster
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetChannelCount() int64 {
	if m != nil {
		return m.ChannelCount
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetConfiguration() string {
	if m != nil {
		return m.Configuration
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetDelayLength() int64 {
	if m != nil {
		return m.DelayLength
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetEmbedCount() int64 {
	if m != nil {
		return m.EmbedCount
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetEncrypted() bool {
	if m != nil {
		return m.Encrypted
	}
	return false
}

func (m *ChannelPropertiesListItem) GetGeo() string {
	if m != nil {
		return m.Geo
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetHls() bool {
	if m != nil {
		return m.Hls
	}
	return false
}

func (m *ChannelPropertiesListItem) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetMinimumHeight() int64 {
	if m != nil {
		return m.MinimumHeight
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetMinimumLevel() string {
	if m != nil {
		return m.MinimumLevel
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetMinimumProfile() string {
	if m != nil {
		return m.MinimumProfile
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetPartner() bool {
	if m != nil {
		return m.Partner
	}
	return false
}

func (m *ChannelPropertiesListItem) GetSiteCount() int64 {
	if m != nil {
		return m.SiteCount
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetUpTime() string {
	if m != nil {
		return m.UpTime
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetUpTimeTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.UpTimeTimestamp
	}
	return nil
}

func (m *ChannelPropertiesListItem) GetUpdatedOn() string {
	if m != nil {
		return m.UpdatedOn
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetUpdatedOnTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedOnTimestamp
	}
	return nil
}

func (m *ChannelPropertiesListItem) GetVideoBitrate() float32 {
	if m != nil {
		return m.VideoBitrate
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *ChannelPropertiesListItem) GetVideoHeight() int64 {
	if m != nil {
		return m.VideoHeight
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetVideoWidth() int64 {
	if m != nil {
		return m.VideoWidth
	}
	return 0
}

func (m *ChannelPropertiesListItem) GetVodId() int64 {
	if m != nil {
		return m.VodId
	}
	return 0
}

func init() {
	proto.RegisterType((*ChannelProperties)(nil), "twitch.video.usher.ChannelProperties")
	proto.RegisterType((*ChannelPropertiesUpdateRequest)(nil), "twitch.video.usher.ChannelPropertiesUpdateRequest")
	proto.RegisterType((*ChannelPropertiesShowRequest)(nil), "twitch.video.usher.ChannelPropertiesShowRequest")
	proto.RegisterType((*ChannelPropertiesUpdate)(nil), "twitch.video.usher.ChannelPropertiesUpdate")
	proto.RegisterType((*ChannelPropertiesStreamViewcountsRequest)(nil), "twitch.video.usher.ChannelPropertiesStreamViewcountsRequest")
	proto.RegisterType((*ChannelPropertiesLiveHLSChannelsRequest)(nil), "twitch.video.usher.ChannelPropertiesLiveHLSChannelsRequest")
	proto.RegisterType((*ChannelPropertiesLiveHLSChannelsResponse)(nil), "twitch.video.usher.ChannelPropertiesLiveHLSChannelsResponse")
	proto.RegisterType((*ChannelPropertiesListRequest)(nil), "twitch.video.usher.ChannelPropertiesListRequest")
	proto.RegisterType((*ListOf_ChannelPropertiesListResponse)(nil), "twitch.video.usher.ListOf_ChannelPropertiesListResponse")
	proto.RegisterType((*ChannelPropertiesListItem)(nil), "twitch.video.usher.ChannelPropertiesListItem")
}

func init() {
	proto.RegisterFile("code.justin.tv/video/usherapi/rpc/usher/channel_properties.proto", fileDescriptor_channel_properties_4d1e2380c7ca7949)
}

var fileDescriptor_channel_properties_4d1e2380c7ca7949 = []byte{
	// 1212 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x57, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x06, 0xa5, 0x48, 0x96, 0x56, 0xb2, 0x12, 0xaf, 0x9d, 0x84, 0x71, 0x1c, 0x47, 0x50, 0x83,
	0x44, 0x69, 0x5a, 0x09, 0x70, 0x0e, 0x35, 0x82, 0xc2, 0x48, 0x93, 0xa2, 0x88, 0x01, 0xa3, 0x2d,
	0xe8, 0x36, 0x87, 0xa2, 0x00, 0x41, 0x91, 0x23, 0x69, 0x5b, 0x92, 0xcb, 0x92, 0x4b, 0x39, 0xe9,
	0xb9, 0xe8, 0x03, 0xf4, 0xd6, 0xa7, 0xe8, 0x6b, 0xf4, 0xb1, 0x8a, 0x9d, 0x25, 0xa5, 0x25, 0x69,
	0xd5, 0xbc, 0x71, 0xbe, 0x9d, 0x99, 0xfd, 0x9b, 0xef, 0xdb, 0x21, 0x79, 0xed, 0x72, 0x0f, 0x26,
	0xbf, 0xa4, 0x89, 0x60, 0xe1, 0x44, 0xac, 0xa6, 0x2b, 0xe6, 0x01, 0x9f, 0xa6, 0xc9, 0x12, 0x62,
	0x27, 0x62, 0xd3, 0x38, 0x72, 0x95, 0x31, 0x75, 0x97, 0x4e, 0x18, 0x82, 0x6f, 0x47, 0x31, 0x8f,
	0x20, 0x16, 0x0c, 0x92, 0x49, 0x14, 0x73, 0xc1, 0x29, 0x15, 0x57, 0x4c, 0xb8, 0xcb, 0x09, 0x46,
	0x4e, 0xd0, 0xf9, 0xf0, 0xf1, 0x82, 0xf3, 0x85, 0x0f, 0x53, 0xf4, 0x98, 0xa5, 0xf3, 0xa9, 0x60,
	0x01, 0x24, 0xc2, 0x09, 0x22, 0x15, 0x74, 0x78, 0x5c, 0x76, 0xb8, 0x8a, 0x9d, 0x28, 0x82, 0x38,
	0x4b, 0x3a, 0xfa, 0xab, 0x45, 0xf6, 0xde, 0xaa, 0x19, 0xbf, 0x5f, 0x4f, 0x48, 0x07, 0xa4, 0xc1,
	0x3c, 0xd3, 0x18, 0x1a, 0xe3, 0xa6, 0xd5, 0x60, 0x1e, 0x3d, 0x26, 0x24, 0x5f, 0x16, 0xf3, 0xcc,
	0x06, 0xe2, 0x1a, 0x42, 0x4d, 0xb2, 0x93, 0x59, 0x66, 0x73, 0x68, 0x8c, 0xbb, 0x56, 0x6e, 0xd2,
	0x21, 0xe9, 0xb9, 0x69, 0x22, 0x78, 0x00, 0xb1, 0x0c, 0xbd, 0x85, 0xa3, 0x3a, 0x44, 0x1f, 0x13,
	0xe2, 0xf2, 0x50, 0x40, 0x28, 0xa4, 0x43, 0xab, 0xea, 0x30, 0x24, 0x3d, 0xdc, 0xb2, 0x2d, 0x4f,
	0xd0, 0x35, 0xdb, 0xca, 0x43, 0x83, 0xa4, 0x87, 0x93, 0x7a, 0x2c, 0xf7, 0xd8, 0x51, 0x1e, 0x1a,
	0x84, 0x1e, 0x2b, 0x57, 0x9e, 0xe9, 0x9c, 0xf9, 0x60, 0x76, 0x32, 0x8f, 0x0d, 0x24, 0xb7, 0x28,
	0x9c, 0x78, 0x01, 0xc2, 0x9e, 0x47, 0x89, 0xd9, 0x1d, 0x1a, 0x63, 0xc3, 0xd2, 0x10, 0x7a, 0x87,
	0x34, 0x57, 0xf3, 0xd8, 0x24, 0x43, 0x63, 0xdc, 0xb1, 0xe4, 0x27, 0x3d, 0x22, 0x5d, 0x99, 0xc0,
	0x87, 0x15, 0xf8, 0x66, 0x0f, 0x33, 0x6e, 0x00, 0x7a, 0x48, 0x3a, 0xd9, 0x19, 0x24, 0x66, 0x7f,
	0x68, 0x8c, 0x5b, 0xd6, 0xda, 0xa6, 0x0f, 0x49, 0xff, 0x8a, 0x79, 0x62, 0x69, 0x47, 0xec, 0x83,
	0x1c, 0xdf, 0xc5, 0xf1, 0x16, 0x62, 0xf4, 0x11, 0xd9, 0x5d, 0x02, 0x5b, 0x2c, 0x45, 0x3e, 0x3a,
	0xc0, 0xd1, 0xb6, 0x02, 0xe9, 0x27, 0x64, 0x90, 0x38, 0x41, 0xe4, 0x83, 0x1d, 0x3b, 0x02, 0xec,
	0xe5, 0xef, 0xe6, 0x6d, 0x5c, 0x6b, 0x4f, 0x43, 0xe9, 0x84, 0xec, 0x31, 0x2f, 0xb6, 0x1d, 0x9f,
	0x2d, 0x42, 0xf0, 0x24, 0xc6, 0xb8, 0x79, 0x07, 0xfd, 0xf6, 0xf5, 0x81, 0x08, 0x62, 0x17, 0x42,
	0xa1, 0x8e, 0x07, 0x62, 0x67, 0x01, 0xb8, 0xfb, 0x3d, 0x95, 0x51, 0x83, 0xe8, 0x88, 0xf4, 0x73,
	0xf3, 0xd7, 0x59, 0x94, 0x98, 0x14, 0x5d, 0x0a, 0x98, 0xdc, 0x72, 0xe0, 0x7c, 0x50, 0xe3, 0xfb,
	0x38, 0xbe, 0xb6, 0xe9, 0x0b, 0x72, 0x20, 0xbf, 0xe5, 0xe4, 0x1e, 0xf8, 0xc2, 0xb1, 0x03, 0xe6,
	0xfb, 0x2c, 0x31, 0x0f, 0xd0, 0x6f, 0xb7, 0x30, 0x36, 0xfa, 0xdb, 0x20, 0xc7, 0x95, 0xa2, 0xfc,
	0x31, 0xf2, 0x1c, 0x01, 0x16, 0xfc, 0x96, 0x42, 0x22, 0xe8, 0x09, 0xb9, 0x5b, 0x25, 0x8a, 0xbd,
	0x2e, 0xda, 0x7d, 0xb7, 0x1c, 0x7e, 0xee, 0xd1, 0xb7, 0xa4, 0x9d, 0x62, 0x12, 0xac, 0xe0, 0xde,
	0xc9, 0x8b, 0x49, 0x95, 0x51, 0x93, 0x6d, 0xf3, 0x66, 0xa1, 0xa3, 0x53, 0x72, 0x54, 0x71, 0xb9,
	0x5c, 0xf2, 0xab, 0x7c, 0x61, 0x1a, 0x15, 0x8c, 0x02, 0x15, 0x46, 0xff, 0xee, 0x90, 0xfb, 0x5b,
	0xb2, 0xd3, 0xb3, 0x62, 0x8d, 0x1b, 0xb8, 0xbe, 0xa3, 0x89, 0x22, 0xef, 0x24, 0x27, 0xef, 0xe4,
	0x52, 0xc4, 0x2c, 0x5c, 0xbc, 0x77, 0xfc, 0x14, 0x8a, 0x0c, 0x38, 0x2b, 0x32, 0xa0, 0x51, 0x27,
	0x5e, 0xe7, 0xc7, 0x59, 0x91, 0x1f, 0xcd, 0x5a, 0xf1, 0x1a, 0x7b, 0xbe, 0x2c, 0xb0, 0xe7, 0xd6,
	0x96, 0xf0, 0xaf, 0x79, 0x3a, 0xf3, 0x41, 0x85, 0xeb, 0xdc, 0xfa, 0x4c, 0x71, 0xab, 0x85, 0x61,
	0x87, 0x95, 0xb0, 0x37, 0x9c, 0xfb, 0x2a, 0x08, 0x79, 0xf7, 0x4a, 0xe7, 0x5d, 0xbb, 0xc6, 0x4a,
	0x35, 0x56, 0x7e, 0xa1, 0xb1, 0x72, 0x07, 0x43, 0x1f, 0x56, 0x42, 0xcf, 0x43, 0xf1, 0xf2, 0x44,
	0x45, 0x6e, 0x28, 0x7b, 0x5a, 0xa2, 0x6c, 0xe7, 0xe6, 0xe0, 0x8c, 0xcf, 0xaf, 0xca, 0x7c, 0xee,
	0xde, 0x1c, 0x9a, 0x93, 0xfd, 0xab, 0x0a, 0xd9, 0x49, 0x8d, 0xa3, 0x2d, 0x48, 0xc1, 0xc5, 0x75,
	0x52, 0xd0, 0xab, 0x91, 0xe5, 0x5a, 0xa1, 0x38, 0x2b, 0x0a, 0x45, 0xbf, 0xce, 0x6a, 0x74, 0x19,
	0x79, 0x5d, 0x92, 0x91, 0xdd, 0x1a, 0x09, 0x8a, 0x22, 0x73, 0xaa, 0x89, 0xcc, 0xa0, 0x46, 0xf4,
	0x46, 0x82, 0xce, 0xb7, 0x48, 0xd0, 0x83, 0x1a, 0x59, 0x4a, 0x02, 0xf5, 0x29, 0x19, 0x57, 0x45,
	0x40, 0xc4, 0xe0, 0x04, 0xef, 0x19, 0x5c, 0xb9, 0x3c, 0x0d, 0x45, 0x92, 0x09, 0xc2, 0xe8, 0x39,
	0x79, 0x56, 0xf1, 0xbd, 0x60, 0x2b, 0x78, 0x77, 0x71, 0x99, 0xe1, 0x6b, 0xd7, 0x6f, 0xae, 0x49,
	0x5b, 0x71, 0x4d, 0x22, 0x1e, 0x26, 0x50, 0x78, 0x5f, 0x8c, 0x61, 0x73, 0xdc, 0xdd, 0x14, 0xeb,
	0xe8, 0x4f, 0xe3, 0x1a, 0x91, 0xba, 0x60, 0x89, 0xc8, 0x45, 0xea, 0x80, 0xb4, 0x7c, 0x16, 0x30,
	0x81, 0x42, 0xd3, 0xb2, 0x94, 0x41, 0xef, 0x91, 0x36, 0x9f, 0xcf, 0x13, 0x10, 0xa8, 0x1f, 0x2d,
	0x2b, 0xb3, 0xfe, 0xe7, 0x75, 0x2f, 0xf6, 0x05, 0xea, 0x71, 0xd7, 0x90, 0xd1, 0x1f, 0x06, 0x79,
	0x22, 0xe7, 0xfd, 0x6e, 0x6e, 0x6f, 0x59, 0x4f, 0xb6, 0x9b, 0x9f, 0x09, 0xad, 0xca, 0x39, 0xee,
	0xab, 0x77, 0xf2, 0x79, 0x2d, 0x99, 0x96, 0xe9, 0xce, 0x05, 0x04, 0xd6, 0x5e, 0x45, 0xfa, 0x47,
	0xff, 0x74, 0xc8, 0x83, 0xad, 0x01, 0xc5, 0x77, 0xdc, 0x28, 0xbf, 0xe3, 0xa5, 0xce, 0xa1, 0x51,
	0xed, 0x1c, 0x4a, 0x8f, 0xa7, 0x3c, 0xa2, 0x46, 0xb1, 0xea, 0x9f, 0x92, 0xc1, 0x2c, 0xe6, 0x8e,
	0xe7, 0x3a, 0x89, 0xb0, 0x23, 0x27, 0x16, 0x78, 0x54, 0x4d, 0xab, 0x84, 0xca, 0x4c, 0x6b, 0x04,
	0xe2, 0xbc, 0x17, 0xd2, 0x20, 0xfd, 0x2a, 0xda, 0xc5, 0xab, 0x78, 0x42, 0x76, 0xf3, 0x13, 0xc4,
	0xfa, 0x43, 0x79, 0x6b, 0x5a, 0x45, 0xb0, 0x74, 0x61, 0x9d, 0x4a, 0x23, 0x77, 0x44, 0xba, 0xae,
	0xcf, 0xb2, 0x5e, 0xac, 0xab, 0xce, 0x62, 0x0d, 0xe0, 0x1c, 0x3c, 0x9c, 0xb3, 0x45, 0x8a, 0x32,
	0x12, 0xa2, 0x1a, 0x75, 0xad, 0x22, 0x28, 0x5b, 0x05, 0x0f, 0x7c, 0xe7, 0xa3, 0xed, 0x43, 0xb8,
	0x10, 0x4b, 0x14, 0x9b, 0xa6, 0x55, 0xc0, 0xe4, 0x4e, 0x21, 0x98, 0x81, 0x97, 0xad, 0xb5, 0x8f,
	0x2e, 0x3a, 0x24, 0x57, 0x02, 0xa1, 0x1b, 0x7f, 0x8c, 0x04, 0x78, 0x28, 0x13, 0x1d, 0x6b, 0x03,
	0xc8, 0x6e, 0x6c, 0x01, 0x1c, 0x05, 0xa0, 0x6b, 0xc9, 0x4f, 0x89, 0x2c, 0xfd, 0x04, 0x9b, 0xa1,
	0x8e, 0x25, 0x3f, 0xb3, 0x26, 0xf6, 0xce, 0xba, 0x89, 0x7d, 0x4a, 0x06, 0x01, 0x0b, 0x59, 0x90,
	0x06, 0xb6, 0x92, 0x57, 0xec, 0x73, 0x9a, 0x56, 0x09, 0x95, 0xbb, 0xcc, 0x11, 0x55, 0x13, 0x54,
	0xed, 0xb2, 0x00, 0xd2, 0x31, 0xb9, 0x9d, 0x03, 0x79, 0x6d, 0xec, 0xa3, 0x5f, 0x19, 0x96, 0x77,
	0x26, 0x6f, 0x37, 0x84, 0x18, 0xbb, 0x9d, 0x8e, 0x95, 0x9b, 0xf2, 0x36, 0x12, 0x26, 0x20, 0x3b,
	0x84, 0xbb, 0xea, 0x36, 0x36, 0x88, 0x8c, 0x4c, 0x23, 0x5b, 0xb6, 0xf4, 0xe6, 0x3d, 0x75, 0xdb,
	0x99, 0x49, 0xdf, 0x91, 0xbd, 0xec, 0xd3, 0x5e, 0x77, 0xfc, 0xe6, 0xfd, 0x2d, 0xef, 0xe7, 0x0f,
	0xb9, 0x87, 0x55, 0x0d, 0x92, 0x6b, 0x50, 0x9d, 0x8d, 0x67, 0xf3, 0xd0, 0x34, 0x15, 0x85, 0x37,
	0x08, 0xfd, 0x96, 0x1c, 0x6c, 0x2c, 0x6d, 0xb2, 0x07, 0x37, 0x4e, 0x76, 0x6d, 0x9c, 0x3c, 0x5d,
	0xd5, 0xb8, 0xcc, 0x98, 0x90, 0x0f, 0x94, 0x79, 0x88, 0x7c, 0x29, 0x82, 0xe5, 0x9e, 0xff, 0x61,
	0xb5, 0xe7, 0x1f, 0x91, 0xbe, 0x32, 0xb3, 0xbb, 0x3c, 0x52, 0x55, 0xa6, 0x63, 0x9b, 0x2c, 0xf8,
	0x12, 0x9b, 0x8f, 0x54, 0x95, 0x69, 0x90, 0x94, 0xbc, 0x15, 0xf7, 0x64, 0xb1, 0x1f, 0xe3, 0x60,
	0x66, 0xbd, 0x79, 0xfe, 0xd3, 0xb3, 0x9a, 0xff, 0x6b, 0xb3, 0x36, 0x6e, 0xfd, 0xe5, 0x7f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x8c, 0xb2, 0x40, 0x15, 0xe1, 0x0d, 0x00, 0x00,
}
