// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/video/usherapi/rpc/usher/stream.proto

package usher // import "code.justin.tv/video/usherapi/rpc/usher"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Stream is a common type representing usher video streams.
type Stream struct {
	// Identity
	// id is the standard video system stream_id, referenced throughout various
	// systems for identifying a single playable video stream
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// name is set based on the stream format (which is nearly always hls) and
	// either the twitch channel name, or the customer + content id
	//
	// For Twitch streams this looks like:
	//   "hls_user_ninja"
	//
	// For LVS streams this looks like:
	//   "hls_user_lvs.TwitchDev.teststream1"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// channel is the twitch channel name. this field should not be used for any
	// purpose other than display, channel_id should be used instead to identify
	// channels
	Channel string `protobuf:"bytes,3,opt,name=channel,proto3" json:"channel,omitempty"`
	// channel_id is the identifier for a channel in the Twitch users database
	ChannelId int64 `protobuf:"varint,4,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	// Timestamps
	// start_time_ansic represents the time at which this stream entry was created
	// in ASIC format. Usher has historically run on Pacific time. This is not
	// necessarily the time at which it became playable. Notably this timestamp is
	// missing timezone information
	//
	// Strings will look like this:
	//   "Thu Jun 14 22:54:32 2018"
	StartTimeAnsic string `protobuf:"bytes,11,opt,name=start_time_ansic,json=up_time,proto3" json:"start_time_ansic,omitempty"`
	// update_time_ansic represents the last time at which this stream entry was
	// updated in ANSIC format. Stream entries must be updated on a regular
	// interval or usher will garbage collect them, so this is used as a livenes
	// mechanism.
	UpdateTimeAnsic string `protobuf:"bytes,12,opt,name=update_time_ansic,json=updated_on,proto3" json:"update_time_ansic,omitempty"`
	// Metadata
	// format is nearly always set to "hls" and may not be used any more, but it
	// is used to form a stream's name. In previous iterations of the video system
	// format could have been "live" (which referred to rtmp) or a few other values
	Format string `protobuf:"bytes,21,opt,name=format,proto3" json:"format,omitempty"`
	// broadcaster is read from the broadcast_tag typically, and is used to indicate
	// when special broadcast integrations are in use (rebroadcasts, delay, etc)
	Broadcaster string `protobuf:"bytes,22,opt,name=broadcaster,proto3" json:"broadcaster,omitempty"`
	// broadcast_tag is the RTMP query string from the rtmp broadcast for this stream
	BroadcastTag string `protobuf:"bytes,23,opt,name=broadcast_tag,proto3" json:"broadcast_tag,omitempty"`
	// video_codec is the codec of the video source of this broadcast
	VideoCodec string `protobuf:"bytes,24,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	// audio_codec is the codec of the audio source of this broadcast
	AudioCodec string `protobuf:"bytes,25,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	// type appears to mostly be "stream"
	// TODO: improve this documentation
	Type string `protobuf:"bytes,26,opt,name=type,proto3" json:"type,omitempty"`
	// stream_type appears to mostly be "hls"
	// TODO: improve this documentation
	StreamType string `protobuf:"bytes,27,opt,name=stream_type,proto3" json:"stream_type,omitempty"`
	// origin_name appears to mostly be "hls"
	// TODO: improve this documentation
	OriginName string `protobuf:"bytes,28,opt,name=origin_name,proto3" json:"origin_name,omitempty"`
	// stream state
	// ready notes whether this stream is playable (and thus findable)
	Ready bool `protobuf:"varint,40,opt,name=ready,proto3" json:"ready,omitempty"`
	// starved was originally used to indicate that a stream was starving, it is
	// unclear if this is still the case for HLS streams (but may be)
	Starved bool `protobuf:"varint,41,opt,name=starved,proto3" json:"starved,omitempty"`
	// connect was originally used to store the RTMP connect string for a stream
	// it may no longer be used but as it's unclear we are including it here
	Connect string `protobuf:"bytes,42,opt,name=connect,proto3" json:"connect,omitempty"`
	// lvs fields
	// customer_id is the LVS customer_id, set to "twitch" for Twitch streams. LVS
	// IDs have a schema, refer to git-aws.internal.justin.tv/video/lvsapi for
	// more detail
	CustomerId string `protobuf:"bytes,50,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	// content_id is the LVS content_id, an arbitrary string passed in by users.
	// it will always be set to the stringified channel_id
	ContentId string `protobuf:"bytes,51,opt,name=content_id,proto3" json:"content_id,omitempty"`
	// twitch_content should not be used
	TwitchContent bool `protobuf:"varint,52,opt,name=twitch_content,proto3" json:"twitch_content,omitempty"` // Deprecated: Do not use.
	// viewcount fields
	SiteCount     int32   `protobuf:"varint,60,opt,name=site_count,proto3" json:"site_count,omitempty"`
	StreamCount   int32   `protobuf:"varint,61,opt,name=stream_count,proto3" json:"stream_count,omitempty"`
	ChannelCount  int32   `protobuf:"varint,62,opt,name=channel_count,proto3" json:"channel_count,omitempty"`
	EmbedCount    int32   `protobuf:"varint,63,opt,name=embed_count,proto3" json:"embed_count,omitempty"`
	UniqueIpCount int32   `protobuf:"varint,64,opt,name=unique_ip_count,proto3" json:"unique_ip_count,omitempty"`
	EmbedRatio    float64 `protobuf:"fixed64,65,opt,name=embed_ratio,proto3" json:"embed_ratio,omitempty"`
	// these fields are maybe used or maybe not. their meaning is unclear. use
	// only with great caution
	SdkVersion           string   `protobuf:"bytes,70,opt,name=sdk_version,proto3" json:"sdk_version,omitempty"`
	Unfindable           bool     `protobuf:"varint,71,opt,name=unfindable,proto3" json:"unfindable,omitempty"`
	Killed               bool     `protobuf:"varint,72,opt,name=killed,proto3" json:"killed,omitempty"`
	DirectoryHidden      bool     `protobuf:"varint,73,opt,name=directory_hidden,proto3" json:"directory_hidden,omitempty"`
	ClientId             string   `protobuf:"bytes,74,opt,name=client_id,proto3" json:"client_id,omitempty"`
	Flows                string   `protobuf:"bytes,75,opt,name=flows,proto3" json:"flows,omitempty"`
	EmbedEnabled         bool     `protobuf:"varint,76,opt,name=embed_enabled,proto3" json:"embed_enabled,omitempty"`
	Recorder             int64    `protobuf:"varint,77,opt,name=recorder,proto3" json:"recorder,omitempty"`
	OriginOnly           bool     `protobuf:"varint,78,opt,name=origin_only,proto3" json:"origin_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Stream) Reset()         { *m = Stream{} }
func (m *Stream) String() string { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()    {}
func (*Stream) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{0}
}
func (m *Stream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Stream.Unmarshal(m, b)
}
func (m *Stream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Stream.Marshal(b, m, deterministic)
}
func (dst *Stream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream.Merge(dst, src)
}
func (m *Stream) XXX_Size() int {
	return xxx_messageInfo_Stream.Size(m)
}
func (m *Stream) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream.DiscardUnknown(m)
}

var xxx_messageInfo_Stream proto.InternalMessageInfo

func (m *Stream) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Stream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Stream) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *Stream) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Stream) GetStartTimeAnsic() string {
	if m != nil {
		return m.StartTimeAnsic
	}
	return ""
}

func (m *Stream) GetUpdateTimeAnsic() string {
	if m != nil {
		return m.UpdateTimeAnsic
	}
	return ""
}

func (m *Stream) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *Stream) GetBroadcaster() string {
	if m != nil {
		return m.Broadcaster
	}
	return ""
}

func (m *Stream) GetBroadcastTag() string {
	if m != nil {
		return m.BroadcastTag
	}
	return ""
}

func (m *Stream) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *Stream) GetAudioCodec() string {
	if m != nil {
		return m.AudioCodec
	}
	return ""
}

func (m *Stream) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Stream) GetStreamType() string {
	if m != nil {
		return m.StreamType
	}
	return ""
}

func (m *Stream) GetOriginName() string {
	if m != nil {
		return m.OriginName
	}
	return ""
}

func (m *Stream) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Stream) GetStarved() bool {
	if m != nil {
		return m.Starved
	}
	return false
}

func (m *Stream) GetConnect() string {
	if m != nil {
		return m.Connect
	}
	return ""
}

func (m *Stream) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *Stream) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

// Deprecated: Do not use.
func (m *Stream) GetTwitchContent() bool {
	if m != nil {
		return m.TwitchContent
	}
	return false
}

func (m *Stream) GetSiteCount() int32 {
	if m != nil {
		return m.SiteCount
	}
	return 0
}

func (m *Stream) GetStreamCount() int32 {
	if m != nil {
		return m.StreamCount
	}
	return 0
}

func (m *Stream) GetChannelCount() int32 {
	if m != nil {
		return m.ChannelCount
	}
	return 0
}

func (m *Stream) GetEmbedCount() int32 {
	if m != nil {
		return m.EmbedCount
	}
	return 0
}

func (m *Stream) GetUniqueIpCount() int32 {
	if m != nil {
		return m.UniqueIpCount
	}
	return 0
}

func (m *Stream) GetEmbedRatio() float64 {
	if m != nil {
		return m.EmbedRatio
	}
	return 0
}

func (m *Stream) GetSdkVersion() string {
	if m != nil {
		return m.SdkVersion
	}
	return ""
}

func (m *Stream) GetUnfindable() bool {
	if m != nil {
		return m.Unfindable
	}
	return false
}

func (m *Stream) GetKilled() bool {
	if m != nil {
		return m.Killed
	}
	return false
}

func (m *Stream) GetDirectoryHidden() bool {
	if m != nil {
		return m.DirectoryHidden
	}
	return false
}

func (m *Stream) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *Stream) GetFlows() string {
	if m != nil {
		return m.Flows
	}
	return ""
}

func (m *Stream) GetEmbedEnabled() bool {
	if m != nil {
		return m.EmbedEnabled
	}
	return false
}

func (m *Stream) GetRecorder() int64 {
	if m != nil {
		return m.Recorder
	}
	return 0
}

func (m *Stream) GetOriginOnly() bool {
	if m != nil {
		return m.OriginOnly
	}
	return false
}

type StreamMinuteBroadcastsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamMinuteBroadcastsRequest) Reset()         { *m = StreamMinuteBroadcastsRequest{} }
func (m *StreamMinuteBroadcastsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamMinuteBroadcastsRequest) ProtoMessage()    {}
func (*StreamMinuteBroadcastsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{1}
}
func (m *StreamMinuteBroadcastsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Unmarshal(m, b)
}
func (m *StreamMinuteBroadcastsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamMinuteBroadcastsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamMinuteBroadcastsRequest.Merge(dst, src)
}
func (m *StreamMinuteBroadcastsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Size(m)
}
func (m *StreamMinuteBroadcastsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamMinuteBroadcastsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamMinuteBroadcastsRequest proto.InternalMessageInfo

type ListOf_StreamMinuteBroadcastsResponse struct {
	StreamMinuteBroadcasts []*StreamMinuteBroadcast `protobuf:"bytes,1,rep,name=stream_minute_broadcasts,json=streamMinuteBroadcasts,proto3" json:"stream_minute_broadcasts,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                 `json:"-"`
	XXX_unrecognized       []byte                   `json:"-"`
	XXX_sizecache          int32                    `json:"-"`
}

func (m *ListOf_StreamMinuteBroadcastsResponse) Reset()         { *m = ListOf_StreamMinuteBroadcastsResponse{} }
func (m *ListOf_StreamMinuteBroadcastsResponse) String() string { return proto.CompactTextString(m) }
func (*ListOf_StreamMinuteBroadcastsResponse) ProtoMessage()    {}
func (*ListOf_StreamMinuteBroadcastsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{2}
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Unmarshal(m, b)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Marshal(b, m, deterministic)
}
func (dst *ListOf_StreamMinuteBroadcastsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Merge(dst, src)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Size() int {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Size(m)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse proto.InternalMessageInfo

func (m *ListOf_StreamMinuteBroadcastsResponse) GetStreamMinuteBroadcasts() []*StreamMinuteBroadcast {
	if m != nil {
		return m.StreamMinuteBroadcasts
	}
	return nil
}

// StreamMinuteBroadcast has some legacy fields omitted which are in practice
// always null and omitted anyways by usher itself
type StreamMinuteBroadcast struct {
	Channel              string   `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	ChannelId            int64    `protobuf:"varint,2,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	MinutesBroadcast     float64  `protobuf:"fixed64,3,opt,name=minutes_broadcast,proto3" json:"minutes_broadcast,omitempty"`
	Partner              bool     `protobuf:"varint,5,opt,name=partner,proto3" json:"partner,omitempty"`
	DirectoryHidden      bool     `protobuf:"varint,6,opt,name=directory_hidden,proto3" json:"directory_hidden,omitempty"`
	EmbedEnabled         bool     `protobuf:"varint,7,opt,name=embed_enabled,proto3" json:"embed_enabled,omitempty"`
	Platform             string   `protobuf:"bytes,8,opt,name=platform,proto3" json:"platform,omitempty"`
	BroadcasterSoftware  string   `protobuf:"bytes,9,opt,name=broadcaster_software,proto3" json:"broadcaster_software,omitempty"`
	SdkVersion           string   `protobuf:"bytes,10,opt,name=sdk_version,proto3" json:"sdk_version,omitempty"`
	ClientId             string   `protobuf:"bytes,11,opt,name=client_id,proto3" json:"client_id,omitempty"`
	VideoEncoder         string   `protobuf:"bytes,12,opt,name=video_encoder,proto3" json:"video_encoder,omitempty"`
	Os                   string   `protobuf:"bytes,13,opt,name=os,proto3" json:"os,omitempty"`
	Starved              bool     `protobuf:"varint,14,opt,name=starved,proto3" json:"starved,omitempty"`
	VideoBitrate         float64  `protobuf:"fixed64,15,opt,name=video_bitrate,proto3" json:"video_bitrate,omitempty"`
	VideoCodec           string   `protobuf:"bytes,16,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	AudioCodec           string   `protobuf:"bytes,17,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	Resolution           string   `protobuf:"bytes,18,opt,name=resolution,proto3" json:"resolution,omitempty"`
	Pixels               int32    `protobuf:"varint,19,opt,name=pixels,proto3" json:"pixels,omitempty"`
	DetailedVideoCodec   string   `protobuf:"bytes,20,opt,name=detailed_video_codec,proto3" json:"detailed_video_codec,omitempty"`
	DetailedAudioCodec   string   `protobuf:"bytes,21,opt,name=detailed_audio_codec,proto3" json:"detailed_audio_codec,omitempty"`
	SampleRate           float64  `protobuf:"fixed64,22,opt,name=sample_rate,proto3" json:"sample_rate,omitempty"`
	MaxIdrDelta          float64  `protobuf:"fixed64,23,opt,name=max_idr_delta,proto3" json:"max_idr_delta,omitempty"`
	TranscoderType       string   `protobuf:"bytes,24,opt,name=transcoder_type,proto3" json:"transcoder_type,omitempty"`
	SessionId            string   `protobuf:"bytes,25,opt,name=session_id,proto3" json:"session_id,omitempty"`
	BroadcastId          int64    `protobuf:"varint,26,opt,name=broadcast_id,proto3" json:"broadcast_id,omitempty"`
	CustomerId           string   `protobuf:"bytes,27,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	ContentId            string   `protobuf:"bytes,28,opt,name=content_id,proto3" json:"content_id,omitempty"`
	LatencyMode          string   `protobuf:"bytes,29,opt,name=latency_mode,proto3" json:"latency_mode,omitempty"`
	EncodeType           string   `protobuf:"bytes,30,opt,name=encode_type,proto3" json:"encode_type,omitempty"`
	JobType              string   `protobuf:"bytes,31,opt,name=job_type,proto3" json:"job_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamMinuteBroadcast) Reset()         { *m = StreamMinuteBroadcast{} }
func (m *StreamMinuteBroadcast) String() string { return proto.CompactTextString(m) }
func (*StreamMinuteBroadcast) ProtoMessage()    {}
func (*StreamMinuteBroadcast) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{3}
}
func (m *StreamMinuteBroadcast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamMinuteBroadcast.Unmarshal(m, b)
}
func (m *StreamMinuteBroadcast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamMinuteBroadcast.Marshal(b, m, deterministic)
}
func (dst *StreamMinuteBroadcast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamMinuteBroadcast.Merge(dst, src)
}
func (m *StreamMinuteBroadcast) XXX_Size() int {
	return xxx_messageInfo_StreamMinuteBroadcast.Size(m)
}
func (m *StreamMinuteBroadcast) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamMinuteBroadcast.DiscardUnknown(m)
}

var xxx_messageInfo_StreamMinuteBroadcast proto.InternalMessageInfo

func (m *StreamMinuteBroadcast) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetMinutesBroadcast() float64 {
	if m != nil {
		return m.MinutesBroadcast
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetPartner() bool {
	if m != nil {
		return m.Partner
	}
	return false
}

func (m *StreamMinuteBroadcast) GetDirectoryHidden() bool {
	if m != nil {
		return m.DirectoryHidden
	}
	return false
}

func (m *StreamMinuteBroadcast) GetEmbedEnabled() bool {
	if m != nil {
		return m.EmbedEnabled
	}
	return false
}

func (m *StreamMinuteBroadcast) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetBroadcasterSoftware() string {
	if m != nil {
		return m.BroadcasterSoftware
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSdkVersion() string {
	if m != nil {
		return m.SdkVersion
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetVideoEncoder() string {
	if m != nil {
		return m.VideoEncoder
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetOs() string {
	if m != nil {
		return m.Os
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetStarved() bool {
	if m != nil {
		return m.Starved
	}
	return false
}

func (m *StreamMinuteBroadcast) GetVideoBitrate() float64 {
	if m != nil {
		return m.VideoBitrate
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetAudioCodec() string {
	if m != nil {
		return m.AudioCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetResolution() string {
	if m != nil {
		return m.Resolution
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetPixels() int32 {
	if m != nil {
		return m.Pixels
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetDetailedVideoCodec() string {
	if m != nil {
		return m.DetailedVideoCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetDetailedAudioCodec() string {
	if m != nil {
		return m.DetailedAudioCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSampleRate() float64 {
	if m != nil {
		return m.SampleRate
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetMaxIdrDelta() float64 {
	if m != nil {
		return m.MaxIdrDelta
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetTranscoderType() string {
	if m != nil {
		return m.TranscoderType
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSessionId() string {
	if m != nil {
		return m.SessionId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetBroadcastId() int64 {
	if m != nil {
		return m.BroadcastId
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetLatencyMode() string {
	if m != nil {
		return m.LatencyMode
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetEncodeType() string {
	if m != nil {
		return m.EncodeType
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetJobType() string {
	if m != nil {
		return m.JobType
	}
	return ""
}

type StreamListRequest struct {
	// limit sets a limit to the number of streams returned in the stream list
	Limit int32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// channel queries for all streams entries for this given channel
	Channel              string   `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamListRequest) Reset()         { *m = StreamListRequest{} }
func (m *StreamListRequest) String() string { return proto.CompactTextString(m) }
func (*StreamListRequest) ProtoMessage()    {}
func (*StreamListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{4}
}
func (m *StreamListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamListRequest.Unmarshal(m, b)
}
func (m *StreamListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamListRequest.Marshal(b, m, deterministic)
}
func (dst *StreamListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamListRequest.Merge(dst, src)
}
func (m *StreamListRequest) XXX_Size() int {
	return xxx_messageInfo_StreamListRequest.Size(m)
}
func (m *StreamListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamListRequest proto.InternalMessageInfo

func (m *StreamListRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *StreamListRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type ListOf_Streams struct {
	Streams              []*Stream `protobuf:"bytes,1,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ListOf_Streams) Reset()         { *m = ListOf_Streams{} }
func (m *ListOf_Streams) String() string { return proto.CompactTextString(m) }
func (*ListOf_Streams) ProtoMessage()    {}
func (*ListOf_Streams) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{5}
}
func (m *ListOf_Streams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_Streams.Unmarshal(m, b)
}
func (m *ListOf_Streams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_Streams.Marshal(b, m, deterministic)
}
func (dst *ListOf_Streams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_Streams.Merge(dst, src)
}
func (m *ListOf_Streams) XXX_Size() int {
	return xxx_messageInfo_ListOf_Streams.Size(m)
}
func (m *ListOf_Streams) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_Streams.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_Streams proto.InternalMessageInfo

func (m *ListOf_Streams) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type StreamShowRequest struct {
	StreamId             int64    `protobuf:"varint,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamShowRequest) Reset()         { *m = StreamShowRequest{} }
func (m *StreamShowRequest) String() string { return proto.CompactTextString(m) }
func (*StreamShowRequest) ProtoMessage()    {}
func (*StreamShowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{6}
}
func (m *StreamShowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamShowRequest.Unmarshal(m, b)
}
func (m *StreamShowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamShowRequest.Marshal(b, m, deterministic)
}
func (dst *StreamShowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamShowRequest.Merge(dst, src)
}
func (m *StreamShowRequest) XXX_Size() int {
	return xxx_messageInfo_StreamShowRequest.Size(m)
}
func (m *StreamShowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamShowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamShowRequest proto.InternalMessageInfo

func (m *StreamShowRequest) GetStreamId() int64 {
	if m != nil {
		return m.StreamId
	}
	return 0
}

type StreamBulkUpdateRequest struct {
	Updates              []*StreamUpdate `protobuf:"bytes,1,rep,name=updates,proto3" json:"updates,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StreamBulkUpdateRequest) Reset()         { *m = StreamBulkUpdateRequest{} }
func (m *StreamBulkUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*StreamBulkUpdateRequest) ProtoMessage()    {}
func (*StreamBulkUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{7}
}
func (m *StreamBulkUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamBulkUpdateRequest.Unmarshal(m, b)
}
func (m *StreamBulkUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamBulkUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *StreamBulkUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamBulkUpdateRequest.Merge(dst, src)
}
func (m *StreamBulkUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_StreamBulkUpdateRequest.Size(m)
}
func (m *StreamBulkUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamBulkUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamBulkUpdateRequest proto.InternalMessageInfo

func (m *StreamBulkUpdateRequest) GetUpdates() []*StreamUpdate {
	if m != nil {
		return m.Updates
	}
	return nil
}

type StreamUpdate struct {
	// the id of the stream to update
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// the number of unique viewers by ip address
	UniqueIpCount        *wrappers.Int32Value `protobuf:"bytes,2,opt,name=unique_ip_count,proto3" json:"unique_ip_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StreamUpdate) Reset()         { *m = StreamUpdate{} }
func (m *StreamUpdate) String() string { return proto.CompactTextString(m) }
func (*StreamUpdate) ProtoMessage()    {}
func (*StreamUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{8}
}
func (m *StreamUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamUpdate.Unmarshal(m, b)
}
func (m *StreamUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamUpdate.Marshal(b, m, deterministic)
}
func (dst *StreamUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamUpdate.Merge(dst, src)
}
func (m *StreamUpdate) XXX_Size() int {
	return xxx_messageInfo_StreamUpdate.Size(m)
}
func (m *StreamUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_StreamUpdate proto.InternalMessageInfo

func (m *StreamUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StreamUpdate) GetUniqueIpCount() *wrappers.Int32Value {
	if m != nil {
		return m.UniqueIpCount
	}
	return nil
}

type StreamChannelMappingsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamChannelMappingsRequest) Reset()         { *m = StreamChannelMappingsRequest{} }
func (m *StreamChannelMappingsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamChannelMappingsRequest) ProtoMessage()    {}
func (*StreamChannelMappingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{9}
}
func (m *StreamChannelMappingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamChannelMappingsRequest.Unmarshal(m, b)
}
func (m *StreamChannelMappingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamChannelMappingsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamChannelMappingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamChannelMappingsRequest.Merge(dst, src)
}
func (m *StreamChannelMappingsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamChannelMappingsRequest.Size(m)
}
func (m *StreamChannelMappingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamChannelMappingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamChannelMappingsRequest proto.InternalMessageInfo

type ListOf_ChannelMappings struct {
	Mappings             []*ChannelMapping `protobuf:"bytes,1,rep,name=mappings,proto3" json:"mappings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListOf_ChannelMappings) Reset()         { *m = ListOf_ChannelMappings{} }
func (m *ListOf_ChannelMappings) String() string { return proto.CompactTextString(m) }
func (*ListOf_ChannelMappings) ProtoMessage()    {}
func (*ListOf_ChannelMappings) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{10}
}
func (m *ListOf_ChannelMappings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_ChannelMappings.Unmarshal(m, b)
}
func (m *ListOf_ChannelMappings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_ChannelMappings.Marshal(b, m, deterministic)
}
func (dst *ListOf_ChannelMappings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_ChannelMappings.Merge(dst, src)
}
func (m *ListOf_ChannelMappings) XXX_Size() int {
	return xxx_messageInfo_ListOf_ChannelMappings.Size(m)
}
func (m *ListOf_ChannelMappings) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_ChannelMappings.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_ChannelMappings proto.InternalMessageInfo

func (m *ListOf_ChannelMappings) GetMappings() []*ChannelMapping {
	if m != nil {
		return m.Mappings
	}
	return nil
}

type ChannelMapping struct {
	// the id of the stream
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// the id of the channel the stream is being broadcast on.
	// for non-twitch streams, this value is not used.
	ChannelId int64 `protobuf:"varint,2,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	// the id of the content of the stream. for twitch streams,
	// this value is the same as channel_id. for non-twitch streams,
	// this is a user-specified string (example: "twitchmedia_lvs_staging")
	ContentId string `protobuf:"bytes,3,opt,name=content_id,json=content,proto3" json:"content_id,omitempty"`
	// the id of the customer whose platform the stream belongs to.
	// for twitch streams, this is set to "twitch". LVS customers have their own
	// identifiers (example: "twitch-lowlatency-darklaunch").
	CustomerId string `protobuf:"bytes,4,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	// channel indicates where the stream is being broadcast. for twitch streams,
	// this is the name of the user's channel (example: "monstercat"). for LVS customers,
	// this value is a combination of the content and customer_id (example: "lvs.twitch-lowlatency-darklaunch.145090292").
	Channel              string   `protobuf:"bytes,5,opt,name=channel,proto3" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelMapping) Reset()         { *m = ChannelMapping{} }
func (m *ChannelMapping) String() string { return proto.CompactTextString(m) }
func (*ChannelMapping) ProtoMessage()    {}
func (*ChannelMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_7e5ae10c982329a7, []int{11}
}
func (m *ChannelMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelMapping.Unmarshal(m, b)
}
func (m *ChannelMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelMapping.Marshal(b, m, deterministic)
}
func (dst *ChannelMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelMapping.Merge(dst, src)
}
func (m *ChannelMapping) XXX_Size() int {
	return xxx_messageInfo_ChannelMapping.Size(m)
}
func (m *ChannelMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelMapping.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelMapping proto.InternalMessageInfo

func (m *ChannelMapping) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ChannelMapping) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *ChannelMapping) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *ChannelMapping) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ChannelMapping) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func init() {
	proto.RegisterType((*Stream)(nil), "twitch.video.usher.Stream")
	proto.RegisterType((*StreamMinuteBroadcastsRequest)(nil), "twitch.video.usher.StreamMinuteBroadcastsRequest")
	proto.RegisterType((*ListOf_StreamMinuteBroadcastsResponse)(nil), "twitch.video.usher.ListOf_StreamMinuteBroadcastsResponse")
	proto.RegisterType((*StreamMinuteBroadcast)(nil), "twitch.video.usher.StreamMinuteBroadcast")
	proto.RegisterType((*StreamListRequest)(nil), "twitch.video.usher.StreamListRequest")
	proto.RegisterType((*ListOf_Streams)(nil), "twitch.video.usher.ListOf_Streams")
	proto.RegisterType((*StreamShowRequest)(nil), "twitch.video.usher.StreamShowRequest")
	proto.RegisterType((*StreamBulkUpdateRequest)(nil), "twitch.video.usher.StreamBulkUpdateRequest")
	proto.RegisterType((*StreamUpdate)(nil), "twitch.video.usher.StreamUpdate")
	proto.RegisterType((*StreamChannelMappingsRequest)(nil), "twitch.video.usher.StreamChannelMappingsRequest")
	proto.RegisterType((*ListOf_ChannelMappings)(nil), "twitch.video.usher.ListOf_ChannelMappings")
	proto.RegisterType((*ChannelMapping)(nil), "twitch.video.usher.ChannelMapping")
}

func init() {
	proto.RegisterFile("code.justin.tv/video/usherapi/rpc/usher/stream.proto", fileDescriptor_stream_7e5ae10c982329a7)
}

var fileDescriptor_stream_7e5ae10c982329a7 = []byte{
	// 1219 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x57, 0xe1, 0x6e, 0x14, 0xb7,
	0x13, 0xd7, 0x5e, 0x48, 0xb8, 0x38, 0x21, 0x90, 0xfd, 0x43, 0xf0, 0x3f, 0x09, 0xe1, 0xba, 0x02,
	0xf5, 0x40, 0xd5, 0xa5, 0x0a, 0x7c, 0xaa, 0x5a, 0xda, 0x06, 0x95, 0x96, 0x16, 0x5a, 0x69, 0x11,
	0x55, 0xd5, 0x2f, 0x2b, 0xdf, 0x7a, 0x2e, 0x31, 0xec, 0xd9, 0x8b, 0xed, 0x4d, 0xc8, 0x3b, 0xf4,
	0x05, 0xfa, 0x14, 0x7d, 0x9f, 0x3e, 0x4d, 0xe5, 0xf1, 0xee, 0x9d, 0xf7, 0xf6, 0xd2, 0xf4, 0xdb,
	0xcd, 0x6f, 0x7e, 0xe3, 0xb5, 0x67, 0xc6, 0xbf, 0xf1, 0x91, 0xa7, 0xb9, 0xe2, 0x30, 0x7a, 0x57,
	0x19, 0x2b, 0xe4, 0xc8, 0x9e, 0x1d, 0x9e, 0x09, 0x0e, 0xea, 0xb0, 0x32, 0xa7, 0xa0, 0x59, 0x29,
	0x0e, 0x75, 0x99, 0x7b, 0xe3, 0xd0, 0x58, 0x0d, 0x6c, 0x3a, 0x2a, 0xb5, 0xb2, 0x2a, 0x8e, 0xed,
	0xb9, 0xb0, 0xf9, 0xe9, 0x08, 0xd9, 0x23, 0x24, 0xec, 0x1e, 0x9c, 0x28, 0x75, 0x52, 0xc0, 0x21,
	0x32, 0xc6, 0xd5, 0xe4, 0xf0, 0x5c, 0xb3, 0xb2, 0x04, 0x6d, 0x7c, 0x4c, 0xf2, 0x77, 0x9f, 0xac,
	0xbd, 0xc1, 0x45, 0xe2, 0x2d, 0xd2, 0x13, 0x9c, 0x46, 0x83, 0x68, 0xb8, 0x92, 0xf6, 0x04, 0x8f,
	0x63, 0x72, 0x4d, 0xb2, 0x29, 0xd0, 0xde, 0x20, 0x1a, 0xae, 0xa7, 0xf8, 0x3b, 0xa6, 0xe4, 0x7a,
	0x7e, 0xca, 0xa4, 0x84, 0x82, 0xae, 0x20, 0xdc, 0x98, 0xf1, 0x01, 0x21, 0xf5, 0xcf, 0x4c, 0x70,
	0x7a, 0x0d, 0x57, 0x09, 0x90, 0xf8, 0x13, 0x72, 0xcb, 0x58, 0xa6, 0x6d, 0x66, 0xc5, 0x14, 0x32,
	0x26, 0x8d, 0xc8, 0xe9, 0x86, 0x5f, 0xa2, 0x2a, 0x11, 0x8c, 0x1f, 0x92, 0xed, 0xaa, 0xe4, 0xcc,
	0x42, 0xc8, 0xd9, 0x44, 0x0e, 0xf1, 0x0e, 0x9e, 0x29, 0x19, 0xef, 0x90, 0xb5, 0x89, 0xd2, 0x53,
	0x66, 0xe9, 0x1d, 0xf4, 0xd5, 0x56, 0x3c, 0x20, 0x1b, 0x63, 0xad, 0x18, 0xcf, 0x99, 0xb1, 0xa0,
	0xe9, 0x0e, 0x3a, 0x43, 0x28, 0x7e, 0x40, 0x6e, 0xcc, 0xcc, 0xcc, 0xb2, 0x13, 0x7a, 0x17, 0x39,
	0x6d, 0xd0, 0xad, 0x83, 0x19, 0xcc, 0x5c, 0x11, 0x72, 0x4a, 0xfd, 0x3a, 0x01, 0xe4, 0x18, 0xac,
	0xe2, 0xa2, 0x61, 0xfc, 0xdf, 0x33, 0x02, 0xc8, 0xe5, 0xce, 0x5e, 0x94, 0x40, 0x77, 0x7d, 0xee,
	0xdc, 0x6f, 0x17, 0xe5, 0xcb, 0x95, 0xa1, 0x6b, 0xcf, 0x47, 0x05, 0x90, 0x63, 0x28, 0x2d, 0x4e,
	0x84, 0xcc, 0x30, 0xf1, 0xfb, 0x9e, 0x11, 0x40, 0xf1, 0x6d, 0xb2, 0xaa, 0x81, 0xf1, 0x0b, 0x3a,
	0x1c, 0x44, 0xc3, 0x7e, 0xea, 0x0d, 0x57, 0x15, 0x97, 0xdb, 0x33, 0xe0, 0xf4, 0x11, 0xe2, 0x8d,
	0x89, 0xf5, 0x52, 0x52, 0x42, 0x6e, 0xe9, 0xe3, 0xba, 0x5e, 0xde, 0x74, 0xdf, 0xca, 0x2b, 0x63,
	0xd5, 0x14, 0xb4, 0x2b, 0xd8, 0x91, 0xff, 0x56, 0x00, 0x61, 0x45, 0x95, 0xb4, 0x20, 0xad, 0x23,
	0x3c, 0xf1, 0x75, 0x98, 0x23, 0xf1, 0x63, 0xb2, 0xe5, 0x1b, 0x2e, 0xab, 0x41, 0xfa, 0xd4, 0x7d,
	0xfc, 0xb8, 0x47, 0xa3, 0x74, 0xc1, 0xe3, 0xd6, 0x32, 0xc2, 0x42, 0x96, 0xab, 0x4a, 0x5a, 0xfa,
	0xe5, 0x20, 0x1a, 0xae, 0xa6, 0x01, 0x12, 0x27, 0x64, 0xb3, 0x4e, 0x84, 0x67, 0x7c, 0x85, 0x8c,
	0x16, 0xe6, 0xaa, 0xd7, 0xf4, 0x93, 0x27, 0x3d, 0x43, 0x52, 0x1b, 0x74, 0xe7, 0x82, 0xe9, 0x18,
	0x78, 0xcd, 0xf9, 0x1a, 0x39, 0x21, 0x14, 0x0f, 0xc9, 0xcd, 0x4a, 0x8a, 0x0f, 0x15, 0x64, 0xa2,
	0xac, 0x59, 0xdf, 0x20, 0x6b, 0x11, 0x9e, 0xaf, 0xa5, 0x99, 0x15, 0x8a, 0x7e, 0x3b, 0x88, 0x86,
	0x51, 0x1a, 0x42, 0x58, 0x53, 0xfe, 0x3e, 0x3b, 0x03, 0x6d, 0x84, 0x92, 0xf4, 0x45, 0x5d, 0xd3,
	0x39, 0xe4, 0x4e, 0x5e, 0xc9, 0x89, 0x90, 0x9c, 0x8d, 0x0b, 0xa0, 0xdf, 0x63, 0x79, 0x02, 0xc4,
	0x75, 0xf3, 0x7b, 0x51, 0x14, 0xc0, 0xe9, 0x0f, 0xe8, 0xab, 0xad, 0xf8, 0x31, 0xb9, 0xc5, 0x85,
	0x86, 0xdc, 0x2a, 0x7d, 0x91, 0x9d, 0x0a, 0xce, 0x41, 0xd2, 0x97, 0xc8, 0xe8, 0xe0, 0xf1, 0x3e,
	0x59, 0xcf, 0x0b, 0x51, 0x17, 0xea, 0x47, 0xdc, 0xc3, 0x1c, 0x70, 0x3d, 0x33, 0x29, 0xd4, 0xb9,
	0xa1, 0x3f, 0xa1, 0xc7, 0x1b, 0x2e, 0x9b, 0xfe, 0x20, 0x20, 0xdd, 0x3e, 0x38, 0x7d, 0x85, 0x8b,
	0xb7, 0xc1, 0x78, 0x97, 0xf4, 0x35, 0xe4, 0x4a, 0x73, 0xd0, 0xf4, 0x35, 0xde, 0xe9, 0x99, 0x1d,
	0x74, 0xab, 0x92, 0xc5, 0x05, 0xfd, 0x19, 0xe3, 0x43, 0x28, 0xb9, 0x4f, 0xee, 0x79, 0x6d, 0x79,
	0x2d, 0x64, 0x65, 0xe1, 0xb8, 0xb9, 0x66, 0x26, 0x85, 0x0f, 0x15, 0x18, 0x9b, 0xfc, 0x11, 0x91,
	0x87, 0xaf, 0x84, 0xb1, 0xbf, 0x4c, 0xb2, 0xcb, 0x88, 0xa6, 0x54, 0xd2, 0x40, 0x9c, 0x13, 0x5a,
	0x37, 0xc3, 0x14, 0x29, 0xd9, 0xec, 0xce, 0x1a, 0x1a, 0x0d, 0x56, 0x86, 0x1b, 0x47, 0x8f, 0x46,
	0x5d, 0xf9, 0x1b, 0x2d, 0x5d, 0x35, 0xdd, 0x31, 0x4b, 0x3f, 0x96, 0xfc, 0xd5, 0x27, 0x77, 0x96,
	0x46, 0x84, 0xba, 0x17, 0xfd, 0x9b, 0xee, 0xf5, 0x3a, 0xba, 0xf7, 0x19, 0xd9, 0xf6, 0x3b, 0x36,
	0xf3, 0x2d, 0xa3, 0x76, 0x46, 0x69, 0xd7, 0xe1, 0xbe, 0x53, 0x32, 0x6d, 0x25, 0x68, 0xba, 0xea,
	0x6f, 0x72, 0x6d, 0x2e, 0xed, 0x87, 0xb5, 0x4b, 0xfa, 0xa1, 0x53, 0xdb, 0xeb, 0x97, 0xd4, 0xb6,
	0x2c, 0x98, 0x75, 0xea, 0x49, 0xfb, 0x78, 0xa8, 0x99, 0x1d, 0x1f, 0x91, 0xdb, 0x81, 0x70, 0x66,
	0x46, 0x4d, 0xec, 0x39, 0xd3, 0x40, 0xd7, 0x91, 0xb7, 0xd4, 0xb7, 0x78, 0x17, 0x48, 0xf7, 0x2e,
	0xb4, 0xfa, 0x74, 0x63, 0xb1, 0x4f, 0x1f, 0x90, 0x1b, 0x5e, 0x64, 0x41, 0x3a, 0x11, 0xd5, 0xb5,
	0xf4, 0xb7, 0x41, 0x37, 0xa5, 0x94, 0xa1, 0x37, 0xd0, 0xd5, 0x53, 0x26, 0xd4, 0xbe, 0xad, 0xb6,
	0xf6, 0xcd, 0xd6, 0x1b, 0x0b, 0xab, 0x99, 0x05, 0x7a, 0x13, 0xb3, 0xde, 0x06, 0x17, 0xd5, 0xfe,
	0xd6, 0x95, 0x6a, 0xbf, 0xdd, 0x55, 0xfb, 0x03, 0x42, 0x34, 0x18, 0x55, 0x54, 0xd6, 0x1d, 0x3c,
	0xf6, 0x4a, 0x39, 0x47, 0xdc, 0x1d, 0x2f, 0xc5, 0x47, 0x28, 0x0c, 0xfd, 0x1f, 0x0a, 0x4d, 0x6d,
	0xb9, 0x2c, 0x73, 0xb0, 0x4c, 0x14, 0xc0, 0xb3, 0x70, 0x13, 0xb7, 0x7d, 0x96, 0x97, 0xf9, 0x5a,
	0x31, 0xe1, 0xb6, 0xee, 0x2c, 0xc4, 0x84, 0xfb, 0x73, 0x95, 0x61, 0xd3, 0xb2, 0x80, 0x0c, 0xf3,
	0xb0, 0xe3, 0x75, 0x2c, 0x80, 0x5c, 0xae, 0xa6, 0xec, 0x63, 0x26, 0xb8, 0xce, 0x38, 0x14, 0x96,
	0xe1, 0x64, 0x8c, 0xd2, 0x36, 0xe8, 0x94, 0xd3, 0x6a, 0x26, 0x0d, 0x56, 0xc2, 0x4f, 0x31, 0x3f,
	0x1d, 0x17, 0x61, 0xd4, 0x7b, 0x30, 0xae, 0xe8, 0xae, 0xd4, 0x7e, 0x40, 0x06, 0x88, 0xd3, 0xfb,
	0xf9, 0xd0, 0x15, 0x1c, 0xe7, 0xe4, 0x4a, 0xda, 0xc2, 0x16, 0x27, 0xd4, 0xde, 0x55, 0x13, 0x6a,
	0xbf, 0x33, 0xa1, 0x12, 0xb2, 0x59, 0x30, 0x0b, 0x32, 0xbf, 0xc8, 0xa6, 0x8a, 0x03, 0xbd, 0x87,
	0x8c, 0x16, 0x86, 0x1a, 0x8f, 0xad, 0xe5, 0xcf, 0x73, 0xe0, 0xbf, 0x12, 0x40, 0xee, 0x9e, 0xbc,
	0x53, 0x63, 0xef, 0xbe, 0xef, 0xef, 0x49, 0x63, 0x27, 0xcf, 0xc9, 0xb6, 0x17, 0x0c, 0xa7, 0x62,
	0xb5, 0xaa, 0x39, 0xc1, 0x2d, 0xc4, 0x54, 0x58, 0x94, 0x8a, 0xd5, 0xd4, 0x1b, 0xa1, 0x84, 0xf4,
	0x5a, 0x12, 0x92, 0xbc, 0x20, 0x5b, 0x2d, 0x11, 0x34, 0xf1, 0x53, 0xd7, 0xd4, 0xf8, 0xb3, 0x16,
	0xb7, 0xdd, 0xcb, 0xc5, 0x2d, 0x6d, 0xa8, 0xc9, 0xe7, 0xcd, 0x66, 0xde, 0x9c, 0xaa, 0xf3, 0x66,
	0x33, 0x7b, 0x64, 0xbd, 0x16, 0xce, 0xd9, 0xe3, 0xae, 0xef, 0x81, 0x97, 0x3c, 0x79, 0x4b, 0xee,
	0xfa, 0x88, 0xe3, 0xaa, 0x78, 0xff, 0x16, 0x9f, 0x58, 0x4d, 0xdc, 0x17, 0xe4, 0xba, 0x7f, 0x73,
	0x35, 0x5b, 0x18, 0x5c, 0xbe, 0x85, 0x3a, 0xb2, 0x09, 0x48, 0x80, 0x6c, 0x86, 0x8e, 0xe0, 0x65,
	0xb9, 0x8e, 0x2f, 0xcb, 0xef, 0xba, 0x13, 0xd8, 0xa5, 0x64, 0xe3, 0x68, 0x6f, 0xe4, 0x9f, 0xab,
	0xa3, 0xe6, 0xb9, 0x3a, 0x7a, 0x29, 0xed, 0x93, 0xa3, 0x5f, 0x59, 0x51, 0x41, 0x67, 0x3c, 0x27,
	0x07, 0x64, 0xdf, 0x7f, 0xe6, 0xb9, 0x4f, 0xe4, 0x6b, 0x56, 0x96, 0x42, 0x9e, 0xcc, 0xa6, 0xcb,
	0x6f, 0x64, 0xa7, 0xce, 0xeb, 0x02, 0x21, 0x7e, 0x46, 0xfa, 0xd3, 0xfa, 0x77, 0x7d, 0xba, 0x64,
	0xd9, 0xe9, 0xda, 0x61, 0xe9, 0x2c, 0x26, 0xf9, 0x33, 0x22, 0x5b, 0x6d, 0x67, 0xe7, 0xf5, 0x7c,
	0xd5, 0x5c, 0xd8, 0x6b, 0xf5, 0xee, 0xca, 0xec, 0x71, 0x86, 0xcf, 0xa5, 0x85, 0xd6, 0xbf, 0xd6,
	0x6d, 0xfd, 0xa0, 0x9b, 0x56, 0x5b, 0xdd, 0x74, 0xfc, 0xe8, 0xf7, 0x4f, 0xff, 0xe3, 0xbf, 0x87,
	0xf1, 0x1a, 0xa6, 0xf9, 0xc9, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc5, 0x69, 0x74, 0xff, 0x6f,
	0x0c, 0x00, 0x00,
}
