// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/vod/blender/rpc/blender/models.proto

package blender

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/wrappers"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type State int32

const (
	State_UNKNOWN_STATE State = 0
	State_HYPE_IN       State = 1
	State_PLAYING       State = 2
	State_OFFLINE       State = 4
	State_IN_PROGRESS   State = 5
)

var State_name = map[int32]string{
	0: "UNKNOWN_STATE",
	1: "HYPE_IN",
	2: "PLAYING",
	4: "OFFLINE",
	5: "IN_PROGRESS",
}
var State_value = map[string]int32{
	"UNKNOWN_STATE": 0,
	"HYPE_IN":       1,
	"PLAYING":       2,
	"OFFLINE":       4,
	"IN_PROGRESS":   5,
}

func (x State) String() string {
	return proto.EnumName(State_name, int32(x))
}
func (State) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

type CatalogType int32

const (
	CatalogType_UNKNOWN_CATALOG_TYPE CatalogType = 0
	CatalogType_EPISODE              CatalogType = 1
	CatalogType_MOVIE                CatalogType = 2
	CatalogType_SEASON               CatalogType = 3
	CatalogType_SERIES               CatalogType = 4
)

var CatalogType_name = map[int32]string{
	0: "UNKNOWN_CATALOG_TYPE",
	1: "EPISODE",
	2: "MOVIE",
	3: "SEASON",
	4: "SERIES",
}
var CatalogType_value = map[string]int32{
	"UNKNOWN_CATALOG_TYPE": 0,
	"EPISODE":              1,
	"MOVIE":                2,
	"SEASON":               3,
	"SERIES":               4,
}

func (x CatalogType) String() string {
	return proto.EnumName(CatalogType_name, int32(x))
}
func (CatalogType) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

// Tracking data fields to send tracking events like minute broadcast
type WatchPartyTracking struct {
	DeviceId          *google_protobuf.StringValue `protobuf:"bytes,1,opt,name=device_id,json=deviceId" json:"device_id,omitempty"`
	Language          *google_protobuf.StringValue `protobuf:"bytes,2,opt,name=language" json:"language,omitempty"`
	BroadcasterIp     string                       `protobuf:"bytes,3,opt,name=broadcaster_ip,json=broadcasterIp" json:"broadcaster_ip,omitempty"`
	StartEpochSeconds int64                        `protobuf:"varint,4,opt,name=start_epoch_seconds,json=startEpochSeconds" json:"start_epoch_seconds,omitempty"`
}

func (m *WatchPartyTracking) Reset()                    { *m = WatchPartyTracking{} }
func (m *WatchPartyTracking) String() string            { return proto.CompactTextString(m) }
func (*WatchPartyTracking) ProtoMessage()               {}
func (*WatchPartyTracking) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *WatchPartyTracking) GetDeviceId() *google_protobuf.StringValue {
	if m != nil {
		return m.DeviceId
	}
	return nil
}

func (m *WatchPartyTracking) GetLanguage() *google_protobuf.StringValue {
	if m != nil {
		return m.Language
	}
	return nil
}

func (m *WatchPartyTracking) GetBroadcasterIp() string {
	if m != nil {
		return m.BroadcasterIp
	}
	return ""
}

func (m *WatchPartyTracking) GetStartEpochSeconds() int64 {
	if m != nil {
		return m.StartEpochSeconds
	}
	return 0
}

// Watch Party excludes playback info.
type WatchParty struct {
	Id        string              `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId string              `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Gti       string              `protobuf:"bytes,3,opt,name=gti" json:"gti,omitempty"`
	State     State               `protobuf:"varint,4,opt,name=state,enum=blender.State" json:"state,omitempty"`
	Progress  *Progress           `protobuf:"bytes,5,opt,name=progress" json:"progress,omitempty"`
	ViewCount int64               `protobuf:"varint,6,opt,name=view_count,json=viewCount" json:"view_count,omitempty"`
	Login     string              `protobuf:"bytes,7,opt,name=login" json:"login,omitempty"`
	Tracking  *WatchPartyTracking `protobuf:"bytes,8,opt,name=tracking" json:"tracking,omitempty"`
	Title     string              `protobuf:"bytes,9,opt,name=title" json:"title,omitempty"`
}

func (m *WatchParty) Reset()                    { *m = WatchParty{} }
func (m *WatchParty) String() string            { return proto.CompactTextString(m) }
func (*WatchParty) ProtoMessage()               {}
func (*WatchParty) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *WatchParty) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WatchParty) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *WatchParty) GetGti() string {
	if m != nil {
		return m.Gti
	}
	return ""
}

func (m *WatchParty) GetState() State {
	if m != nil {
		return m.State
	}
	return State_UNKNOWN_STATE
}

func (m *WatchParty) GetProgress() *Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *WatchParty) GetViewCount() int64 {
	if m != nil {
		return m.ViewCount
	}
	return 0
}

func (m *WatchParty) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *WatchParty) GetTracking() *WatchPartyTracking {
	if m != nil {
		return m.Tracking
	}
	return nil
}

func (m *WatchParty) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

// Represents how far along the current state is.
type Progress struct {
	Start           *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=start" json:"start,omitempty"`
	DurationSeconds int64                       `protobuf:"varint,2,opt,name=duration_seconds,json=durationSeconds" json:"duration_seconds,omitempty"`
	PositionSeconds int64                       `protobuf:"varint,3,opt,name=position_seconds,json=positionSeconds" json:"position_seconds,omitempty"`
	Percentage      float64                     `protobuf:"fixed64,4,opt,name=percentage" json:"percentage,omitempty"`
}

func (m *Progress) Reset()                    { *m = Progress{} }
func (m *Progress) String() string            { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()               {}
func (*Progress) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *Progress) GetStart() *google_protobuf1.Timestamp {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *Progress) GetDurationSeconds() int64 {
	if m != nil {
		return m.DurationSeconds
	}
	return 0
}

func (m *Progress) GetPositionSeconds() int64 {
	if m != nil {
		return m.PositionSeconds
	}
	return 0
}

func (m *Progress) GetPercentage() float64 {
	if m != nil {
		return m.Percentage
	}
	return 0
}

// Additional metadata present in GetDetailedWatchPartyResponse.
type Decoration struct {
	CatalogItem  *CatalogItem  `protobuf:"bytes,1,opt,name=catalog_item,json=catalogItem" json:"catalog_item,omitempty"`
	PlaybackInfo *PlaybackInfo `protobuf:"bytes,2,opt,name=playback_info,json=playbackInfo" json:"playback_info,omitempty"`
}

func (m *Decoration) Reset()                    { *m = Decoration{} }
func (m *Decoration) String() string            { return proto.CompactTextString(m) }
func (*Decoration) ProtoMessage()               {}
func (*Decoration) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *Decoration) GetCatalogItem() *CatalogItem {
	if m != nil {
		return m.CatalogItem
	}
	return nil
}

func (m *Decoration) GetPlaybackInfo() *PlaybackInfo {
	if m != nil {
		return m.PlaybackInfo
	}
	return nil
}

// PlaybackInfo returned only if the user was authorized.
type PlaybackInfo struct {
	Token              string `protobuf:"bytes,1,opt,name=token" json:"token,omitempty"`
	SdkInitParams      string `protobuf:"bytes,2,opt,name=sdk_init_params,json=sdkInitParams" json:"sdk_init_params,omitempty"`
	DeviceProxyBaseUrl string `protobuf:"bytes,3,opt,name=device_proxy_base_url,json=deviceProxyBaseUrl" json:"device_proxy_base_url,omitempty"`
}

func (m *PlaybackInfo) Reset()                    { *m = PlaybackInfo{} }
func (m *PlaybackInfo) String() string            { return proto.CompactTextString(m) }
func (*PlaybackInfo) ProtoMessage()               {}
func (*PlaybackInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *PlaybackInfo) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *PlaybackInfo) GetSdkInitParams() string {
	if m != nil {
		return m.SdkInitParams
	}
	return ""
}

func (m *PlaybackInfo) GetDeviceProxyBaseUrl() string {
	if m != nil {
		return m.DeviceProxyBaseUrl
	}
	return ""
}

// User required for all Blender service requests.
type User struct {
	// Numerical Twitch id.
	Id          *google_protobuf.StringValue `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	AccessToken *google_protobuf.StringValue `protobuf:"bytes,2,opt,name=access_token,json=accessToken" json:"access_token,omitempty"`
	IpAddress   string                       `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress" json:"ip_address,omitempty"`
	Region      string                       `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// Twitch handle.
	Login    *google_protobuf.StringValue `protobuf:"bytes,5,opt,name=login" json:"login,omitempty"`
	DeviceId *google_protobuf.StringValue `protobuf:"bytes,6,opt,name=device_id,json=deviceId" json:"device_id,omitempty"`
	Language *google_protobuf.StringValue `protobuf:"bytes,7,opt,name=language" json:"language,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{5} }

func (m *User) GetId() *google_protobuf.StringValue {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *User) GetAccessToken() *google_protobuf.StringValue {
	if m != nil {
		return m.AccessToken
	}
	return nil
}

func (m *User) GetIpAddress() string {
	if m != nil {
		return m.IpAddress
	}
	return ""
}

func (m *User) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *User) GetLogin() *google_protobuf.StringValue {
	if m != nil {
		return m.Login
	}
	return nil
}

func (m *User) GetDeviceId() *google_protobuf.StringValue {
	if m != nil {
		return m.DeviceId
	}
	return nil
}

func (m *User) GetLanguage() *google_protobuf.StringValue {
	if m != nil {
		return m.Language
	}
	return nil
}

// A fully decorated GTI, regionalized and per user.
type CatalogItem struct {
	// Global Title Identifier.
	Gti string `protobuf:"bytes,1,opt,name=gti" json:"gti,omitempty"`
	// Tom Clancy's Jack Ryan.
	Title *google_protobuf.StringValue `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// When CIA analyst Jack Ryan stumbles upon a suspicious...
	Summary *google_protobuf.StringValue `protobuf:"bytes,3,opt,name=summary" json:"summary,omitempty"`
	// URL for localized box art.
	BoxArt *google_protobuf.StringValue `protobuf:"bytes,4,opt,name=box_art,json=boxArt" json:"box_art,omitempty"`
	// Publication year, i.e. 2018.
	Year *google_protobuf.Int32Value `protobuf:"bytes,5,opt,name=year" json:"year,omitempty"`
	// TV parental guidelines rating, i.e. TV-MA.
	Rating *google_protobuf.StringValue `protobuf:"bytes,6,opt,name=rating" json:"rating,omitempty"`
	// Rating agency name, i.e. MPAA.
	RatingType *google_protobuf.StringValue `protobuf:"bytes,7,opt,name=rating_type,json=ratingType" json:"rating_type,omitempty"`
	// Prime Video Rating consisting of stars and number of votes.
	PrimeVideoRating *PrimeVideoRating `protobuf:"bytes,10,opt,name=prime_video_rating,json=primeVideoRating" json:"prime_video_rating,omitempty"`
	// "Click here to continue watching on Prime Video" link.
	PrimeVideoLink *google_protobuf.StringValue `protobuf:"bytes,11,opt,name=prime_video_link,json=primeVideoLink" json:"prime_video_link,omitempty"`
	// Type of content.
	Type CatalogType `protobuf:"varint,16,opt,name=type,enum=blender.CatalogType" json:"type,omitempty"`
	// If this is a collection of items and has nested content.
	HasChildren bool `protobuf:"varint,17,opt,name=has_children,json=hasChildren" json:"has_children,omitempty"`
	// GTI of parent if applicable.
	ParentGti *google_protobuf.StringValue `protobuf:"bytes,18,opt,name=parent_gti,json=parentGti" json:"parent_gti,omitempty"`
	// Eligibility on a per-user per-region basis.
	Eligibility *Eligibility `protobuf:"bytes,19,opt,name=eligibility" json:"eligibility,omitempty"`
	// Additional information specific to content type.
	//
	// Types that are valid to be assigned to Details:
	//	*CatalogItem_EpisodeDetails
	//	*CatalogItem_SeasonDetails
	//	*CatalogItem_MovieDetails
	//	*CatalogItem_SeriesDetails
	Details isCatalogItem_Details `protobuf_oneof:"details"`
	// List of genres for the content.
	Genres []string `protobuf:"bytes,24,rep,name=genres" json:"genres,omitempty"`
	// List of actors and actresses in the content.
	Starring []string `protobuf:"bytes,25,rep,name=starring" json:"starring,omitempty"`
	// Boolean for content maturity warning.
	IsMature bool `protobuf:"varint,26,opt,name=is_mature,json=isMature" json:"is_mature,omitempty"`
	// If the content is a watchable piece of content.
	IsWatchable bool `protobuf:"varint,27,opt,name=is_watchable,json=isWatchable" json:"is_watchable,omitempty"`
}

func (m *CatalogItem) Reset()                    { *m = CatalogItem{} }
func (m *CatalogItem) String() string            { return proto.CompactTextString(m) }
func (*CatalogItem) ProtoMessage()               {}
func (*CatalogItem) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{6} }

type isCatalogItem_Details interface {
	isCatalogItem_Details()
}

type CatalogItem_EpisodeDetails struct {
	EpisodeDetails *EpisodeDetails `protobuf:"bytes,20,opt,name=episode_details,json=episodeDetails,oneof"`
}
type CatalogItem_SeasonDetails struct {
	SeasonDetails *SeasonDetails `protobuf:"bytes,21,opt,name=season_details,json=seasonDetails,oneof"`
}
type CatalogItem_MovieDetails struct {
	MovieDetails *MovieDetails `protobuf:"bytes,22,opt,name=movie_details,json=movieDetails,oneof"`
}
type CatalogItem_SeriesDetails struct {
	SeriesDetails *SeriesDetails `protobuf:"bytes,23,opt,name=series_details,json=seriesDetails,oneof"`
}

func (*CatalogItem_EpisodeDetails) isCatalogItem_Details() {}
func (*CatalogItem_SeasonDetails) isCatalogItem_Details()  {}
func (*CatalogItem_MovieDetails) isCatalogItem_Details()   {}
func (*CatalogItem_SeriesDetails) isCatalogItem_Details()  {}

func (m *CatalogItem) GetDetails() isCatalogItem_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *CatalogItem) GetGti() string {
	if m != nil {
		return m.Gti
	}
	return ""
}

func (m *CatalogItem) GetTitle() *google_protobuf.StringValue {
	if m != nil {
		return m.Title
	}
	return nil
}

func (m *CatalogItem) GetSummary() *google_protobuf.StringValue {
	if m != nil {
		return m.Summary
	}
	return nil
}

func (m *CatalogItem) GetBoxArt() *google_protobuf.StringValue {
	if m != nil {
		return m.BoxArt
	}
	return nil
}

func (m *CatalogItem) GetYear() *google_protobuf.Int32Value {
	if m != nil {
		return m.Year
	}
	return nil
}

func (m *CatalogItem) GetRating() *google_protobuf.StringValue {
	if m != nil {
		return m.Rating
	}
	return nil
}

func (m *CatalogItem) GetRatingType() *google_protobuf.StringValue {
	if m != nil {
		return m.RatingType
	}
	return nil
}

func (m *CatalogItem) GetPrimeVideoRating() *PrimeVideoRating {
	if m != nil {
		return m.PrimeVideoRating
	}
	return nil
}

func (m *CatalogItem) GetPrimeVideoLink() *google_protobuf.StringValue {
	if m != nil {
		return m.PrimeVideoLink
	}
	return nil
}

func (m *CatalogItem) GetType() CatalogType {
	if m != nil {
		return m.Type
	}
	return CatalogType_UNKNOWN_CATALOG_TYPE
}

func (m *CatalogItem) GetHasChildren() bool {
	if m != nil {
		return m.HasChildren
	}
	return false
}

func (m *CatalogItem) GetParentGti() *google_protobuf.StringValue {
	if m != nil {
		return m.ParentGti
	}
	return nil
}

func (m *CatalogItem) GetEligibility() *Eligibility {
	if m != nil {
		return m.Eligibility
	}
	return nil
}

func (m *CatalogItem) GetEpisodeDetails() *EpisodeDetails {
	if x, ok := m.GetDetails().(*CatalogItem_EpisodeDetails); ok {
		return x.EpisodeDetails
	}
	return nil
}

func (m *CatalogItem) GetSeasonDetails() *SeasonDetails {
	if x, ok := m.GetDetails().(*CatalogItem_SeasonDetails); ok {
		return x.SeasonDetails
	}
	return nil
}

func (m *CatalogItem) GetMovieDetails() *MovieDetails {
	if x, ok := m.GetDetails().(*CatalogItem_MovieDetails); ok {
		return x.MovieDetails
	}
	return nil
}

func (m *CatalogItem) GetSeriesDetails() *SeriesDetails {
	if x, ok := m.GetDetails().(*CatalogItem_SeriesDetails); ok {
		return x.SeriesDetails
	}
	return nil
}

func (m *CatalogItem) GetGenres() []string {
	if m != nil {
		return m.Genres
	}
	return nil
}

func (m *CatalogItem) GetStarring() []string {
	if m != nil {
		return m.Starring
	}
	return nil
}

func (m *CatalogItem) GetIsMature() bool {
	if m != nil {
		return m.IsMature
	}
	return false
}

func (m *CatalogItem) GetIsWatchable() bool {
	if m != nil {
		return m.IsWatchable
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CatalogItem) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CatalogItem_OneofMarshaler, _CatalogItem_OneofUnmarshaler, _CatalogItem_OneofSizer, []interface{}{
		(*CatalogItem_EpisodeDetails)(nil),
		(*CatalogItem_SeasonDetails)(nil),
		(*CatalogItem_MovieDetails)(nil),
		(*CatalogItem_SeriesDetails)(nil),
	}
}

func _CatalogItem_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CatalogItem)
	// details
	switch x := m.Details.(type) {
	case *CatalogItem_EpisodeDetails:
		b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EpisodeDetails); err != nil {
			return err
		}
	case *CatalogItem_SeasonDetails:
		b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SeasonDetails); err != nil {
			return err
		}
	case *CatalogItem_MovieDetails:
		b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MovieDetails); err != nil {
			return err
		}
	case *CatalogItem_SeriesDetails:
		b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SeriesDetails); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CatalogItem.Details has unexpected type %T", x)
	}
	return nil
}

func _CatalogItem_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CatalogItem)
	switch tag {
	case 20: // details.episode_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EpisodeDetails)
		err := b.DecodeMessage(msg)
		m.Details = &CatalogItem_EpisodeDetails{msg}
		return true, err
	case 21: // details.season_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SeasonDetails)
		err := b.DecodeMessage(msg)
		m.Details = &CatalogItem_SeasonDetails{msg}
		return true, err
	case 22: // details.movie_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MovieDetails)
		err := b.DecodeMessage(msg)
		m.Details = &CatalogItem_MovieDetails{msg}
		return true, err
	case 23: // details.series_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SeriesDetails)
		err := b.DecodeMessage(msg)
		m.Details = &CatalogItem_SeriesDetails{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CatalogItem_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CatalogItem)
	// details
	switch x := m.Details.(type) {
	case *CatalogItem_EpisodeDetails:
		s := proto.Size(x.EpisodeDetails)
		n += proto.SizeVarint(20<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CatalogItem_SeasonDetails:
		s := proto.Size(x.SeasonDetails)
		n += proto.SizeVarint(21<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CatalogItem_MovieDetails:
		s := proto.Size(x.MovieDetails)
		n += proto.SizeVarint(22<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CatalogItem_SeriesDetails:
		s := proto.Size(x.SeriesDetails)
		n += proto.SizeVarint(23<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type PrimeVideoRating struct {
	Stars float64 `protobuf:"fixed64,1,opt,name=stars" json:"stars,omitempty"`
	Count int64   `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *PrimeVideoRating) Reset()                    { *m = PrimeVideoRating{} }
func (m *PrimeVideoRating) String() string            { return proto.CompactTextString(m) }
func (*PrimeVideoRating) ProtoMessage()               {}
func (*PrimeVideoRating) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{7} }

func (m *PrimeVideoRating) GetStars() float64 {
	if m != nil {
		return m.Stars
	}
	return 0
}

func (m *PrimeVideoRating) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Fields are *true* if the filter applies to this content.
// Note: empty eligibility message means the user is allowed to play this content.
type Eligibility struct {
	// Recoommended action for the user, can be ALLOW, DENY_WITH_UPSELL, DENY
	Action string                       `protobuf:"bytes,1,opt,name=action" json:"action,omitempty"`
	Reason *google_protobuf.StringValue `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
}

func (m *Eligibility) Reset()                    { *m = Eligibility{} }
func (m *Eligibility) String() string            { return proto.CompactTextString(m) }
func (*Eligibility) ProtoMessage()               {}
func (*Eligibility) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{8} }

func (m *Eligibility) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Eligibility) GetReason() *google_protobuf.StringValue {
	if m != nil {
		return m.Reason
	}
	return nil
}

// Additional details for each content type.
type EpisodeDetails struct {
	Season  *google_protobuf.Int32Value `protobuf:"bytes,1,opt,name=season" json:"season,omitempty"`
	Episode *google_protobuf.Int32Value `protobuf:"bytes,2,opt,name=episode" json:"episode,omitempty"`
	// Length of episode in seconds.
	Duration   *google_protobuf.Int64Value  `protobuf:"bytes,3,opt,name=duration" json:"duration,omitempty"`
	SeriesName *google_protobuf.StringValue `protobuf:"bytes,4,opt,name=series_name,json=seriesName" json:"series_name,omitempty"`
}

func (m *EpisodeDetails) Reset()                    { *m = EpisodeDetails{} }
func (m *EpisodeDetails) String() string            { return proto.CompactTextString(m) }
func (*EpisodeDetails) ProtoMessage()               {}
func (*EpisodeDetails) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{9} }

func (m *EpisodeDetails) GetSeason() *google_protobuf.Int32Value {
	if m != nil {
		return m.Season
	}
	return nil
}

func (m *EpisodeDetails) GetEpisode() *google_protobuf.Int32Value {
	if m != nil {
		return m.Episode
	}
	return nil
}

func (m *EpisodeDetails) GetDuration() *google_protobuf.Int64Value {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *EpisodeDetails) GetSeriesName() *google_protobuf.StringValue {
	if m != nil {
		return m.SeriesName
	}
	return nil
}

type SeasonDetails struct {
	Season       *google_protobuf.Int32Value `protobuf:"bytes,1,opt,name=season" json:"season,omitempty"`
	EpisodeCount *google_protobuf.Int32Value `protobuf:"bytes,2,opt,name=episode_count,json=episodeCount" json:"episode_count,omitempty"`
}

func (m *SeasonDetails) Reset()                    { *m = SeasonDetails{} }
func (m *SeasonDetails) String() string            { return proto.CompactTextString(m) }
func (*SeasonDetails) ProtoMessage()               {}
func (*SeasonDetails) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{10} }

func (m *SeasonDetails) GetSeason() *google_protobuf.Int32Value {
	if m != nil {
		return m.Season
	}
	return nil
}

func (m *SeasonDetails) GetEpisodeCount() *google_protobuf.Int32Value {
	if m != nil {
		return m.EpisodeCount
	}
	return nil
}

type MovieDetails struct {
	// Length of movie in seconds.
	Duration *google_protobuf.Int64Value `protobuf:"bytes,1,opt,name=duration" json:"duration,omitempty"`
}

func (m *MovieDetails) Reset()                    { *m = MovieDetails{} }
func (m *MovieDetails) String() string            { return proto.CompactTextString(m) }
func (*MovieDetails) ProtoMessage()               {}
func (*MovieDetails) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{11} }

func (m *MovieDetails) GetDuration() *google_protobuf.Int64Value {
	if m != nil {
		return m.Duration
	}
	return nil
}

type SeriesDetails struct {
	SeasonCount *google_protobuf.Int32Value `protobuf:"bytes,1,opt,name=season_count,json=seasonCount" json:"season_count,omitempty"`
}

func (m *SeriesDetails) Reset()                    { *m = SeriesDetails{} }
func (m *SeriesDetails) String() string            { return proto.CompactTextString(m) }
func (*SeriesDetails) ProtoMessage()               {}
func (*SeriesDetails) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{12} }

func (m *SeriesDetails) GetSeasonCount() *google_protobuf.Int32Value {
	if m != nil {
		return m.SeasonCount
	}
	return nil
}

type PageInfo struct {
	HasPrevPage bool `protobuf:"varint,1,opt,name=has_prev_page,json=hasPrevPage" json:"has_prev_page,omitempty"`
	HasNextPage bool `protobuf:"varint,2,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *PageInfo) Reset()                    { *m = PageInfo{} }
func (m *PageInfo) String() string            { return proto.CompactTextString(m) }
func (*PageInfo) ProtoMessage()               {}
func (*PageInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{13} }

func (m *PageInfo) GetHasPrevPage() bool {
	if m != nil {
		return m.HasPrevPage
	}
	return false
}

func (m *PageInfo) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

// Holds view count and related info.
type ViewCount struct {
	Value  int64  `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
	Login  string `protobuf:"bytes,2,opt,name=login" json:"login,omitempty"`
	Gti    string `protobuf:"bytes,3,opt,name=gti" json:"gti,omitempty"`
	IsLive bool   `protobuf:"varint,4,opt,name=is_live,json=isLive" json:"is_live,omitempty"`
}

func (m *ViewCount) Reset()                    { *m = ViewCount{} }
func (m *ViewCount) String() string            { return proto.CompactTextString(m) }
func (*ViewCount) ProtoMessage()               {}
func (*ViewCount) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{14} }

func (m *ViewCount) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *ViewCount) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *ViewCount) GetGti() string {
	if m != nil {
		return m.Gti
	}
	return ""
}

func (m *ViewCount) GetIsLive() bool {
	if m != nil {
		return m.IsLive
	}
	return false
}

func init() {
	proto.RegisterType((*WatchPartyTracking)(nil), "blender.WatchPartyTracking")
	proto.RegisterType((*WatchParty)(nil), "blender.WatchParty")
	proto.RegisterType((*Progress)(nil), "blender.Progress")
	proto.RegisterType((*Decoration)(nil), "blender.Decoration")
	proto.RegisterType((*PlaybackInfo)(nil), "blender.PlaybackInfo")
	proto.RegisterType((*User)(nil), "blender.User")
	proto.RegisterType((*CatalogItem)(nil), "blender.CatalogItem")
	proto.RegisterType((*PrimeVideoRating)(nil), "blender.PrimeVideoRating")
	proto.RegisterType((*Eligibility)(nil), "blender.Eligibility")
	proto.RegisterType((*EpisodeDetails)(nil), "blender.EpisodeDetails")
	proto.RegisterType((*SeasonDetails)(nil), "blender.SeasonDetails")
	proto.RegisterType((*MovieDetails)(nil), "blender.MovieDetails")
	proto.RegisterType((*SeriesDetails)(nil), "blender.SeriesDetails")
	proto.RegisterType((*PageInfo)(nil), "blender.PageInfo")
	proto.RegisterType((*ViewCount)(nil), "blender.ViewCount")
	proto.RegisterEnum("blender.State", State_name, State_value)
	proto.RegisterEnum("blender.CatalogType", CatalogType_name, CatalogType_value)
}

func init() {
	proto.RegisterFile("code.justin.tv/vod/blender/rpc/blender/models.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 1472 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xeb, 0x72, 0x13, 0x47,
	0x16, 0x66, 0x64, 0x5b, 0x97, 0xa3, 0x8b, 0xe5, 0xc6, 0xc0, 0x60, 0x2f, 0xac, 0x57, 0xb5, 0xbb,
	0xe5, 0xa5, 0x76, 0xe5, 0x5d, 0x9b, 0x85, 0x5c, 0x21, 0xb6, 0x11, 0x46, 0x15, 0x23, 0xa9, 0x46,
	0xc2, 0x2e, 0x92, 0x1f, 0x53, 0xad, 0x99, 0x46, 0xee, 0x78, 0x6e, 0xd5, 0xdd, 0x12, 0xd6, 0xaf,
	0x54, 0xfe, 0xe4, 0x51, 0xf2, 0x00, 0x79, 0x80, 0xbc, 0x45, 0xfe, 0xe7, 0x21, 0xf2, 0x00, 0xa9,
	0xbe, 0x8c, 0x34, 0xb6, 0x53, 0x20, 0xf8, 0x37, 0xe7, 0x9c, 0xef, 0xdc, 0x4f, 0x9f, 0xee, 0x81,
	0x3d, 0x2f, 0xf6, 0x49, 0xf3, 0xbb, 0x31, 0x17, 0x34, 0x6a, 0x8a, 0xc9, 0xce, 0x24, 0xf6, 0x77,
	0x86, 0x01, 0x89, 0x7c, 0xc2, 0x76, 0x58, 0xe2, 0xcd, 0xbe, 0xc3, 0xd8, 0x27, 0x01, 0x6f, 0x26,
	0x2c, 0x16, 0x31, 0x2a, 0x18, 0xee, 0xc6, 0xfd, 0x51, 0x1c, 0x8f, 0x02, 0xb2, 0xa3, 0xd8, 0xc3,
	0xf1, 0x9b, 0x9d, 0xb7, 0x0c, 0x27, 0x09, 0x61, 0x06, 0xb8, 0xf1, 0xd7, 0xab, 0x72, 0x41, 0x43,
	0xc2, 0x05, 0x0e, 0x13, 0x0d, 0x68, 0xfc, 0x66, 0x01, 0x3a, 0xc5, 0xc2, 0x3b, 0xeb, 0x61, 0x26,
	0xa6, 0x03, 0x86, 0xbd, 0x73, 0x1a, 0x8d, 0xd0, 0xa7, 0x50, 0xf2, 0xc9, 0x84, 0x7a, 0xc4, 0xa5,
	0xbe, 0x6d, 0x6d, 0x59, 0xdb, 0xe5, 0xdd, 0xbf, 0x34, 0xb5, 0xad, 0x66, 0x6a, 0xab, 0xd9, 0x17,
	0x8c, 0x46, 0xa3, 0x13, 0x1c, 0x8c, 0x89, 0x53, 0xd4, 0xf0, 0xb6, 0x8f, 0x3e, 0x81, 0x62, 0x80,
	0xa3, 0xd1, 0x18, 0x8f, 0x88, 0x9d, 0x5b, 0x44, 0x33, 0x45, 0xa3, 0x7f, 0x40, 0x6d, 0xc8, 0x62,
	0xec, 0x7b, 0x98, 0x0b, 0xc2, 0x5c, 0x9a, 0xd8, 0x4b, 0x5b, 0xd6, 0x76, 0xc9, 0xa9, 0x66, 0xb8,
	0xed, 0x04, 0x35, 0xe1, 0x26, 0x17, 0x98, 0x09, 0x97, 0x24, 0xb1, 0x77, 0xe6, 0x72, 0xe2, 0xc5,
	0x91, 0xcf, 0xed, 0xe5, 0x2d, 0x6b, 0x7b, 0xc9, 0x59, 0x53, 0xa2, 0x96, 0x94, 0xf4, 0xb5, 0xa0,
	0xf1, 0x53, 0x0e, 0x60, 0x9e, 0x22, 0xaa, 0x41, 0xce, 0xe4, 0x54, 0x72, 0x72, 0xd4, 0x47, 0xf7,
	0x00, 0xbc, 0x33, 0x1c, 0x45, 0x24, 0x90, 0xb9, 0xe6, 0x14, 0xbf, 0x64, 0x38, 0x6d, 0x1f, 0xd5,
	0x61, 0x69, 0x24, 0xa8, 0x89, 0x44, 0x7e, 0xa2, 0xbf, 0xc3, 0x0a, 0x17, 0x58, 0x10, 0xe5, 0xb1,
	0xb6, 0x5b, 0x6b, 0x9a, 0x66, 0x34, 0xfb, 0x92, 0xeb, 0x68, 0x21, 0xfa, 0x0f, 0x14, 0x13, 0x16,
	0x8f, 0x18, 0xe1, 0xdc, 0x5e, 0x51, 0x65, 0x58, 0x9b, 0x01, 0x7b, 0x46, 0xe0, 0xcc, 0x20, 0x32,
	0x8a, 0x09, 0x25, 0x6f, 0x5d, 0x2f, 0x1e, 0x47, 0xc2, 0xce, 0xab, 0x5c, 0x4a, 0x92, 0x73, 0x28,
	0x19, 0x68, 0x1d, 0x56, 0x82, 0x78, 0x44, 0x23, 0xbb, 0xa0, 0xe2, 0xd0, 0x04, 0x7a, 0x0c, 0x45,
	0x61, 0x3a, 0x66, 0x17, 0x95, 0x8f, 0xcd, 0x99, 0x8f, 0xeb, 0x4d, 0x75, 0x66, 0x60, 0x69, 0x4e,
	0x50, 0x11, 0x10, 0xbb, 0xa4, 0xcd, 0x29, 0xa2, 0xf1, 0xb3, 0x05, 0xc5, 0x34, 0x34, 0xf4, 0x5f,
	0x95, 0x25, 0x13, 0xa6, 0xfb, 0x1b, 0xd7, 0x7a, 0x38, 0x48, 0x27, 0xc9, 0xd1, 0x40, 0xf4, 0x2f,
	0xa8, 0xfb, 0x63, 0x86, 0x05, 0x8d, 0xa3, 0x59, 0x53, 0x72, 0x2a, 0x91, 0xd5, 0x94, 0x6f, 0x5a,
	0x22, 0xa1, 0x49, 0xcc, 0xe9, 0x25, 0xe8, 0x92, 0x86, 0xa6, 0xfc, 0x14, 0x7a, 0x1f, 0x20, 0x21,
	0xcc, 0x23, 0x91, 0x90, 0x03, 0x25, 0x4b, 0x6e, 0x39, 0x19, 0x4e, 0xe3, 0x07, 0x0b, 0xe0, 0x19,
	0xf1, 0x62, 0xed, 0x00, 0x3d, 0x86, 0x8a, 0x87, 0x05, 0x0e, 0xe2, 0x91, 0x4b, 0x05, 0x09, 0x4d,
	0xf4, 0xeb, 0xb3, 0xb2, 0x1c, 0x6a, 0x61, 0x5b, 0x90, 0xd0, 0x29, 0x7b, 0x73, 0x02, 0x7d, 0x06,
	0xd5, 0x24, 0xc0, 0xd3, 0x21, 0xf6, 0xce, 0x5d, 0x1a, 0xbd, 0x89, 0xcd, 0xec, 0xde, 0x9a, 0x37,
	0xcd, 0x48, 0xdb, 0xd1, 0x9b, 0xd8, 0xa9, 0x24, 0x19, 0xaa, 0xf1, 0x3d, 0x54, 0xb2, 0x52, 0x55,
	0xde, 0xf8, 0x9c, 0x44, 0x66, 0xca, 0x34, 0x81, 0xfe, 0x09, 0xab, 0xdc, 0x97, 0xc6, 0xa9, 0x70,
	0x13, 0xcc, 0x70, 0xc8, 0xcd, 0xb4, 0x55, 0xb9, 0x7f, 0xde, 0x8e, 0xa8, 0xe8, 0x29, 0x26, 0xfa,
	0x1f, 0xdc, 0x32, 0x67, 0x2f, 0x61, 0xf1, 0xc5, 0xd4, 0x1d, 0x62, 0x4e, 0xdc, 0x31, 0x0b, 0xcc,
	0x0c, 0x22, 0x2d, 0xec, 0x49, 0xd9, 0x01, 0xe6, 0xe4, 0x15, 0x0b, 0x1a, 0xbf, 0xe6, 0x60, 0xf9,
	0x15, 0x27, 0x0c, 0xfd, 0x7b, 0x36, 0xdc, 0xef, 0x3b, 0x76, 0x72, 0xf4, 0x9f, 0x42, 0x05, 0x7b,
	0x1e, 0xe1, 0xdc, 0xd5, 0xe1, 0x2e, 0x72, 0x5c, 0xcb, 0x5a, 0x63, 0xa0, 0x52, 0xba, 0x07, 0x40,
	0x13, 0x17, 0xfb, 0xbe, 0x1a, 0x73, 0x1d, 0x5f, 0x89, 0x26, 0xfb, 0x9a, 0x81, 0x6e, 0x43, 0x9e,
	0x91, 0x11, 0x8d, 0x23, 0xd5, 0xb7, 0x92, 0x63, 0x28, 0xb4, 0x9b, 0x4e, 0xf3, 0xca, 0x02, 0x0e,
	0xcd, 0xac, 0x5f, 0xda, 0x48, 0xf9, 0x8f, 0xde, 0x48, 0x85, 0x0f, 0xd9, 0x48, 0x8d, 0x5f, 0x8a,
	0x50, 0xce, 0x4c, 0x4c, 0xba, 0x0c, 0xac, 0xf9, 0x32, 0xd8, 0x4d, 0x4f, 0xd2, 0x22, 0xb5, 0xd3,
	0x50, 0xf4, 0x08, 0x0a, 0x7c, 0x1c, 0x86, 0x98, 0x4d, 0x55, 0xc9, 0xde, 0xa7, 0x95, 0x82, 0xd1,
	0xff, 0xa1, 0x30, 0x8c, 0x2f, 0x5c, 0x79, 0x28, 0x97, 0x17, 0xd0, 0xcb, 0x0f, 0xe3, 0x8b, 0x7d,
	0x26, 0xd0, 0x0e, 0x2c, 0x4f, 0x09, 0x66, 0xa6, 0xd8, 0x9b, 0xd7, 0x74, 0xda, 0x91, 0xd8, 0xdb,
	0xd5, 0x2a, 0x0a, 0x88, 0x1e, 0x42, 0x5e, 0x9e, 0xa6, 0x68, 0xb4, 0x50, 0x9d, 0x0d, 0x16, 0x7d,
	0x09, 0x65, 0xfd, 0xe5, 0x8a, 0x69, 0xb2, 0x58, 0xa1, 0x41, 0x2b, 0x0c, 0xa6, 0x09, 0x41, 0x47,
	0x80, 0x12, 0x46, 0x43, 0xe2, 0x4e, 0xa8, 0x4f, 0x62, 0xd7, 0x04, 0x00, 0xca, 0xca, 0xdd, 0xcc,
	0xe6, 0xa4, 0x21, 0x39, 0x91, 0x08, 0x47, 0x01, 0x9c, 0x7a, 0x72, 0x85, 0x83, 0x9e, 0x43, 0x3d,
	0x6b, 0x28, 0xa0, 0xd1, 0xb9, 0x5d, 0x5e, 0x20, 0x98, 0xda, 0xdc, 0xd2, 0x31, 0x8d, 0xce, 0xd1,
	0x36, 0x2c, 0xab, 0x44, 0xea, 0x6a, 0xcb, 0x5f, 0xdb, 0x20, 0x32, 0x68, 0x47, 0x21, 0xd0, 0xdf,
	0xa0, 0x72, 0x86, 0xb9, 0xeb, 0x9d, 0xd1, 0xc0, 0x67, 0x24, 0xb2, 0xd7, 0xb6, 0xac, 0xed, 0xa2,
	0x53, 0x3e, 0xc3, 0xfc, 0xd0, 0xb0, 0xd0, 0xe7, 0x00, 0x09, 0x66, 0x24, 0x12, 0xae, 0x9c, 0x1f,
	0xb4, 0x40, 0x38, 0x25, 0x8d, 0x3f, 0x12, 0x14, 0x3d, 0x82, 0x32, 0x09, 0xe8, 0x88, 0x0e, 0x69,
	0x40, 0xc5, 0xd4, 0xbe, 0x79, 0x65, 0xa5, 0xb5, 0xe6, 0x32, 0x27, 0x0b, 0x44, 0x07, 0xb0, 0x4a,
	0x12, 0xca, 0x63, 0x9f, 0xb8, 0x3e, 0x11, 0x98, 0x06, 0xdc, 0x5e, 0x57, 0xba, 0x77, 0xe6, 0xba,
	0x5a, 0xfe, 0x4c, 0x8b, 0x5f, 0xdc, 0x70, 0x6a, 0xe4, 0x12, 0x07, 0x3d, 0x85, 0x1a, 0x27, 0x98,
	0xc7, 0xd1, 0xcc, 0xc4, 0x2d, 0x65, 0xe2, 0xf6, 0xfc, 0xd6, 0x53, 0xe2, 0xb9, 0x85, 0x2a, 0xcf,
	0x32, 0xd0, 0x17, 0x50, 0x0d, 0xe3, 0x09, 0x9d, 0x87, 0x70, 0xfb, 0xca, 0x5e, 0x7d, 0x29, 0xa5,
	0x73, 0xf5, 0x4a, 0x98, 0xa1, 0xb5, 0x7b, 0x46, 0x09, 0x9f, 0xa9, 0xdf, 0xb9, 0xe6, 0x5e, 0x8a,
	0x2f, 0xb9, 0xcf, 0x30, 0xe4, 0x0a, 0x1a, 0x91, 0x88, 0x11, 0x6e, 0xdb, 0x5b, 0x4b, 0x72, 0x05,
	0x69, 0x0a, 0x6d, 0x40, 0x51, 0xde, 0x5a, 0xb2, 0xde, 0xf6, 0x5d, 0x25, 0x99, 0xd1, 0x68, 0x13,
	0x4a, 0x94, 0xbb, 0x21, 0x16, 0x63, 0x46, 0xec, 0x0d, 0xd5, 0xcc, 0x22, 0xe5, 0x2f, 0x15, 0x2d,
	0x9b, 0x4d, 0xb9, 0xfb, 0x56, 0xde, 0xae, 0x78, 0x18, 0x10, 0x7b, 0x53, 0x37, 0x9b, 0xf2, 0xd3,
	0x94, 0x75, 0x50, 0x82, 0x82, 0x89, 0xb6, 0xf1, 0x04, 0xea, 0x57, 0x47, 0x56, 0xde, 0x0e, 0xd2,
	0x15, 0x57, 0x6b, 0xc4, 0xd2, 0xb7, 0x27, 0x97, 0x5c, 0x7d, 0xf7, 0xeb, 0x2b, 0x53, 0x13, 0x8d,
	0x6f, 0xa1, 0x9c, 0x69, 0xaf, 0xcc, 0x06, 0x7b, 0xf2, 0x9e, 0x33, 0x2b, 0xc8, 0x50, 0xea, 0xc4,
	0xaa, 0xaa, 0x2f, 0xb4, 0x86, 0x0c, 0xb6, 0xf1, 0xbb, 0x05, 0xb5, 0xcb, 0x03, 0x80, 0xf6, 0x20,
	0xaf, 0xdb, 0x67, 0xee, 0x90, 0x77, 0x6e, 0x0b, 0x03, 0x95, 0x7b, 0xc9, 0x4c, 0x8d, 0x71, 0xff,
	0x4e, 0xad, 0x14, 0x2b, 0x5f, 0x2f, 0xe9, 0xbb, 0xc0, 0xec, 0xc1, 0x3f, 0xd5, 0x7b, 0xf4, 0x30,
	0xdd, 0xe7, 0x06, 0x2c, 0x37, 0x8d, 0x19, 0x8a, 0x08, 0x87, 0x64, 0xa1, 0x5d, 0x08, 0x5a, 0xa1,
	0x83, 0x43, 0xd2, 0xf8, 0xd1, 0x82, 0xea, 0xa5, 0xa1, 0xfd, 0xb8, 0xac, 0xbf, 0x82, 0x6a, 0x7a,
	0xba, 0xe6, 0x8d, 0x7b, 0x8f, 0x6e, 0xc5, 0x68, 0xa8, 0x47, 0x5d, 0xe3, 0x08, 0x2a, 0xd9, 0xe1,
	0xbf, 0x54, 0x10, 0xeb, 0x03, 0x0a, 0xd2, 0xe8, 0xca, 0x84, 0xb2, 0x53, 0xff, 0x04, 0x2a, 0xe6,
	0xd4, 0xea, 0xd0, 0x16, 0x48, 0xab, 0xac, 0x15, 0x74, 0x64, 0x0e, 0x14, 0x7b, 0x78, 0x44, 0xd4,
	0x63, 0xa6, 0x01, 0x55, 0xb9, 0xdd, 0x12, 0x46, 0x26, 0x6e, 0x22, 0xaf, 0x50, 0x6b, 0xb6, 0xde,
	0x7a, 0x8c, 0x4c, 0x24, 0x2e, 0xc5, 0x44, 0xe4, 0x42, 0x68, 0x4c, 0x6e, 0x86, 0xe9, 0x90, 0x0b,
	0x21, 0x31, 0x8d, 0x21, 0x94, 0x4e, 0xb2, 0xef, 0xd9, 0x89, 0x74, 0xab, 0x8c, 0x2d, 0x39, 0x9a,
	0x98, 0xbf, 0x72, 0x73, 0xd9, 0x57, 0xee, 0xf5, 0x17, 0xf8, 0x1d, 0x28, 0x50, 0xee, 0x06, 0x74,
	0xa2, 0x9b, 0x5f, 0x74, 0xf2, 0x94, 0x1f, 0xd3, 0x09, 0x79, 0xe0, 0xc0, 0x8a, 0x7a, 0x84, 0xa3,
	0x35, 0xa8, 0xbe, 0xea, 0x7c, 0xdd, 0xe9, 0x9e, 0x76, 0xdc, 0xfe, 0x60, 0x7f, 0xd0, 0xaa, 0xdf,
	0x40, 0x65, 0x28, 0xbc, 0x78, 0xdd, 0x6b, 0xb9, 0xed, 0x4e, 0xdd, 0x92, 0x44, 0xef, 0x78, 0xff,
	0x75, 0xbb, 0x73, 0x54, 0xcf, 0x49, 0xa2, 0xfb, 0xfc, 0xf9, 0x71, 0xbb, 0xd3, 0xaa, 0x2f, 0xa3,
	0x55, 0x28, 0xb7, 0x3b, 0x6e, 0xcf, 0xe9, 0x1e, 0x39, 0xad, 0x7e, 0xbf, 0xbe, 0xf2, 0xe0, 0x74,
	0xf6, 0x04, 0x50, 0xf7, 0x94, 0x0d, 0xeb, 0xa9, 0xe5, 0xc3, 0xfd, 0xc1, 0xfe, 0x71, 0xf7, 0xc8,
	0x1d, 0xbc, 0xee, 0x19, 0x07, 0xad, 0x5e, 0xbb, 0xdf, 0x7d, 0xd6, 0xaa, 0x5b, 0xa8, 0x04, 0x2b,
	0x2f, 0xbb, 0x27, 0xed, 0x56, 0x3d, 0x87, 0x00, 0xf2, 0xfd, 0xd6, 0x7e, 0xbf, 0xdb, 0xa9, 0x2f,
	0xe9, 0x6f, 0xa7, 0xdd, 0xea, 0xd7, 0x97, 0x0f, 0x4a, 0xdf, 0xa4, 0xbf, 0x71, 0xc3, 0xbc, 0xea,
	0xc8, 0xde, 0x1f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x41, 0x02, 0x63, 0xf8, 0x0d, 0x0e, 0x00, 0x00,
}
