# Anchor

This project is built with [Core UI](https://git.xarth.tv/core-ui/core-ui) which was bootstrapped with [Create React App](https://github.com/facebook/create-react-app).

> Anchor is the front end application using React.js, Core UI, and Sass to get data from the Atlas backend

## Getting Started

You need to be on the Twitch VPN and have your Github SSH credentials set up.

1. Clone this repository `git clone git@git.xarth.tv:cb/Anchor.git`
2. Run `yarn install` to update dependencies (may need to be connected to Amazon network)

## Table of Contents

- [Tech Stack](#tech-stack)
- [Run Back End server](#run-back-end-server)
- [Run Front End server](#run-front-end-server)
- [Run Tests](#run-tests)

---

## Tech Stack

| Library                   | Description                     |
| ------------------------- | ------------------------------- |
| **React.js**              | for building interface          |
| **Core UI**               | Twitch component library        |
| **TypeScript**            | typed superset of JavaScript    |
| **Sass**                  | CSS extension language          |
| **React Router**          | routing framework               |
| **React Testing Library** | testing framework for React app |

## Run Back End server

1. Connect to vpn.cursedata.io via OpenVPN or Viscosity (enable multiple network connections in options for Viscosity if needed)
2. Connect to Twitch VPN via Viscosity
3. Run ResonanceServer through Visual Studio or via Command Line

### Windows

```bash
yarn backend
```

### Mac OS

```bash
yarn backend_mac
```

### Shell script permissions error

```bash
yarn shell_permissions
yarn backend_mac
```

## Run Front End server

1. Run Anchor app

```bash
yarn start # this also runs `yarn install`
```

2. Go to http://localhost:8080 to see application in your favorite Chrome browser

## Run Tests

> TODO: Explore [Kent C Dodd's React Testing Library](https://github.com/testing-library/react-testing-library)

## FAQ

### How do I contribute to Anchor

See [Contributing guidelines](https://github.com/crsdata/Anchor/wiki/Contributing) on the Wiki

### How do I use the latest version of Core UI?

If you need to upgrade to the latest version of Core UI, run `yarn upgrade twitch-core-ui@latest`

### How do I add static assets?

Put them in the `public` folder! For example: `public/my-image.jpg`, then link to it with `<img src="my-image.jpg" />`

### How do I kill active ports

- Kill dotnet ports

```
killall -9 dotnet
```

- Kill Active Ports

  1. Find active ports

  ```
  lsof -iTCP -sTCP:LISTEN -n -P
  ```

  2. Kill active dotnet ports from active ports list

  ```
  kill -9 $PID
  ```
