import React, { useEffect } from 'react';
import { Router, Redirect, Route, Switch } from 'react-router-dom';
import { createBrowserHistory } from 'history';

import PrivateRoute from './components/private-route';

import LoginPage from './pages/login';
import OverviewPage from './pages/overview';
import ProductsPage from './pages/products';
import ProductsCreatePage from './pages/products/create';
import ProductsEditPage from './pages/products/edit';
import SeasonsPage from './pages/seasons';
import SeasonsCreatePage from './pages/seasons/create';
import SeasonsEditPage from './pages/seasons/edit';
import EventsPage from './pages/events';
import EventsCreatePage from './pages/events/create';
import EventsEditPage from './pages/events/edit';
import EventsChannelPage from './pages/events/channel';
import EventsSeasonPage from './pages/events/season';
import EventsCategoryPage from './pages/events/category';
import EventsWorkspacePage from './pages/events/workspace';
import ContractsPage from './pages/contracts';
import ContractsCreatePage from './pages/contracts/create';
import ContractsEditPage from './pages/contracts/edit';
import SettingsPage from './pages/settings';
import ErrorPage from './pages/error';
import AuthorizingPage from './pages/authorizing';
import UnauthorizedPage from './pages/unauthorized';
import NooPccAssignedPage from './pages/no-pcc';
import GettingStartedPage from './pages/getting-started';

import 'twitch-core-ui/css/index-dark.css';
import 'twitch-core-ui/css/index-light.css';
import './App.scss';

function App() {
  const customHistory = createBrowserHistory();

  useEffect(() => {
    const wrapper = document.querySelector('html');

    const currentThemeValue = localStorage.getItem('currentThemeValue');

    if (wrapper) {
      wrapper.classList.remove('tw-root--theme-light');
      wrapper.classList.remove('tw-root--theme-dark');
      if (!!currentThemeValue) {
        wrapper.classList.add(currentThemeValue);
      } else {
        wrapper.classList.add('tw-root--theme-light');
      }
    }
  }, []);

  return (
    <Router history={customHistory}>
      <Switch>
        <Route exact path="/login" component={LoginPage} />
        <Redirect from="/overview" to="/" />
        <PrivateRoute exact path="/" component={OverviewPage} />
        <PrivateRoute exact path="/products" component={ProductsPage} />
        <PrivateRoute exact path="/products/create" component={ProductsCreatePage} />
        <PrivateRoute exact path="/products/edit/:id" component={ProductsEditPage} />
        <PrivateRoute exact path="/seasons" component={SeasonsPage} />
        <PrivateRoute exact path="/seasons/create" component={SeasonsCreatePage} />
        <PrivateRoute exact path="/seasons/edit/:id" component={SeasonsEditPage} />
        <PrivateRoute exact path="/events" component={EventsPage} />
        <PrivateRoute exact path="/events/create" component={EventsCreatePage} />
        <PrivateRoute exact path="/events/edit/:id" component={EventsEditPage} />
        <PrivateRoute exact path="/events/channel" component={EventsChannelPage} />
        <PrivateRoute exact path="/events/season" component={EventsSeasonPage} />
        <PrivateRoute exact path="/events/category" component={EventsCategoryPage} />
        <PrivateRoute exact path="/events/workspace" component={EventsWorkspacePage} />
        <PrivateRoute exact path="/contracts" component={ContractsPage} />
        <PrivateRoute exact path="/contracts/create" component={ContractsCreatePage} />
        <PrivateRoute exact path="/contracts/edit/:id" component={ContractsEditPage} />
        <PrivateRoute exact path="/settings" component={SettingsPage} />
        <Route exact path="/auth/callback/2" component={AuthorizingPage} />
        <Route exact path="/auth/callback/1" component={AuthorizingPage} />
        <Route exact path="/getting-started" component={GettingStartedPage} />
        <Route exact path="/error" component={ErrorPage} />
        <Route exact path="/unauthorized" component={UnauthorizedPage} />
        <Route exact path="/no-pcc" component={NooPccAssignedPage} />
        <Route exact path="*" component={ErrorPage} />
      </Switch>
    </Router>
  );
}

export default App;
