import React, { useEffect } from 'react';
import { useHistory } from 'react-router-dom';
import Cookies from 'js-cookie';
import { Display, Layout, CoreText, SVG, SVGAsset, SVGType, TextType, JustifyContent, LoadingSpinner, SpinnerSize, AlignItems } from 'twitch-core-ui';
import { AUTH_URL } from '../utils/config';
import { fetchWithTimeout } from '../utils/helpers';
import { PCCID_LOCAL_STORAGE_KEY } from '../utils/constants';

function Authorizing() {
  const history = useHistory();
  const isDevMode = window.location.hostname === 'localhost';

  useEffect(() => {
    setToken();
    verifyAuth();
  });

  const setToken = () => {
    let urlParams = new URLSearchParams(window.location.search);
    Cookies.set('code', urlParams.get('code'), { secure: !isDevMode });
  };

  const verifyAuth = () => {
    fetchWithTimeout(`${AUTH_URL}/verify-auth/`, {
      method: 'POST',
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ site_id: 'Atlas', token: Cookies.get('code') })
    })
      .then(response => response.json())
      .then(data => {
        console.log(`[authorizing.tsx] verifyAuth(): `, data);
        if (data.success) {
          var authData = data.data;
          const options = {
            path: '/',
            expires: new Date(new Date().setMonth(new Date().getMonth() + 1)),
            secure: !isDevMode
          };
          Cookies.set('groups', authData.groups, options);
          Cookies.set('profile', authData.profile, options);
          Cookies.set('token', authData.token, options);
          Cookies.set('expireDate', authData.expireDate, options);
          if (localStorage.getItem(PCCID_LOCAL_STORAGE_KEY)) {
            history.push('/');
          } else {
            history.push('/getting-started');
          }
        } else {
          history.push('/unauthorized');
        }
      })
      .catch(error => console.error(`[authorizing.tsx] verifyAuth(): `, error));
  };

  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Center} padding={5}>
      <Layout className="login-wrapper">
        <Layout display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
          <SVG asset={SVGAsset.LogoGlitch} width={60} height={45} type={SVGType.Brand} />
          <CoreText type={TextType.H2}>Authorizing...</CoreText>
        </Layout>
        <Layout margin={{ top: 2 }}>
          <LoadingSpinner fillContent inheritColor size={SpinnerSize.Large} />
        </Layout>
      </Layout>
    </Layout>
  );
}

export default Authorizing;
