import React, { useState } from 'react';
import { Layout, Avatar } from 'twitch-core-ui';
import './styles/AvatarFallback.scss';

function AvatarFallback({ login, profileImage, size }) {
  const [error, setError] = useState(false);

  const getFallbackImg = e => {
    setError(true);
    return (e.target.src = '/images/404-avatar.png');
  };

  const isFallbackRequired = profileImage == null || profileImage === 'empty_profile_image' || profileImage === undefined;
  return isFallbackRequired ? (
    <Layout className="img--fallback">
      <Avatar alt="404 avatar" src="/images/404-avatar.png" size={size} userLogin="" />
    </Layout>
  ) : (
    <Layout className={error ? 'img--fallback' : ''}>
      <Avatar alt={`${login} avatar`} src={profileImage} size={size} userLogin={login} onError={getFallbackImg} />
    </Layout>
  );
}

export default AvatarFallback;
