import React from 'react';
import {
  Layout,
  FontSize,
  CoreText,
  TextType,
  FontWeight,
  Display,
  AlignItems,
  JustifyContent,
  ChannelStatusIndicator,
  ChannelStatusIndicatorSize,
  ChannelStatusIndicatorStatus,
  Color,
  FlexWrap,
  InjectLayout
} from 'twitch-core-ui';
import { abbreviateNumber } from '../utils/helpers';
import AvatarFallback from './avatar-fallback';

function ChannelCard({ login, status, viewers, category, profileImage }) {
  const isChannelOnline = status === 'Online';
  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Center}>
      <AvatarFallback login={login} profileImage={profileImage} size={30} />
      <Layout display={Display.Flex} margin={{ left: 0.5 }} justifyContent={JustifyContent.Between} fullWidth ellipsis>
        <Layout fullWidth>
          <div style={{ width: 135 }}>
            <Layout display={Display.Flex} alignItems={AlignItems.Center} flexWrap={FlexWrap.Wrap}>
              <InjectLayout flexGrow={1} fullWidth>
                <CoreText fontSize={FontSize.Size5} fontWeight={FontWeight.SemiBold} ellipsis>
                  {login || 'No Login found'}
                </CoreText>
              </InjectLayout>
              <CoreText fontSize={FontSize.Size6} color={Color.Alt2} ellipsis>
                {category || ' '}
              </CoreText>
            </Layout>
          </div>
        </Layout>
        <Layout flexShrink={0}>
          <div style={{ width: 45 }}>
            <Layout display={Display.Flex} alignItems={AlignItems.Center}>
              {isChannelOnline && <ChannelStatusIndicator size={ChannelStatusIndicatorSize.Small} status={ChannelStatusIndicatorStatus.Live} />}
              <Layout margin={{ x: 0.5 }}>
                <CoreText type={TextType.Span} color={Color.Alt} fontSize={FontSize.Size6}>
                  {isChannelOnline ? abbreviateNumber(viewers) : 'Offline'}
                </CoreText>
              </Layout>
            </Layout>
          </div>
        </Layout>
      </Layout>
    </Layout>
  );
}

export default ChannelCard;
