import * as React from 'react';
import { Avatar, ButtonIcon, CoreText, Display, Layout, SVGAsset } from 'twitch-core-ui';
import { Channel } from "../utils/types";

interface Props {
    channels: Channel[];
}

export const ChannelsExpando: React.FC<Props> = (props) => {
    const [expanded, setExpanded] = React.useState(false);

    return (
        <Layout>
            <ButtonIcon icon={expanded ? SVGAsset.AngleDown : SVGAsset.AngleRight} onClick={() => setExpanded(!expanded) }/>
            {expanded &&
                <Layout>
                    { props.channels.map((channel: Channel) => {
                        const login = channel?.channel_login;
                        const profile_image = channel?.profile_image;
                        if (!login) {
                            return null;
                        }

                        return (
                            <Layout key={login} margin={0.5} display={Display.Flex}>
                                <Avatar size={24} src={profile_image != null ? profile_image : '/images/404-avatar.png'} alt="" userLogin={login} />
                                <Layout margin={{left: 0.5}}>
                                    <CoreText>{login}</CoreText>
                                </Layout>
                            </Layout>
                        );
                    })}
                </Layout>
            }
        </Layout>
    );
}
