import React from 'react';
import { useHistory } from 'react-router-dom';
import { Layout, Button, ButtonType, CoreText, SVGAsset } from 'twitch-core-ui';

function ClearFilters({ filters }) {
  const history = useHistory();

  const clearFilters = e => {
    e.preventDefault();
    localStorage.removeItem('eventsFilterProducts');
    localStorage.removeItem('eventsFilterTopics');
    localStorage.removeItem('eventsFilterChannels');
    history.push('/events');
    document.location.reload();
  };

  return (
    <>
      <Layout padding={{ top: 1 }}>
        <CoreText>We couldn't find any {filters} matching your search.</CoreText>
        <CoreText>Try different filters or broadening your search.</CoreText>
      </Layout>
      <Layout padding={{ top: 1 }}>
        <Button type={ButtonType.Alert} icon={SVGAsset.Trash} onClick={clearFilters}>
          Clear Filters
        </Button>
      </Layout>
    </>
  );
}

export default ClearFilters;
