import React from 'react';
import { Button, Layout, Display, JustifyContent, FlexWrap, AlignItems, Toggle, CoreText, TextType, FontSize } from 'twitch-core-ui';
import { useSelectedPermissions } from '../context/permissions-context';

function ContractsHeader({ isLegacyVisible, setIsLegacyVisible }) {
  const permissions = useSelectedPermissions();
  const canEdit = permissions.includes('Can View Any Contract');

  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Between} flexWrap={FlexWrap.Wrap} alignItems={AlignItems.Center}>
      <Layout padding={{ bottom: 2 }}>
        <Layout display={Display.Flex} alignItems={AlignItems.Center} flexShrink={0}>
          <CoreText type={TextType.Strong} fontSize={FontSize.Size6}>
            Display Past Contracts
          </CoreText>
          <Layout padding={{ x: 1 }}>
            <Toggle checked={isLegacyVisible} onChange={e => setIsLegacyVisible(e.currentTarget.checked)} />
          </Layout>
        </Layout>
      </Layout>
      {canEdit && (
        <Layout padding={{ bottom: 2 }}>
          <Layout display={Display.Flex} justifyContent={JustifyContent.End}>
            <Layout padding={{ left: 1 }}>
              <Button linkTo="/contracts/create">Create New Contract</Button>
            </Layout>
          </Layout>
        </Layout>
      )}
    </Layout>
  );
}

export default ContractsHeader;
