import React, { useState } from 'react';
import { AlertBanner, AlertBannerType, Layout } from 'twitch-core-ui';

function ErrorAlert({ error, setError = undefined }) {
  const [isDisplayed, setIsDisplayed] = useState(true);

  const dismissError = () => {
    setIsDisplayed(false);
    if (setError !== undefined) {
      setError('');
    }
  }

  return (
    isDisplayed && (
      <Layout margin={{ bottom: 2 }}>
        <AlertBanner
          type={AlertBannerType.Error}
          status="ERROR"
          message={error === undefined ? error.message : `${typeof error === 'object' ? error : error.replace('Error: ', '')}`}
          closeButton={{
            'aria-label': 'Dismiss Error',
            onClick: dismissError
          }}
        />
      </Layout>
    )
  );
}

export default ErrorAlert;
