import React from 'react';
import { Color, Column, CoreLink, CoreText, FontSize, Grid, Layout, ResponsiveWrapper, SVG, SVGAsset, SVGType, TextType } from 'twitch-core-ui';

function ErrorCard({ status }) {
  console.error(`error.status_code: ${status}`);

  let title, subtitle;

  switch (status) {
    case 200: // Also display a 404 if someone requests /error explicitly
      title = 'Page Not Found';
      subtitle = 'The page you were looking for could not be found.';
      break;
    case 301:
    case 302:
    case 400:
    case 401:
      title = 'Request has been moved';
      subtitle = 'Oops - looks like the server could not understand the request or the URL you requested has been moved.';
      break;
    case 'unauthorized':
    case 403:
      title = 'Access Denied';
      subtitle = 'Looks like you are unauthorized to view Atlas.';
      break;
    case 404:
      title = 'Page Not Found';
      subtitle = 'The page you were looking for could not be found.';
      break;
    case 500:
    case 501:
    case 502:
    case 503:
      title = 'Server Error';
      subtitle = `Oops - looks like we can't fulfill that request at the moment. Try again in a bit!`;
      break;
    case 'no-pcc':
      title = 'No PCC Assigned';
      subtitle = `Looks like you don't have any Premium Content Creators mapped to your LDAP.`;
      break;
    default:
      title = 'Error';
      subtitle = 'An error occured on client';
      break;
  }

  if (!status) {
    try {
      console.log('[error-card.tsx]: Trying...');
    } catch (e) {
      console.error(e);
    }
  }

  // const removeCookies = () => {
  //   const cookies = new Cookies();
  //   cookies.remove('expireDate', { path: '/' });
  //   cookies.remove('groups', { path: '/' });
  //   cookies.remove('profile', { path: '/' });
  //   cookies.remove('token', { path: '/' });
  //   console.log('remove cookies');
  // };

  return (
    <Layout className="error-page" padding={5}>
      {status ? (
        <ResponsiveWrapper centered>
          <Grid>
            <Column cols={{ default: 12, sm: 8, md: 5 }} offset={{ default: 0, sm: 1 }}>
              <Layout padding={{ top: 5 }} margin={{ bottom: 4 }}>
                <SVG type={SVGType.Alt2} asset={SVGAsset.DeadGlitch} width={80} height={80} />
              </Layout>
              <Layout margin={{ bottom: 2 }}>
                <CoreText className="error-page__heading" type={TextType.H1} bold>
                  {title}
                </CoreText>
              </Layout>
              <Layout margin={{ bottom: 2 }}>
                <CoreText fontSize={FontSize.Size4} color={Color.Alt}>
                  {subtitle}
                </CoreText>
              </Layout>
              <CoreText fontSize={FontSize.Size4} color={Color.Alt}>
                You can go back to the <CoreLink linkTo="/">front page</CoreLink> or reach out to our team via Slack in{' '}
                <CoreLink linkTo="slack://channel?team=T0266V6GF&id=CTS04FHLP" targetBlank>
                  #atlas-feedback
                </CoreLink>
                . You can also create an issue on{' '}
                <CoreLink linkTo="https://jira.twitch.com/secure/CreateIssue!default.jspa?pid=27901" targetBlank>
                  Jira
                </CoreLink>
                .
              </CoreText>
            </Column>
          </Grid>
        </ResponsiveWrapper>
      ) : (
        <CoreText type={TextType.P}>An error occurred on client</CoreText>
      )}
    </Layout>
  );
}

export default ErrorCard;
