import React, { useState, useEffect } from 'react';
import { Layout, Position, CoreText, Display, AlignItems, JustifyContent, Input, InputType } from 'twitch-core-ui';
import DatePicker from './date-picker';

function EventsFilterTimeline({ timeline, setTimeline }) {
  const [minDate, setMinDate] = useState('');
  const [maxDate, setMaxDate] = useState('');

  useEffect(() => {
    if (timeline == null) return;
    let [minDate, maxDate] = timeline && timeline.split(',');
    setMinDate(!!minDate ? minDate + 'T00:00:00' : '');
    setMaxDate(!!maxDate ? maxDate + 'T00:00:00' : ''); /* eslint-disable react-hooks/exhaustive-deps */
  }, []);

  useEffect(() => {
    if (minDate == null) return;
    let minDateStr = !!minDate ? `${new Date(minDate).toISOString().slice(0, 10)}` : '';
    let maxDateStr = timeline.split(',')[1];
    if (!!minDateStr || !!maxDateStr) {
      setTimeline(`${minDateStr},${!!timeline ? timeline.split(',')[1] : ''}`);
    } /* eslint-disable react-hooks/exhaustive-deps */
  }, [minDate]);

  useEffect(() => {
    if (maxDate == null) return;
    let minDateStr = timeline.split(',')[0];
    let maxDateStr = !!maxDate ? `${new Date(maxDate).toISOString().slice(0, 10)}` : '';
    if (!!minDateStr || !!maxDateStr) {
      setTimeline(`${!!timeline ? timeline.split(',')[0] : ''},${maxDateStr}`);
    } /* eslint-disable react-hooks/exhaustive-deps */
  }, [maxDate]);

  return (
    <>
      <Layout margin={{ bottom: 0.5 }}>
        <CoreText bold>Timeline</CoreText>
      </Layout>
      <Layout display={Display.Hide}>
        <Input type={InputType.Text} name="timeline" value={timeline} onChange={setTimeline} />
      </Layout>
      <Layout position={Position.Relative} fullWidth>
        <Layout display={Display.Flex} alignItems={AlignItems.Center} justifyContent={JustifyContent.Center} fullHeight fullWidth>
          <Layout margin={{ right: 0.5 }} fullWidth>
            <DatePicker defaultDate={new Date(minDate)} onChange={date => setMinDate(date)} maxDate={new Date(maxDate)} />
          </Layout>
          <Layout fullWidth>
            <DatePicker defaultDate={new Date(maxDate)} onChange={date => setMaxDate(date)} minDate={new Date(minDate)} position="right" />
          </Layout>
        </Layout>
      </Layout>
    </>
  );
}

export default EventsFilterTimeline;
