import React, { useState } from 'react';
import {
  CoreText,
  TextType,
  Button,
  Layout,
  Transition,
  TransitionType,
  Position,
  ButtonType,
  ZIndex,
  DropDownMenu,
  DropDownMenuItem,
  SVGAsset
} from 'twitch-core-ui';
import ClickOutDetector from './click-out-detector';

function EventsHeaderNav({ activePage = '', dropdownOptions = [] }) {
  const [isDropdownOpen, setIsDropdownOpen] = useState(false);

  return (
    <ClickOutDetector onClickOut={() => setIsDropdownOpen(false)}>
      <Layout padding={{ left: 1 }} position={Position.Relative} zIndex={ZIndex.Default}>
        <Button type={ButtonType.Secondary} icon={SVGAsset.VisibilityShown} dropdown onClick={() => setIsDropdownOpen(!isDropdownOpen)}>
          View Mode: {activePage}
        </Button>
        <Layout position={Position.Relative} fullWidth>
          <Transition type={TransitionType.SlideOverTop} show={isDropdownOpen}>
            <DropDownMenu show={isDropdownOpen}>
              {dropdownOptions.map(option => {
                const { label, linkTo } = option;
                return (
                  <DropDownMenuItem key={label} linkTo={linkTo} selected={label === activePage}>
                    <CoreText type={TextType.P}>{label}</CoreText>
                  </DropDownMenuItem>
                );
              })}
            </DropDownMenu>
          </Transition>
        </Layout>
      </Layout>
    </ClickOutDetector>
  );
}

export default EventsHeaderNav;
