import React, { useState } from 'react';
import { useHistory } from 'react-router-dom';
import { Tabs, TabItemPublicProps, JustifyContent } from 'twitch-core-ui';

function EventsHeaderTabs() {
  const history = useHistory();
  const [activeTab] = useState(history.location.pathname.includes('workspace') ? 1 : 0);
  const eventsTabs: TabItemPublicProps[] = [
    {
      label: 'Listings',
      onClick: () => history.push('/events')
    },
    {
      label: 'Workspace',
      onClick: () => history.push('/events/workspace')
    }
  ];

  return <Tabs activeTabIndex={activeTab} tabs={eventsTabs} justifyContent={JustifyContent.Start} borderBottom={false} />;
}

export default EventsHeaderTabs;
