import React from 'react';
import { Layout, Placeholder, Display, AlignItems } from 'twitch-core-ui';
import './styles/Placeholder.scss';

function EventsPlaceholder({ loaders = 5, type = '' }) {
  const renderEventType = () => {
    if (type === 'channel') {
      return (
        <Layout padding={{ bottom: 1 }}>
          <Layout display={Display.Flex} alignItems={AlignItems.Start} fullWidth>
            <Layout>
              <Placeholder width={30} height={30} />
            </Layout>
            <Layout padding={{ left: 0.5 }}>
              <Layout padding={{ bottom: 0.5 }}>
                <Placeholder width={120} height={12} />
              </Layout>
              <Placeholder width={80} height={12} />
            </Layout>
            <Layout padding={{ left: 3 }}>
              <Placeholder width={30} height={12} />
            </Layout>
          </Layout>
        </Layout>
      );
    } else if (type === 'season') {
      return (
        <Layout padding={{ bottom: 2 }}>
          <Placeholder width={400} height={28.67} />
        </Layout>
      );
    } else if (type === 'category') {
      return (
        <Layout padding={{ bottom: 2 }}>
          <Layout display={Display.Flex} alignItems={AlignItems.Center}>
            <Layout>
              <Placeholder width={60} height={80} />
            </Layout>
            <Layout padding={{ left: 2, top: 0.5 }}>
              <Layout padding={{ bottom: 0.5 }}>
                <Placeholder width={175} height={24} />
              </Layout>
              <Layout padding={{ bottom: 0.5 }}>
                <Placeholder width={100} height={20} />
              </Layout>
              <Layout padding={{ bottom: 0.5 }}>
                <Placeholder width={185} height={20} />
              </Layout>
            </Layout>
          </Layout>
        </Layout>
      );
    }
  };

  return (
    <Layout className="placeholder">
      {renderEventType()}
      <Layout padding={{ bottom: 0.5 }}>
        <Placeholder height={35} />
      </Layout>
      {[...Array(loaders)].map((_, i) => (
        <Layout padding={{ bottom: 0.5 }} key={i}>
          <Placeholder height={55} />
        </Layout>
      ))}
    </Layout>
  );
}

export default EventsPlaceholder;
