import React from 'react';
import { Layout } from 'twitch-core-ui';
import EventsWorkspaceHeader from './events-workspace-header';
import EventsWorkspaceList from './events-workspace-list';
import { EventsProvider } from '../context/events-context';
import { EventsWorkspaceProvider } from '../context/events-workspace-context';
import './styles/Events.scss';

function EventsWorkspace() {
  return (
    <EventsProvider>
      <EventsWorkspaceProvider>
        <Layout className="events-workspace">
          <EventsWorkspaceHeader />
          <EventsWorkspaceList />
        </Layout>
      </EventsWorkspaceProvider>
    </EventsProvider>
  );
}

export default EventsWorkspace;
