import React from "react"
import { Button, InjectLayout, Position, ZIndex } from "twitch-core-ui"
import "./styles/FileButton.scss";

interface Props {
    accept: string;
    onChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    text: string;
}

/**
 * A nicely formatted button that allows uploading a file when clicked
 */
export const FileButton: React.FC<Props> = (props) => {
    return (
        <Button>
            {props.text}
            <InjectLayout
                position={Position.Absolute}
                attachTop
                attachLeft
                fullWidth
                fullHeight
                zIndex={ZIndex.Above}>
                <input className="upload-button" type="file" name="file" accept={props.accept} onChange={props.onChange}/>
            </InjectLayout>
        </Button>
    )
}
