import React from 'react';
import { Layout, Radio, Input, InputType, InputSize, Display, AlignItems } from 'twitch-core-ui';
import './styles/Form.scss';

function FormRadioInputOption({ option, type, setType, amount, setAmount, disabled }) {
  const { name, label, value } = option;
  return (
    <Layout key={value} margin={{ bottom: 0.5 }} display={Display.Flex} alignItems={AlignItems.Center}>
      <Radio name={name} label={label} disabled={disabled} checked={type === value} onChange={e => setType(e.currentTarget.value)} value={value} />
      <Layout margin={{ left: 1 }}>
        <Input
          type={InputType.Number}
          size={InputSize.Small}
          max={100}
          placeholder="XX.XX"
          value={type === value ? amount : ''}
          disabled={type !== value || disabled}
          onChange={e => setAmount(e.currentTarget.value)}
        />
      </Layout>
    </Layout>
  );
}

export default FormRadioInputOption;
