import React from 'react';
import { Layout, Radio } from 'twitch-core-ui';
import './styles/Form.scss';

function FormRadioOption({ option, type, setType }) {
  const { name, label, value } = option;
  return (
    <Layout key={value} margin={{ bottom: 0.5 }}>
      <Radio name={name} label={label} defaultChecked={type === value} onChange={e => setType(e.currentTarget.value)} value={value} />
    </Layout>
  );
}

export default FormRadioOption;
