import React from 'react';
import { Layout, Display, AlignItems, CoreText, TextType, LoadingSpinner, SpinnerSize } from 'twitch-core-ui';

function Loading({ name = '' }) {
  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Center}>
      <LoadingSpinner size={SpinnerSize.Large} />
      <Layout margin={{ left: 1 }}>
        <CoreText type={TextType.H4}>Loading{!!name && ` ${name}`}...</CoreText>
      </Layout>
    </Layout>
  );
}

export default Loading;
