import React, { useEffect, useState } from 'react';
import {
  Display,
  Layout,
  CoreText,
  SVG,
  SVGAsset,
  SVGType,
  TextType,
  CoreLink,
  JustifyContent,
  Button,
  ButtonSize,
  TextAlign,
  AlignItems,
  AlertBanner,
  AlertBannerType,
  LoadingSpinner,
  SpinnerSize,
  FontSize
} from 'twitch-core-ui';
import { AUTH_URL } from '../utils/config';
import { fetchWithTimeout } from '../utils/helpers';
import './styles/LoginWrapper.scss';

function Login() {
  const [redirectURL, setRedirectURL] = useState('');
  const [error, setError] = useState('');

  useEffect(() => {
    const abortController = new AbortController();
    fetchWithTimeout(`${AUTH_URL}/get-auth-redirect/Atlas`, { signal: abortController.signal })
      .then(res => res.json())
      .then(res => setRedirectURL(res.data))
      .catch(err => {
        if (abortController.signal.aborted) {
          // abortController signal aborted
        } else {
          // TODO: error page?
          setError(err);
          console.error(`[login.tsx]: `, err);
        }
      });
    return () => abortController.abort();
  }, []);

  return (
    <Layout>
      {error && (
        <AlertBanner
          type={AlertBannerType.Error}
          status="Error"
          message={error.toString()}
          closeButton={{
            'aria-label': 'Dismiss Error',
            onClick: () => setError('')
          }}
        />
      )}
      <Layout display={Display.Flex} justifyContent={JustifyContent.Center} padding={5}>
        <Layout className="login-wrapper">
          <Layout display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
            <SVG asset={SVGAsset.LogoGlitch} width={60} height={45} type={SVGType.Brand} />
            <CoreText type={TextType.H2}>Welcome to Atlas!</CoreText>
          </Layout>
          <Layout textAlign={TextAlign.Center} margin={{ top: 1 }}>
            <CoreText type={TextType.P} fontSize={FontSize.Size5}>
              Internal tool for creation, management, and reporting for premium content.
            </CoreText>
          </Layout>
          <Layout margin={{ top: 5 }}>
            {!!redirectURL ? (
              <Button size={ButtonSize.Large} fullWidth linkTo={redirectURL} disabled={!redirectURL}>
                Log In
              </Button>
            ) : (
              <LoadingSpinner fillContent inheritColor size={SpinnerSize.Large} />
            )}
          </Layout>
          <Layout textAlign={TextAlign.Center} margin={{ top: 1 }}>
            <CoreLink linkTo="https://www.twitch.tv/user/account-recovery" targetBlank>
              <CoreText type={TextType.P} fontSize={FontSize.Size5}>
                Trouble logging in?
              </CoreText>
            </CoreLink>
          </Layout>
        </Layout>
      </Layout>
    </Layout>
  );
}

export default Login;
