
import classNames from 'classnames';
import * as React from 'react';
import { ButtonProps, Layout, Modal, ModalBody, ModalFooter, ModalHeader, ModalSize } from 'twitch-core-ui';
import Overlay from './overlay';
import "./styles/ModalOverlay.scss";

interface Props {
    onClickOut?: (e: MouseEvent) => void;
    onClose?: () => void;
    title: string;
    primaryButtonProps?: ButtonProps;
    secondaryButtonProps?: ButtonProps;
    size?: ModalSize;
    wide?: boolean;
}

export const ModalOverlay: React.FC<Props> = (props) => {
    const classes = classNames({
        "modal--wrapper": true,
        "condensed": !props.wide,
        "modal-overlay__wide": props.wide,
    });
    return (
        <Overlay fullWidth={props.wide} onClickOut={(e) => { props.onClickOut?.(e); }}>
            <Layout className={classes}>
                <Modal size={props.size}>
                <ModalHeader
                    title={props.title}
                    closeButton={{
                    'aria-label': 'Close Modal',
                    onClick: () => props.onClose?.()
                    }}
                />
                    <ModalBody>
                    {props.children}
                    </ModalBody>
                <ModalFooter
                    primaryButtonProps={props.primaryButtonProps}
                    secondaryButtonProps={props.secondaryButtonProps}
                />
                </Modal>
            </Layout>
        </Overlay>
    )
}

