import React, { useState } from 'react';
import {
  CoreText,
  Layout,
  Display,
  SVG,
  SVGAsset,
  AlignItems,
  Position,
  ButtonIcon,
  Balloon,
  Interactable,
  InteractableType,
  FontSize,
  BalloonDirection,
  BalloonSize,
  DropDownMenuSeparator,
  BorderRadius,
  ButtonIconSize
} from 'twitch-core-ui';
import ClickOutDetector from './click-out-detector';
import { useSelectedPermissions } from '../context/permissions-context';

function MoreActions({ editAction = undefined, deleteAction = undefined }) {
  const [isMoreOpen, setIsMoreOpen] = useState(false);
  const permissions = useSelectedPermissions();
  const canManageProducts = permissions.includes('Can Manage Products')  || permissions.includes('Manage Owned Channels');

  return canManageProducts ? (
    <Layout position={Position.Relative}>
      <ButtonIcon icon={SVGAsset.More} size={ButtonIconSize.Small} onClick={() => setIsMoreOpen(true)} />
      <ClickOutDetector onClickOut={() => setIsMoreOpen(false)}>
        <Balloon show={isMoreOpen} direction={BalloonDirection.TopRight} size={BalloonSize.Auto}>
          <Layout padding={1}>
            {editAction && (
              <>
                <Interactable
                  type={InteractableType.Alpha}
                  borderRadius={BorderRadius.Medium}
                  onClick={() => {
                    editAction();
                    setIsMoreOpen(false);
                  }}>
                  <Layout padding={0.5} display={Display.Flex} alignItems={AlignItems.Center}>
                    <SVG asset={SVGAsset.Edit} height={15} />
                    <Layout margin={{ left: 0.5 }}>
                      <CoreText fontSize={FontSize.Size6}>Edit</CoreText>
                    </Layout>
                  </Layout>
                </Interactable>
                <DropDownMenuSeparator />
              </>
            )}
            <Interactable
              type={InteractableType.Alpha}
              borderRadius={BorderRadius.Medium}
              onClick={() => {
                deleteAction();
                setIsMoreOpen(false);
              }}>
              <Layout padding={0.5} display={Display.Flex} alignItems={AlignItems.Center}>
                <SVG asset={SVGAsset.Trash} height={15} />
                <Layout margin={{ left: 0.5 }}>
                  <CoreText fontSize={FontSize.Size6}>Delete</CoreText>
                </Layout>
              </Layout>
            </Interactable>
          </Layout>
        </Balloon>
      </ClickOutDetector>
    </Layout>
  ) : null;
}

export default MoreActions;
