import React from 'react';
import { Background, Display, FontSize, AlignItems, Position, StyledLayout, ZIndex } from 'twitch-core-ui';
import NavLinks from './nav-links';
import NavContentCreator from './nav-content-creator';
import NavProfile from './nav-profile';
import './styles/NavHeader.scss';
import { useSelectedPermissions } from '../context/permissions-context';
import { useMasquerade } from '../context/masquerade-context';

function NavHeader({ loading, groupings, updateGroupings }) {
  const permissions = useSelectedPermissions();
  const canEdit = permissions.includes('Can Manage Products') || permissions.includes('Manage Owned Channels');
  const canMasquerade = permissions.includes('Can Masquerade Ldap') && permissions.includes('Can Masquerade ApiKey');
  const [isMasqueradeActive] = useMasquerade();

  return (
    <StyledLayout
      className="nav-header"
      background={Background.Base}
      borderBottom
      position={Position.Fixed}
      attachTop
      attachLeft
      attachRight
      display={Display.Flex}
      fontSize={FontSize.Size4}
      alignItems={AlignItems.Center}
      padding={{ x: 1 }}
      fullWidth
      zIndex={ZIndex.Above}>
      <NavLinks />
      <NavContentCreator updateGroupings={updateGroupings} canEdit={canEdit} />
      <NavProfile canMasquerade={canMasquerade} isMasqueradeActive={isMasqueradeActive} />
    </StyledLayout>
  );
}

export default NavHeader;
