import React from 'react';
import { useHistory } from 'react-router-dom';
import { AnimatedGlitchLogo, CoreLink, Display, Layout, CoreLinkType, AlignItems } from 'twitch-core-ui';

function NavLinks() {
  const history = useHistory();
  const routes = ['Overview', 'Products', 'Events'];
  const { pathname } = history.location;

  return (
    <Layout display={Display.Flex} fullWidth alignItems={AlignItems.Center}>
      <CoreLink linkTo="/">
        <Layout display={Display.Flex} alignItems={AlignItems.Center}>
          <AnimatedGlitchLogo width={40} height={40} />
        </Layout>
      </CoreLink>
      <Layout display={Display.Flex}>
        <CoreLink type={CoreLinkType.Inherit} hoverUnderlineNone linkTo="/" disabledInteraction={pathname === '/'}>
          <Layout padding={{ y: 1 }} margin={{ x: 1 }} className={pathname === '/' ? 'active' : ''}>
            Overview
          </Layout>
        </CoreLink>
      </Layout>
      {routes.slice(1).map(route => {
        return (
          <Layout display={Display.Flex} key={route}>
            <CoreLink
              linkTo={`/${route.toLowerCase()}`}
              type={CoreLinkType.Inherit}
              hoverUnderlineNone
              disabledInteraction={pathname === `/${route.toLowerCase()}`}>
              <Layout padding={{ y: 1 }} margin={{ x: 1 }} className={pathname.includes(route.toLowerCase()) ? 'active' : ''}>
                {route}
              </Layout>
            </CoreLink>
          </Layout>
        );
      })}
    </Layout>
  );
}

export default NavLinks;
