import React, { useEffect, useState } from 'react';
import { Button, Display, Layout, AlignItems } from 'twitch-core-ui';
import { AUTH_URL } from '../utils/config';
import { fetchWithTimeout } from '../utils/helpers';

function NavLogin() {
  const [redirectURL, setRedirectURL] = useState('');

  useEffect(() => {
    const abortController = new AbortController();
    fetchWithTimeout(`${AUTH_URL}/get-auth-redirect/Atlas`, { signal: abortController.signal })
      .then(res => res.json())
      .then(res => setRedirectURL(res.data))
      .catch(err => {
        if (abortController.signal.aborted) {
          // abortController signal aborted
        } else {
          console.error(`[nav-login.tsx]: `, err);
        }
      });
    return () => abortController.abort();
  }, []);

  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Stretch}>
      <Button linkTo={redirectURL}>Log In</Button>
    </Layout>
  );
}

export default NavLogin;
