import React from 'react';
import { Layout, Display, AlignItems, CoreText, TextType, SVG, SVGType, SVGAsset } from 'twitch-core-ui';

function NoResults({ results = 'results', small = false }) {
  let svgSize = small ? 20 : 40;
  let coreTextType = small ? TextType.P : TextType.H4;

  return (
    <Layout display={Display.Flex} alignItems={AlignItems.Center}>
      <SVG type={SVGType.Alt2} asset={SVGAsset.DeadGlitch} width={svgSize} height={svgSize} />
      <Layout margin={{ left: 1 }}>
        <CoreText type={coreTextType}>No {results} found...</CoreText>
      </Layout>
    </Layout>
  );
}

export default NoResults;
