import React from 'react';
import { AlignItems, Background, Color, Display, JustifyContent, Position, StyledLayout } from 'twitch-core-ui';
import ClickOutDetector from './click-out-detector';
import './styles/Overlay.scss';

interface Props {
  children: React.ReactChild;
  onClickOut: (e: MouseEvent) => void;
  isHeader?: boolean;
  fullWidth?: boolean;
}

class Overlay extends React.Component<Props, {}> {
  private bodyWrapper = document.querySelector('.main-wrapper--body');

  componentDidMount() {
    if (!this.props.isHeader) {
      this.bodyWrapper.classList.add('tw-z-above');
    }
  }

  componentWillUnmount() {
    this.bodyWrapper.classList.remove('tw-z-above');
  }

  render() {
    const { children, onClickOut } = this.props;
    return (
      <StyledLayout
        className="overlay"
        background={Background.Overlay}
        color={Color.Base}
        position={Position.Fixed}
        attachTop
        attachLeft
        fullWidth
        fullHeight
        padding={5}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
        alignItems={AlignItems.Center}>
        <ClickOutDetector fullWidth={this.props.fullWidth} onClickOut={onClickOut}>{children}</ClickOutDetector>
      </StyledLayout>
    );
  }
}

export default Overlay;
