import React from 'react';
import { Layout, Placeholder, Display, AlignItems, JustifyContent } from 'twitch-core-ui';

function OverviewBarChartPlaceholder({ loaders = 2 }) {
  return (
    <Layout className="placeholder" display={Display.Flex} alignItems={AlignItems.Center} justifyContent={JustifyContent.Between}>
      {[...Array(loaders)].map((_, i) => (
        <Layout key={i} margin={{ bottom: 5 }}>
          <Layout margin={{ bottom: 1 }}>
            <Placeholder height={26.67} width={200} />
          </Layout>
          <Placeholder height={311} width={780} />
        </Layout>
      ))}
    </Layout>
  );
}

export default OverviewBarChartPlaceholder;
