import React from 'react';
import { Display, Layout, JustifyContent, Pagination, PaginationMouseEvent } from 'twitch-core-ui';
import './styles/LoginWrapper.scss';

function PaginationWrapper({ currentPage, totalPages, setCurrentPage }) {
  const handleClickIndex = (e: PaginationMouseEvent<HTMLDivElement>) => {
    setCurrentPage(e.goToPage);
  };

  const handleClickPrevious = () => {
    setCurrentPage(currentPage - 1);
  };

  const handleClickNext = () => {
    setCurrentPage(currentPage + 1);
  };

  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Center} padding={{ top: 2 }} fullWidth>
      <Pagination
        currentPage={currentPage}
        totalPages={totalPages}
        onClickIndex={handleClickIndex}
        onClickNext={handleClickNext}
        onClickPrevious={handleClickPrevious}
        nextPageButtonAriaLabel="Next Page"
        previousPageButtonAriaLabel="Previous Page"
      />
    </Layout>
  );
}

export default PaginationWrapper;
