import React from 'react';
import Cookies from 'js-cookie';
import { Redirect, Route } from 'react-router-dom';
import MainWrapper from './main-wrapper';

function PrivateRoute({ component: Component, ...rest }) {
  const token = Cookies.get('token');
  const profile = Cookies.get('profile');
  const isLoginValid = token && token.length && profile && profile.length;
  const isTokenExpired = Date.parse(Cookies.get('expireDate')) > Date.now();

  return (
    <Route
      {...rest}
      render={props =>
        isLoginValid && isTokenExpired ? (
          <MainWrapper>
            <Component {...props} />
          </MainWrapper>
        ) : (
          <Redirect to="/login" />
        )
      }
    />
  );
}

export default PrivateRoute;
