import React from 'react';
import { Button, Layout, Display, JustifyContent } from 'twitch-core-ui';
import { useSelectedPermissions } from '../context/permissions-context';

function ProductsHeader() {
  const permissions = useSelectedPermissions();
  const canEdit = permissions.includes('Can Manage Products') || permissions.includes('Manage Owned Channels');

  return (
    <Layout padding={{ bottom: 2 }}>
      {canEdit && (
        <Layout display={Display.Flex} justifyContent={JustifyContent.End}>
          <Layout padding={{ left: 1 }}>
            <Button linkTo="/products/create">Create New Product</Button>
          </Layout>
        </Layout>
      )}
    </Layout>
  );
}

export default ProductsHeader;
