import React from 'react';
import { Layout, Placeholder, Display, FlexWrap, JustifyContent } from 'twitch-core-ui';

function ProductsPlaceholder({ loaders = 3 }) {
  return (
    <Layout className="placeholder products--card-wrapper" display={Display.Flex} flexWrap={FlexWrap.Wrap}>
      {[...Array(loaders)].map((_, i) => (
        <Layout className="products--card loader" margin={{ bottom: 5, right: 4 }} key={i}>
          <div style={{ width: 280 }}>
            <Layout padding={{ bottom: 1 }}>
              <Placeholder height={156} />
            </Layout>
            <Layout padding={{ bottom: 0.5 }} display={Display.Flex} justifyContent={JustifyContent.Between}>
              <Placeholder width={140} height={27.35} />
            </Layout>
            <Layout padding={{ bottom: 0.5 }}>
              <Placeholder width={100} height={20.8} />
            </Layout>
            <Layout padding={{ bottom: 0.5 }}>
              <Placeholder width={200} height={20} />
            </Layout>
            <Layout padding={{ bottom: 0.5 }}>
              <Placeholder height={70.4} />
            </Layout>
          </div>
        </Layout>
      ))}
    </Layout>
  );
}

export default ProductsPlaceholder;
