import React from 'react';
import { Button, Layout, Display, JustifyContent, FlexWrap, AlignItems, Toggle, CoreText, TextType, FontSize } from 'twitch-core-ui';
import { useSelectedPermissions } from '../context/permissions-context';

function SeasonsHeader({ isLegacyVisible, setIsLegacyVisible }) {
  const permissions = useSelectedPermissions();
  const canEdit = permissions.includes('Can Manage Products') || permissions.includes('Manage Owned Channels');

  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Between} flexWrap={FlexWrap.Wrap} alignItems={AlignItems.Center}>
      <Layout padding={{ bottom: 2 }}>
        <Layout display={Display.Flex} alignItems={AlignItems.Center} flexShrink={0}>
          <CoreText type={TextType.Strong} fontSize={FontSize.Size6}>
            Display Past Seasons
          </CoreText>
          <Layout padding={{ x: 1 }}>
            <Toggle checked={isLegacyVisible} onChange={e => setIsLegacyVisible(e.currentTarget.checked)} />
          </Layout>
        </Layout>
      </Layout>
      {canEdit && (
        <Layout padding={{ bottom: 2 }}>
          <Layout display={Display.Flex} justifyContent={JustifyContent.End}>
            <Layout padding={{ left: 1 }}>
              <Button linkTo="/seasons/create">Create New Season</Button>
            </Layout>
          </Layout>
        </Layout>
      )}
    </Layout>
  );
}

export default SeasonsHeader;
