import React from 'react';
import { Layout, Placeholder } from 'twitch-core-ui';

function SeasonsPlaceholder({ loaders = 3 }) {
  return (
    <Layout className="placeholder">
      <Layout padding={{ bottom: 0.5 }}>
        <Placeholder height={35} />
      </Layout>
      {[...Array(loaders)].map((_, i) => (
        <Layout padding={{ bottom: 0.5 }} key={i}>
          <Placeholder height={55} />
        </Layout>
      ))}
    </Layout>
  );
}

export default SeasonsPlaceholder;
