import React from 'react';
import { Layout, Placeholder, Display, JustifyContent, AlignItems } from 'twitch-core-ui';

function SidebarPlaceholder({ loaders = 2 }) {
  return (
    <Layout className="placeholder">
      {[...Array(loaders)].map((_, i) => (
        <Layout padding={{ bottom: 0.5 }} key={i} display={Display.Flex} justifyContent={JustifyContent.Between} alignItems={AlignItems.Center}>
          <Layout>
            <Placeholder width={175} height={35} />
          </Layout>
          <Layout>
            <Placeholder width={25} height={25} />
          </Layout>
        </Layout>
      ))}
    </Layout>
  );
}

export default SidebarPlaceholder;
