import React, { createContext, useContext, useState, useMemo } from 'react';

const ErrorContext = createContext([]);

function useErrorObj() {
  const context = useContext(ErrorContext);
  if (!context) {
    throw new Error(`useErrorObj must be used within a EventProvider`);
  }
  return context;
}

function ErrorProvider(props) {
  const [errorObj, setErrorObj] = useState({});
  const value = useMemo(() => [errorObj, setErrorObj], [errorObj]);
  return <ErrorContext.Provider value={value} {...props} />;
}

export { ErrorProvider, useErrorObj };
