import React, { createContext, useContext, useState, useMemo } from 'react';

const EventsContext = createContext([]);

function useSelectedEvents() {
  const context = useContext(EventsContext);
  if (!context) {
    throw new Error(`useSelectedEvents must be used within a EventProvider`);
  }
  return context;
}

function EventsProvider(props) {
  const [selectedEvents, setSelectedEvents] = useState([]);
  const value = useMemo(() => [selectedEvents, setSelectedEvents], [selectedEvents]);
  return <EventsContext.Provider value={value} {...props} />;
}

export { EventsProvider, useSelectedEvents };
