import React, { createContext, useContext, useState } from 'react';

const MasqueradeContext = createContext([]);

export default MasqueradeContext;

function useMasquerade() {
  const context = useContext(MasqueradeContext);
  if (!context) {
    throw new Error(`useMasquerade() must be used within a MasqueradeProvider`);
  }
  return context;
}

function MasqueradeProvider(props) {
  const [isMasqueradeActive, setIsMasqueradeActive] = useState(localStorage.getItem('masqueradeType') !== null || false);

  return <MasqueradeContext.Provider value={[isMasqueradeActive, setIsMasqueradeActive]} {...props} />;
}

export { MasqueradeProvider, useMasquerade };
