import React, { createContext, useContext, useState, useEffect } from 'react';
import Cookies from 'js-cookie';
import { ATLAS_BASE_URL } from '../utils/config';
import { fetchWithTimeout } from '../utils/helpers';

const PermissionsContext = createContext([]);

function useSelectedPermissions() {
  const context = useContext(PermissionsContext);
  if (!context) {
    throw new Error(`useSelectedPermissions() must be used within a PermissionsProvider`);
  }
  return context;
}

function PermissionsProvider(props) {
  const [selectedPermissions, setSelectedPermissions] = useState([]);

  useEffect(() => {
    getUserPermissions();
  }, []);

  const getUserPermissions = () => {
    fetchWithTimeout(`${ATLAS_BASE_URL}/permission/get-user-permissions`, {
      method: 'POST',
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json',
        Authorization: `Bearer ${Cookies.get('token')}`
      }
    })
      .then(response => response.json())
      .then(response => {
        console.log(`/permission/get-user-permissions: `, response);
        if (response.success) {
          setSelectedPermissions(response.data);
        }
      })
      .catch(error => console.error(`/permission/get-user-permissions: `, error));
  };

  return <PermissionsContext.Provider value={selectedPermissions} {...props} />;
}

export { PermissionsProvider, useSelectedPermissions };
