import {
  useApolloClient as apolloUseClient,
  useLazyQuery as apolloUseLazyQuery,
  useMutation as apolloUseMutation,
  useQuery as apolloUseQuery,
} from "react-apollo";

/**
 * Wrapper for apolloUseQuery based on what we do in Twilight
 */
export const useQuery: typeof apolloUseQuery = (document, opts = {}) => {
  if (opts.partialRefetch !== false) {
    opts.partialRefetch = true;
  }

  return apolloUseQuery(document, opts);
};

/**
 * Wrapper for apolloUseLazyQuery based on what we do in Twilight
 */
export const useLazyQuery: typeof apolloUseLazyQuery = (
  document,
  opts = {},
) => {
  if (opts.partialRefetch !== false) {
    opts.partialRefetch = true;
  }

  return apolloUseLazyQuery(document, opts);
};

export const useMutation = apolloUseMutation;

export const useApolloClient = apolloUseClient;
